/*
 * Decompiled with CFR 0.152.
 */
package com.oblivioussp.spartanweaponry.item;

import com.oblivioussp.spartanweaponry.api.OilEffects;
import com.oblivioussp.spartanweaponry.api.oil.OilEffect;
import com.oblivioussp.spartanweaponry.api.tags.ModItemTags;
import com.oblivioussp.spartanweaponry.init.ModCapabilities;
import com.oblivioussp.spartanweaponry.init.ModItems;
import com.oblivioussp.spartanweaponry.init.ModSounds;
import com.oblivioussp.spartanweaponry.item.BasicItem;
import com.oblivioussp.spartanweaponry.util.OilHelper;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.ForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.RegistryManager;

public class WeaponOilItem
extends BasicItem {
    public WeaponOilItem() {
        super(new Item.Properties().m_41491_(ModItems.TAB_SW).m_41487_(6).m_41495_(Items.f_42590_));
    }

    public void m_6787_(CreativeModeTab tabIn, NonNullList<ItemStack> itemListIn) {
        if (this.m_41389_(tabIn)) {
            ForgeRegistry registry = RegistryManager.ACTIVE.getRegistry(OilEffects.REGISTRY_KEY);
            if (registry != null) {
                registry.forEach(oilEffect -> {
                    if (oilEffect != OilEffects.POTION.get()) {
                        ItemStack stack = OilHelper.makeOilStack(oilEffect);
                        itemListIn.add((Object)stack);
                    }
                });
            }
            ForgeRegistries.POTIONS.forEach(potion -> {
                if (OilHelper.isValidPotion(potion)) {
                    ItemStack stack = OilHelper.makePotionOilStack(potion);
                    itemListIn.add((Object)stack);
                }
            });
        }
    }

    @Override
    public void m_7373_(ItemStack stack, Level levelIn, List<Component> tooltip, TooltipFlag flagIn) {
        super.m_7373_(stack, levelIn, tooltip, flagIn);
        OilEffect oil = OilHelper.getOilFromStack(stack);
        if (oil != OilEffects.NONE.get()) {
            tooltip.add((Component)new TextComponent(""));
            oil.getTooltip(stack, tooltip);
            tooltip.add((Component)new TranslatableComponent("tooltip.spartanweaponry.weapon_oil.uses", new Object[]{oil.getMaxUses()}).m_130940_(ChatFormatting.DARK_GREEN));
        } else {
            tooltip.add((Component)new TranslatableComponent("tooltip.spartanweaponry.weapon_oil.base"));
        }
    }

    public Component m_7626_(ItemStack stack) {
        OilEffect oil = OilHelper.getOilFromStack(stack);
        Potion potion = OilHelper.getPotionFromStack(stack);
        ForgeRegistry registry = RegistryManager.ACTIVE.getRegistry(OilEffects.REGISTRY_KEY);
        ResourceLocation itemLoc = ForgeRegistries.ITEMS.getKey((IForgeRegistryEntry)this);
        TranslatableComponent baseName = new TranslatableComponent("item." + itemLoc.m_135827_() + "." + itemLoc.m_135815_() + "." + registry.getKey((IForgeRegistryEntry)oil).m_135815_());
        return potion == Potions.f_43598_ ? baseName : new TranslatableComponent(potion.m_43492_("item.spartanweaponry.proj_tipped.effect."), new Object[]{baseName});
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level levelIn, Player playerIn, InteractionHand handIn) {
        ItemStack stack = playerIn.m_21120_(handIn);
        OilEffect oil = OilHelper.getOilFromStack(stack);
        if (oil != OilEffects.NONE.get()) {
            InteractionHand oppositeHand = handIn == InteractionHand.MAIN_HAND ? InteractionHand.OFF_HAND : InteractionHand.MAIN_HAND;
            ItemStack oppositeStack = playerIn.m_21120_(oppositeHand);
            if (oppositeStack.m_204117_(ModItemTags.OILABLE_WEAPONS)) {
                LazyOptional oilHandler = oppositeStack.getCapability(ModCapabilities.OIL_CAPABILITY);
                oilHandler.ifPresent(handler -> {
                    if (!handler.isOiled()) {
                        if (oil == OilEffects.POTION.get()) {
                            Potion potion = OilHelper.getPotionFromStack(stack);
                            handler.setPotion(potion, stack);
                        } else {
                            handler.setEffect(oil, stack);
                        }
                        playerIn.m_5661_((Component)new TranslatableComponent("message.spartanweaponry.oil_applied", new Object[]{stack.m_41786_(), oppositeStack.m_41786_()}), true);
                        playerIn.m_5496_((SoundEvent)ModSounds.OIL_APPLIED.get(), 1.0f, 1.0f);
                        ItemStack bottleStack = this.getContainerItem(stack);
                        stack.m_41774_(1);
                        if (stack.m_41613_() == 0) {
                            playerIn.m_21008_(handIn, ItemStack.f_41583_);
                        }
                        playerIn.m_150109_().m_150079_(bottleStack);
                    } else {
                        playerIn.m_5661_((Component)new TranslatableComponent("message.spartanweaponry.weapon_already_oiled", new Object[]{stack.m_41786_(), oppositeStack.m_41786_()}).m_130940_(ChatFormatting.RED), true);
                    }
                });
            } else {
                playerIn.m_5661_((Component)new TranslatableComponent("message.spartanweaponry.no_oilable_weapon", new Object[]{stack.m_41786_()}).m_130940_(ChatFormatting.RED), true);
            }
        }
        return super.m_7203_(levelIn, playerIn, handIn);
    }

    public ItemStack m_5922_(ItemStack p_41409_, Level p_41410_, LivingEntity p_41411_) {
        return super.m_5922_(p_41409_, p_41410_, p_41411_);
    }

    public boolean m_5812_(ItemStack stack) {
        OilEffect oilEffect = OilHelper.getOilFromStack(stack);
        return super.m_5812_(stack) || oilEffect == OilEffects.POTION.get();
    }
}

