/*
 * Decompiled with CFR 0.152.
 */
package com.oblivioussp.spartanweaponry.item;

import com.oblivioussp.spartanweaponry.inventory.QuiverArrowMenu;
import com.oblivioussp.spartanweaponry.item.QuiverBaseItem;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkHooks;

public class QuiverArrowItem
extends QuiverBaseItem {
    public static final ResourceLocation TEXTURE_SMALL = new ResourceLocation("spartanweaponry", "textures/model/quiver_arrow_small.png");
    public static final ResourceLocation TEXTURE_MEDIUM = new ResourceLocation("spartanweaponry", "textures/model/quiver_arrow_medium.png");
    public static final ResourceLocation TEXTURE_LARGE = new ResourceLocation("spartanweaponry", "textures/model/quiver_arrow_large.png");
    public static final ResourceLocation TEXTURE_HUGE = new ResourceLocation("spartanweaponry", "textures/model/quiver_arrow_huge.png");

    public QuiverArrowItem(int inventorySize) {
        super(inventorySize);
    }

    @Override
    public void m_7373_(ItemStack stack, Level levelIn, List<Component> tooltip, TooltipFlag flagIn) {
        tooltip.add((Component)new TranslatableComponent("tooltip.spartanweaponry.modifiers.ammo.type", new Object[]{new TranslatableComponent("tooltip.spartanweaponry.modifiers.ammo.arrow").m_130940_(ChatFormatting.GRAY)}).m_130940_(ChatFormatting.DARK_AQUA));
        super.m_7373_(stack, levelIn, tooltip, flagIn);
    }

    @Override
    public void openGui(ItemStack stack, Player player, QuiverBaseItem.SlotType slotType, int slot) {
        NetworkHooks.openGui((ServerPlayer)((ServerPlayer)player), (MenuProvider)new ContainerProvider((Component)new TranslatableComponent("gui.spartanweaponry.quiver_arrow.title"), stack), buf -> {
            buf.m_130068_((Enum)slotType);
            buf.writeInt(slot);
        });
    }

    @Override
    public boolean isAmmoValid(ItemStack pickedUpStack, ItemStack quiver) {
        return pickedUpStack.m_204117_(ItemTags.f_13161_);
    }

    @Override
    public Optional<TooltipComponent> m_142422_(ItemStack stackIn) {
        return this.makeTooltipImage(stackIn, false);
    }

    protected class ContainerProvider
    implements MenuProvider {
        private final Component displayName;
        private final ItemStack quiverStack;

        protected ContainerProvider(Component displayName, ItemStack quiverStack) {
            this.displayName = displayName;
            this.quiverStack = quiverStack;
        }

        public AbstractContainerMenu m_7208_(int id, Inventory inventory, Player player) {
            return new QuiverArrowMenu(id, inventory, this.quiverStack);
        }

        public Component m_5446_() {
            return this.displayName;
        }
    }
}

