/*
 * Decompiled with CFR 0.152.
 */
package com.oblivioussp.spartanweaponry.item;

import com.oblivioussp.spartanweaponry.api.IReloadable;
import com.oblivioussp.spartanweaponry.api.ReloadableHandler;
import com.oblivioussp.spartanweaponry.api.WeaponMaterial;
import com.oblivioussp.spartanweaponry.api.trait.IRangedTraitCallback;
import com.oblivioussp.spartanweaponry.api.trait.WeaponTrait;
import com.oblivioussp.spartanweaponry.client.ClientHelper;
import com.oblivioussp.spartanweaponry.util.ClientConfig;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ArrowItem;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.tags.ITagManager;

public class LongbowItem
extends BowItem
implements IReloadable {
    protected WeaponMaterial material;
    protected float drawTime = 1.25f;
    protected float maxVelocity = 1.25f;
    protected String modId = null;
    protected String customDisplayName = null;
    protected boolean doCraftCheck = true;
    protected boolean canBeCrafted = true;
    protected List<WeaponTrait> rangedTraits;

    public LongbowItem(Item.Properties prop, WeaponMaterial material) {
        super(prop.m_41503_((int)((float)material.m_6609_() * 2.0f)));
        this.material = material;
        this.maxVelocity = 1.25f;
        if (FMLEnvironment.dist.isClient()) {
            ClientHelper.registerLongbowPropertyOverrides(this);
        }
        ReloadableHandler.addToReloadList(this);
    }

    public LongbowItem(Item.Properties prop, WeaponMaterial material, String customDisplayName) {
        this(prop, material);
        if (material.useCustomDisplayName()) {
            this.customDisplayName = customDisplayName;
        }
    }

    @Override
    public void reload() {
        this.drawTime = 1.25f;
        this.rangedTraits = this.material.getBonusTraits().stream().filter(trait -> trait.isRangedTrait()).collect(Collectors.toUnmodifiableList());
        for (WeaponTrait trait2 : this.rangedTraits) {
            Optional<IRangedTraitCallback> opt = trait2.getRangedCallback();
            if (!opt.isPresent()) continue;
            this.drawTime = opt.get().modifyLongbowDrawTime(this.material, this.drawTime);
        }
    }

    public void m_5551_(ItemStack stack, Level level, LivingEntity entityLiving, int timeLeft) {
        if (entityLiving instanceof Player) {
            Player player = (Player)entityLiving;
            boolean flag = player.m_150110_().f_35937_ || EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44952_, (ItemStack)stack) > 0;
            ItemStack itemstack = player.m_6298_(stack);
            int i = this.m_8105_(stack) - timeLeft;
            if ((i = ForgeEventFactory.onArrowLoose((ItemStack)stack, (Level)level, (Player)((Player)entityLiving), (int)i, (itemstack != null || flag ? 1 : 0) != 0)) < 0) {
                return;
            }
            if (!itemstack.m_41619_() || flag) {
                float f;
                if (itemstack.m_41619_()) {
                    itemstack = new ItemStack((ItemLike)Items.f_42412_);
                }
                if ((double)(f = this.getArrowSpeed(i)) >= 0.1) {
                    boolean flag1;
                    boolean bl = flag1 = player.m_150110_().f_35937_ || itemstack.m_41720_() instanceof ArrowItem && ((ArrowItem)itemstack.m_41720_()).isInfinite(itemstack, stack, player);
                    if (!level.f_46443_) {
                        int k;
                        int j;
                        ArrowItem itemarrow = (ArrowItem)(itemstack.m_41720_() instanceof ArrowItem ? itemstack.m_41720_() : Items.f_42412_);
                        AbstractArrow entityarrow = itemarrow.m_6394_(level, itemstack, (LivingEntity)player);
                        entityarrow.m_37251_((Entity)player, player.f_19860_, player.f_19859_, 0.0f, f * 3.0f, 0.5f);
                        for (WeaponTrait trait : this.rangedTraits) {
                            trait.getRangedCallback().ifPresent(callback -> callback.onProjectileSpawn(this.material, entityarrow));
                        }
                        if (f == this.maxVelocity) {
                            entityarrow.m_36762_(true);
                        }
                        if ((j = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44988_, (ItemStack)stack)) > 0) {
                            entityarrow.m_36781_(entityarrow.m_36789_() + (double)j * 0.5 + 0.5);
                        }
                        if ((k = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44989_, (ItemStack)stack)) > 0) {
                            entityarrow.m_36735_(k);
                        }
                        if (EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44990_, (ItemStack)stack) > 0) {
                            entityarrow.m_20254_(100);
                        }
                        stack.m_41622_(1, (LivingEntity)player, playerEntity -> playerEntity.m_21190_(player.m_7655_()));
                        if (flag1 || player.m_150110_().f_35937_ && (itemstack.m_41720_() == Items.f_42737_ || itemstack.m_41720_() == Items.f_42738_)) {
                            entityarrow.f_36705_ = AbstractArrow.Pickup.CREATIVE_ONLY;
                        }
                        level.m_7967_((Entity)entityarrow);
                    }
                    level.m_6263_((Player)null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11687_, SoundSource.NEUTRAL, 1.0f, 1.0f / (level.f_46441_.nextFloat() * 0.4f + 1.2f) + f * 0.5f);
                    if (!flag1) {
                        itemstack.m_41774_(1);
                        if (itemstack.m_41619_()) {
                            player.m_150109_().m_36057_(itemstack);
                        }
                    }
                    player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
                }
            }
        }
    }

    public float getArrowSpeed(int charge) {
        float f = (float)charge / 20.0f;
        if ((f = (f * f + f * 2.0f) / 3.0f) > this.maxVelocity) {
            f = this.maxVelocity;
        }
        return f;
    }

    public int getItemEnchantability(ItemStack stack) {
        return this.material.m_6601_();
    }

    public boolean m_6832_(ItemStack toRepair, ItemStack repair) {
        return this.material.m_6282_().test(repair);
    }

    public Component m_7626_(ItemStack stack) {
        if (this.customDisplayName == null) {
            return super.m_7626_(stack);
        }
        return new TranslatableComponent(this.customDisplayName, new Object[]{this.material.translateName()});
    }

    public void m_7373_(ItemStack stack, @Nullable Level levelIn, List<Component> tooltip, TooltipFlag flagIn) {
        boolean isShiftPressed = Screen.m_96638_();
        if (this.doCraftCheck && levelIn != null) {
            ITagManager tagManager;
            if (!(((Boolean)ClientConfig.INSTANCE.forceDisableUncraftableTooltips.get()).booleanValue() || this.material.getModId() != "spartanweaponry" || (tagManager = ForgeRegistries.ITEMS.tags()).isKnownTagName(this.material.getRepairTag()) && !tagManager.getTag(this.material.getRepairTag()).isEmpty())) {
                this.canBeCrafted = false;
            }
            this.doCraftCheck = false;
        }
        if (!this.canBeCrafted) {
            tooltip.add((Component)new TranslatableComponent(String.format("tooltip.%s.uncraftable_missing_material", "spartanweaponry"), new Object[]{this.material.getRepairTagName()}).m_130940_(ChatFormatting.RED));
        }
        this.material.addTagErrorTooltip(stack, tooltip);
        if (this.material.hasAnyBonusTraits() && this.rangedTraits != null && !this.rangedTraits.isEmpty()) {
            if (isShiftPressed) {
                tooltip.add((Component)new TranslatableComponent(String.format("tooltip.%s.traits", "spartanweaponry"), new Object[]{new TranslatableComponent("tooltip.spartanweaponry.showing_details").m_130940_(ChatFormatting.DARK_GRAY)}).m_130940_(ChatFormatting.GOLD));
            } else {
                tooltip.add((Component)new TranslatableComponent(String.format("tooltip.%s.traits", "spartanweaponry"), new Object[]{new TranslatableComponent("tooltip.spartanweaponry.show_details", new Object[]{ChatFormatting.DARK_AQUA.toString() + "SHIFT"}).m_130940_(ChatFormatting.DARK_GRAY)}).m_130940_(ChatFormatting.GOLD));
            }
            tooltip.add((Component)new TranslatableComponent(String.format("tooltip.%s.trait.material_bonus", "spartanweaponry")).m_130940_(ChatFormatting.AQUA));
            this.rangedTraits.forEach(trait -> trait.addTooltip(stack, tooltip, isShiftPressed));
            tooltip.add((Component)new TextComponent(""));
        }
        if (isShiftPressed) {
            tooltip.add((Component)new TranslatableComponent(String.format("tooltip.%s.description", "spartanweaponry"), new Object[]{new TranslatableComponent("tooltip.spartanweaponry.showing_details").m_130940_(ChatFormatting.DARK_GRAY)}).m_130940_(ChatFormatting.GOLD));
            tooltip.add((Component)new TranslatableComponent(String.format("tooltip.%s.longbow.desc", "spartanweaponry")).m_130944_(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.ITALIC}));
            tooltip.add((Component)new TranslatableComponent(String.format("tooltip.%s.longbow.desc_2", "spartanweaponry")).m_130944_(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.ITALIC}));
        } else {
            tooltip.add((Component)new TranslatableComponent(String.format("tooltip.%s.description", "spartanweaponry"), new Object[]{new TranslatableComponent("tooltip.spartanweaponry.show_details", new Object[]{ChatFormatting.AQUA.toString() + "SHIFT"}).m_130940_(ChatFormatting.DARK_GRAY)}).m_130940_(ChatFormatting.GOLD));
        }
        tooltip.add((Component)new TextComponent(""));
        tooltip.add((Component)new TranslatableComponent(String.format("tooltip.%s.modifiers.ammo.type", "spartanweaponry"), new Object[]{new TranslatableComponent(String.format("tooltip.%s.modifiers.ammo.arrow", "spartanweaponry")).m_130940_(ChatFormatting.GRAY)}).m_130940_(ChatFormatting.DARK_AQUA));
        tooltip.add((Component)new TranslatableComponent(String.format("tooltip.%s.modifiers.longbow.draw_length", "spartanweaponry"), new Object[]{new TranslatableComponent(String.format("tooltip.%s.modifiers.longbow.draw_length.value", "spartanweaponry"), new Object[]{Float.valueOf(this.drawTime)}).m_130940_(ChatFormatting.GRAY)}).m_130940_(ChatFormatting.DARK_AQUA));
        tooltip.add((Component)new TranslatableComponent(String.format("tooltip.%s.modifiers.longbow.speed_multiplier", "spartanweaponry"), new Object[]{new TranslatableComponent(String.format("tooltip.%s.modifiers.longbow.draw_length.value", "spartanweaponry"), new Object[]{Float.valueOf(this.maxVelocity)}).m_130940_(ChatFormatting.GRAY)}).m_130940_(ChatFormatting.DARK_AQUA));
        tooltip.add((Component)new TextComponent(""));
    }

    public float getNockProgress(ItemStack stack, LivingEntity shooter) {
        return (float)shooter.m_21252_() / (20.0f * this.drawTime);
    }
}

