/*
 * Decompiled with CFR 0.152.
 */
package com.oblivioussp.spartanweaponry.item;

import com.oblivioussp.spartanweaponry.entity.projectile.ArrowBaseEntity;
import com.oblivioussp.spartanweaponry.item.ArrowBaseItem;
import java.util.List;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ForgeRegistries;

public class ArrowBaseTippedItem
extends ArrowBaseItem {
    protected String baseName;

    public ArrowBaseTippedItem(String baseName, float damageModifier, float rangeModifier) {
        super(damageModifier, rangeModifier);
        this.baseName = baseName;
    }

    @Override
    public AbstractArrow m_6394_(Level level, ItemStack stack, LivingEntity shooter) {
        ArrowBaseEntity arrow = new ArrowBaseEntity(level, shooter);
        ItemStack arrowStack = stack.m_41777_();
        arrowStack.m_41764_(1);
        arrow.initEntity(this.damageModifier, this.rangeModifier, arrowStack);
        arrow.setPotionEffect(stack);
        if (arrow.isValid()) {
            return arrow;
        }
        return null;
    }

    public void m_6787_(CreativeModeTab tab, NonNullList<ItemStack> items) {
        if (this.m_41389_(tab)) {
            for (Potion potion : ForgeRegistries.POTIONS) {
                if (potion.m_43488_().isEmpty()) continue;
                ItemStack stack = new ItemStack((ItemLike)this);
                PotionUtils.m_43549_((ItemStack)stack, (Potion)potion);
                items.add((Object)stack);
            }
        }
    }

    @Override
    public void m_7373_(ItemStack stack, Level levelIn, List<Component> tooltip, TooltipFlag flagIn) {
        super.m_7373_(stack, levelIn, tooltip, flagIn);
        tooltip.add((Component)new TextComponent(""));
        PotionUtils.m_43555_((ItemStack)stack, tooltip, (float)0.125f);
    }

    public Component m_7626_(ItemStack stack) {
        Potion potion = PotionUtils.m_43579_((ItemStack)stack);
        String potionKey = potion.m_43492_("item.spartanweaponry.proj_tipped.effect.");
        return new TranslatableComponent(potionKey, new Object[]{new TranslatableComponent("item.spartanweaponry." + this.baseName)});
    }
}

