/*
 * Decompiled with CFR 0.152.
 */
package com.oblivioussp.spartanweaponry.init;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import com.oblivioussp.spartanweaponry.api.oil.OilEffect;
import com.oblivioussp.spartanweaponry.capability.IOilHandler;
import com.oblivioussp.spartanweaponry.command.OilArgument;
import com.oblivioussp.spartanweaponry.command.OilInput;
import com.oblivioussp.spartanweaponry.command.PotionArgument;
import com.oblivioussp.spartanweaponry.command.PotionInput;
import com.oblivioussp.spartanweaponry.init.ModCapabilities;
import com.oblivioussp.spartanweaponry.init.ModSounds;
import com.oblivioussp.spartanweaponry.util.Log;
import com.oblivioussp.spartanweaponry.util.OilHelper;
import java.util.function.Predicate;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.synchronization.ArgumentSerializer;
import net.minecraft.commands.synchronization.ArgumentTypes;
import net.minecraft.commands.synchronization.EmptyArgumentSerializer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraftforge.event.RegisterCommandsEvent;

public class ModCommands {
    private static final DynamicCommandExceptionType ERROR_NO_ITEM = new DynamicCommandExceptionType(object -> new TranslatableComponent("command.spartanweaponry.apply_oil.error.no_item", new Object[]{object}));
    private static final DynamicCommandExceptionType ERROR_INCOMPATIBLE_ITEM = new DynamicCommandExceptionType(object -> new TranslatableComponent("command.spartanweaponry.apply_oil.error.incompatible_item", new Object[]{object}));

    public static void registerCommands(RegisterCommandsEvent ev) {
        Predicate<CommandSourceStack> requireOPPermission = commandSource -> commandSource.m_6761_(2);
        LiteralArgumentBuilder command = (LiteralArgumentBuilder)Commands.m_82127_((String)"spartanweaponry").requires(requireOPPermission);
        command.then(Commands.m_82127_((String)"applyOil").then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).then(Commands.m_82129_((String)"oil", (ArgumentType)OilArgument.oil()).executes(context -> ModCommands.applyOil((CommandSourceStack)context.getSource(), EntityArgument.m_91474_((CommandContext)context, (String)"player"), OilArgument.getOil(context, "oil"))))));
        command.then(Commands.m_82127_((String)"applyPotionOil").then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).then(Commands.m_82129_((String)"potion", (ArgumentType)PotionArgument.potion()).executes(context -> ModCommands.applyPotionOil((CommandSourceStack)context.getSource(), EntityArgument.m_91474_((CommandContext)context, (String)"player"), PotionArgument.getPotion(context, "potion"))))));
        command.then(Commands.m_82127_((String)"clearOil").then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).executes(context -> ModCommands.clearOil((CommandSourceStack)context.getSource(), EntityArgument.m_91474_((CommandContext)context, (String)"player")))));
        LiteralCommandNode mainCommand = ev.getDispatcher().register(command);
        ev.getDispatcher().register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"sw").requires(requireOPPermission)).redirect((CommandNode)mainCommand));
        Log.info("Finished registering commands for Spartan Weaponry!");
    }

    private static int applyOil(CommandSourceStack commandSourceIn, ServerPlayer playerIn, OilInput oilIn) throws CommandSyntaxException {
        ItemStack applyStack = playerIn.m_21205_();
        if (applyStack.m_41619_()) {
            throw ERROR_NO_ITEM.create((Object)playerIn.m_7755_().m_6111_());
        }
        IOilHandler oilHandler = (IOilHandler)applyStack.getCapability(ModCapabilities.OIL_CAPABILITY).orElseThrow(() -> ERROR_INCOMPATIBLE_ITEM.create((Object)applyStack.m_41720_().m_7626_(applyStack).getString()));
        OilEffect oilEffect = oilIn.getEffect();
        ItemStack oilStack = OilHelper.makeOilStack(oilEffect);
        oilHandler.setEffect(oilEffect, ItemStack.f_41583_);
        playerIn.m_6330_((SoundEvent)ModSounds.OIL_APPLIED.get(), playerIn.m_5720_(), 1.0f, 1.0f);
        commandSourceIn.m_81354_((Component)new TranslatableComponent("command.spartanweaponry.apply_oil.success", new Object[]{oilStack.m_41786_(), applyStack.m_41720_().m_7626_(applyStack).getString(), playerIn.m_7755_().getString()}), true);
        return 1;
    }

    private static int applyPotionOil(CommandSourceStack commandSourceIn, ServerPlayer playerIn, PotionInput potionIn) throws CommandSyntaxException {
        ItemStack applyStack = playerIn.m_21205_();
        if (applyStack.m_41619_()) {
            throw ERROR_NO_ITEM.create((Object)playerIn.m_7755_().m_6111_());
        }
        IOilHandler oilHandler = (IOilHandler)applyStack.getCapability(ModCapabilities.OIL_CAPABILITY).orElseThrow(() -> ERROR_INCOMPATIBLE_ITEM.create((Object)applyStack.m_41720_().m_7626_(applyStack).getString()));
        Potion potion = potionIn.getEffect();
        ItemStack oilStack = OilHelper.makePotionOilStack(potion);
        oilHandler.setPotion(potion, ItemStack.f_41583_);
        playerIn.m_6330_((SoundEvent)ModSounds.OIL_APPLIED.get(), playerIn.m_5720_(), 1.0f, 1.0f);
        commandSourceIn.m_81354_((Component)new TranslatableComponent("command.spartanweaponry.apply_potion_oil.success", new Object[]{oilStack.m_41786_(), applyStack.m_41720_().m_7626_(applyStack).getString(), playerIn.m_7755_().getString()}), true);
        return 1;
    }

    private static int clearOil(CommandSourceStack commandSourceIn, ServerPlayer playerIn) throws CommandSyntaxException {
        ItemStack applyStack = playerIn.m_21205_();
        if (applyStack.m_41619_()) {
            throw ERROR_NO_ITEM.create((Object)playerIn.m_7755_().m_6111_());
        }
        IOilHandler oilHandler = (IOilHandler)applyStack.getCapability(ModCapabilities.OIL_CAPABILITY).orElseThrow(() -> ERROR_INCOMPATIBLE_ITEM.create((Object)applyStack.m_41720_().m_7626_(applyStack).getString()));
        oilHandler.clearEffect();
        commandSourceIn.m_81354_((Component)new TranslatableComponent("command.spartanweaponry.clear_oil.success", new Object[]{applyStack.m_41720_().m_7626_(applyStack).getString(), playerIn.m_7755_().getString()}), true);
        return 1;
    }

    public static void registerArgumentSerializers() {
        ArgumentTypes.m_121601_((String)"spartanweaponry:oil", OilArgument.class, (ArgumentSerializer)new EmptyArgumentSerializer(OilArgument::oil));
        ArgumentTypes.m_121601_((String)"spartanweaponry:potion", PotionArgument.class, (ArgumentSerializer)new EmptyArgumentSerializer(PotionArgument::potion));
    }
}

