/*
 * Decompiled with CFR 0.152.
 */
package com.oblivioussp.spartanweaponry.client.model;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Pair;
import com.mojang.math.Transformation;
import com.oblivioussp.spartanweaponry.client.model.OilCoatingItemBakedModel;
import com.oblivioussp.spartanweaponry.util.Log;
import java.util.Collection;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.GsonHelper;
import net.minecraftforge.client.model.CompositeModelState;
import net.minecraftforge.client.model.IModelConfiguration;
import net.minecraftforge.client.model.IModelLoader;
import net.minecraftforge.client.model.ItemLayerModel;
import net.minecraftforge.client.model.PerspectiveMapWrapper;
import net.minecraftforge.client.model.geometry.IModelGeometry;

public class OilCoatedItemModel
implements IModelGeometry<OilCoatedItemModel> {
    private ImmutableList<Material> textures;
    private Material coatingTexture;
    private final ImmutableSet<Integer> fullbrightLayers;

    public OilCoatedItemModel(ImmutableList<Material> texturesIn) {
        this(texturesIn, (ImmutableSet<Integer>)ImmutableSet.of());
    }

    public OilCoatedItemModel(ImmutableList<Material> texturesIn, ImmutableSet<Integer> fullbrightLayersIn) {
        this.textures = texturesIn;
        this.fullbrightLayers = fullbrightLayersIn;
    }

    public BakedModel bake(IModelConfiguration owner, ModelBakery bakery, Function<Material, TextureAtlasSprite> spriteGetter, ModelState modelTransform, ItemOverrides overrides, ResourceLocation modelLocation) {
        ImmutableMap transformMap = PerspectiveMapWrapper.getTransforms((ModelState)new CompositeModelState(owner.getCombinedTransform(), modelTransform));
        Transformation transform = modelTransform.m_6189_();
        TextureAtlasSprite particleSprite = spriteGetter.apply(owner.isTexturePresent("particle") ? owner.resolveTexture("particle") : (Material)this.textures.get(0));
        OilCoatingItemBakedModel.Builder modelBuilder = OilCoatingItemBakedModel.makeBuilder(owner, particleSprite, overrides, (ImmutableMap<ItemTransforms.TransformType, Transformation>)transformMap);
        for (int i = 0; i < this.textures.size(); ++i) {
            if (this.textures.get(i) == this.coatingTexture) continue;
            TextureAtlasSprite texture = spriteGetter.apply((Material)this.textures.get(i));
            boolean fullbright = this.fullbrightLayers.contains((Object)i);
            RenderType renderType = ItemLayerModel.getLayerRenderType((boolean)fullbright);
            modelBuilder.addQuads(renderType, (Collection<BakedQuad>)ItemLayerModel.getQuadsForSprite((int)i, (TextureAtlasSprite)texture, (Transformation)transform, (boolean)fullbright));
        }
        if (this.coatingTexture != null) {
            TextureAtlasSprite coatingTextureSprite = spriteGetter.apply(this.coatingTexture);
            boolean coatingFullbright = false;
            RenderType coatingRenderType = ItemLayerModel.getLayerRenderType((boolean)coatingFullbright);
            modelBuilder.addCoatingQuads(coatingRenderType, (Collection<BakedQuad>)ItemLayerModel.getQuadsForSprite((int)100, (TextureAtlasSprite)coatingTextureSprite, (Transformation)transform, (boolean)coatingFullbright));
        } else {
            Log.error("Coating texture is not present in model: '" + owner.getModelName() + "'");
        }
        return modelBuilder.build();
    }

    public Collection<Material> getTextures(IModelConfiguration owner, Function<ResourceLocation, UnbakedModel> modelGetter, Set<Pair<String, String>> missingTextureErrors) {
        ImmutableList.Builder textureBuilder = ImmutableList.builder();
        int i = 0;
        while (owner.isTexturePresent("layer" + i)) {
            textureBuilder.add((Object)owner.resolveTexture("layer" + i));
            ++i;
        }
        if (owner.isTexturePresent("coating")) {
            this.coatingTexture = owner.resolveTexture("coating");
            textureBuilder.add((Object)this.coatingTexture);
        }
        this.textures = textureBuilder.build();
        return this.textures;
    }

    public static class Loader
    implements IModelLoader<OilCoatedItemModel> {
        public static final Loader INSTANCE = new Loader();

        public void m_6213_(ResourceManager resourceManager) {
        }

        public OilCoatedItemModel read(JsonDeserializationContext deserializationContext, JsonObject modelContents) {
            ImmutableSet.Builder fullbrightBuilder = ImmutableSet.builder();
            if (modelContents.has("fullbright_layers")) {
                JsonArray fullbrightArray = GsonHelper.m_13933_((JsonObject)modelContents, (String)"fullbright_layers");
                for (JsonElement fullbrightElement : fullbrightArray) {
                    fullbrightBuilder.add((Object)fullbrightElement.getAsInt());
                }
            }
            return new OilCoatedItemModel(null, (ImmutableSet<Integer>)fullbrightBuilder.build());
        }
    }
}

