/*
 * Decompiled with CFR 0.152.
 */
package com.oblivioussp.spartanweaponry.client.gui.container;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.oblivioussp.spartanweaponry.client.gui.components.ToggleImageButton;
import com.oblivioussp.spartanweaponry.inventory.QuiverBaseMenu;
import com.oblivioussp.spartanweaponry.network.NetworkHandler;
import com.oblivioussp.spartanweaponry.network.QuiverButtonPacket;
import com.oblivioussp.spartanweaponry.network.QuiverPrioritySlotPacket;
import com.oblivioussp.spartanweaponry.util.Log;
import java.util.List;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class QuiverBaseScreen<T extends QuiverBaseMenu>
extends AbstractContainerScreen<T> {
    protected final ResourceLocation GUI_TEXTURE_SMALL = new ResourceLocation("spartanweaponry", "textures/gui/quiver_small.png");
    protected final ResourceLocation GUI_TEXTURE_MEDIUM = new ResourceLocation("spartanweaponry", "textures/gui/quiver_medium.png");
    protected final ResourceLocation GUI_TEXTURE_LARGE = new ResourceLocation("spartanweaponry", "textures/gui/quiver_large.png");
    protected final ResourceLocation GUI_TEXTURE_HUGE = new ResourceLocation("spartanweaponry", "textures/gui/quiver_huge.png");
    protected final Component PRIORITY_BUTTON_TOOLTIP = new TextComponent("[").m_7220_((Component)new TranslatableComponent("gui.spartanweaponry.set_priority_slot")).m_7220_((Component)new TextComponent("]"));
    protected final Component AMMO_COLLECT_ENABLED_BUTTON_TOOLTIP = new TranslatableComponent("gui.spartanweaponry.ammo_collect_enabled");
    protected final Component AMMO_COLLECT_DISABLED_BUTTON_TOOLTIP = new TranslatableComponent("gui.spartanweaponry.ammo_collect_disabled");
    protected final ResourceLocation texture;
    protected final ItemStack quiver;
    protected final int ammoSlots;
    protected int prioritySlot = 0;
    protected boolean isAmmoCollectEnabled;

    public QuiverBaseScreen(T screenContainer, Inventory inv, Component title) {
        super(screenContainer, inv, title);
        this.quiver = ((QuiverBaseMenu)((Object)screenContainer)).getQuiverStack();
        this.prioritySlot = this.quiver.m_41784_().m_128451_("PrioritySlot");
        this.isAmmoCollectEnabled = this.quiver.m_41784_().m_128471_("AmmoCollect");
        LazyOptional handler = this.quiver.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY);
        this.ammoSlots = handler.isPresent() ? ((IItemHandler)handler.resolve().orElseThrow()).getSlots() : 4;
        switch (this.ammoSlots) {
            case 12: {
                this.texture = this.GUI_TEXTURE_HUGE;
                break;
            }
            case 9: {
                this.texture = this.GUI_TEXTURE_LARGE;
                break;
            }
            case 6: {
                this.texture = this.GUI_TEXTURE_MEDIUM;
                break;
            }
            case 4: {
                this.texture = this.GUI_TEXTURE_SMALL;
                break;
            }
            default: {
                this.texture = new ResourceLocation("spartanweaponry", "textures/gui/missingno.png");
                Log.error("Missing texture for GUI for quiver: " + this.quiver.m_41786_().toString());
            }
        }
    }

    protected void m_7856_() {
        super.m_7856_();
        this.m_142416_((GuiEventListener)new ToggleImageButton(this.isAmmoCollectEnabled, this.f_97735_ - 18, this.f_97736_ + 20, 16, 16, 177, 39, 17, 17, this.texture, 256, 256, button -> {
            this.isAmmoCollectEnabled = !this.isAmmoCollectEnabled;
            NetworkHandler.sendPacketToServer(new QuiverButtonPacket(this.isAmmoCollectEnabled));
        }, this::drawAmmoCollectTooltip, TextComponent.f_131282_));
        for (int i = 0; i < this.ammoSlots; ++i) {
            Slot slot = ((QuiverBaseMenu)this.f_97732_).m_38853_(i);
            this.m_142416_((GuiEventListener)new ImageButton(this.f_97735_ + slot.f_40220_ - 1, this.f_97736_ + slot.f_40221_ - 1, 7, 7, 177, 1, 8, this.texture, 256, 256, button -> {
                this.prioritySlot = this.f_97734_.m_150661_();
                NetworkHandler.sendPacketToServer(new QuiverPrioritySlotPacket(this.f_97734_.m_150661_()));
            }, this::drawButtonTooltip, TextComponent.f_131282_));
        }
    }

    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTicks) {
        this.m_7333_(poseStack);
        super.m_6305_(poseStack, mouseX, mouseY, partialTicks);
        if (((QuiverBaseMenu)this.f_97732_).m_142621_().m_41619_() && this.f_97734_ != null && this.f_97734_.m_6657_()) {
            List tooltipList = this.m_96555_(this.f_97734_.m_7993_());
            if (this.f_97734_.f_40219_ < this.ammoSlots && mouseX > this.f_97735_ + this.f_97734_.f_40220_ - 1 && mouseX < this.f_97735_ + this.f_97734_.f_40220_ + 6 && mouseY > this.f_97736_ + this.f_97734_.f_40221_ - 1 && mouseY < this.f_97736_ + this.f_97734_.f_40221_ + 6) {
                tooltipList.add(0, this.PRIORITY_BUTTON_TOOLTIP);
            }
            this.m_169388_(poseStack, tooltipList, this.f_97734_.m_7993_().m_150921_(), mouseX, mouseY);
        }
    }

    protected void m_7286_(PoseStack poseStack, float partialTicks, int mouseX, int mouseY) {
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157456_((int)0, (ResourceLocation)this.texture);
        this.m_93228_(poseStack, this.f_97735_, this.f_97736_, 0, 0, this.f_97726_, this.f_97727_);
        int offhandY = this.ammoSlots == 12 ? 122 : 104;
        this.m_93228_(poseStack, this.f_97735_ - 27, this.f_97736_ + offhandY, 178, offhandY, 27, 29);
        Slot highlightedSlot = (Slot)((QuiverBaseMenu)this.f_97732_).f_38839_.get(this.prioritySlot);
        QuiverBaseScreen.renderSlotHighlight((PoseStack)poseStack, (int)(this.f_97735_ + highlightedSlot.f_40220_), (int)(this.f_97736_ + highlightedSlot.f_40221_), (int)this.m_93252_(), (int)-2143240128);
    }

    protected void m_7027_(PoseStack poseStack, int mouseX, int mouseY) {
        String name = this.quiver.m_41786_().getString();
        this.f_96547_.m_92883_(poseStack, name, (float)(this.f_97726_ / 2 - this.f_96547_.m_92895_(name) / 2), 5.0f, 0x404040);
        this.f_96547_.m_92883_(poseStack, this.f_169604_.getString(), 8.0f, (float)(42 + (this.ammoSlots == 12 ? 18 : 0)), 0x404040);
    }

    protected void drawButtonTooltip(Button button, PoseStack poseStack, int x, int y) {
        if (((QuiverBaseMenu)this.f_97732_).m_142621_().m_41619_() && this.f_97734_ != null && !this.f_97734_.m_6657_()) {
            this.m_96602_(poseStack, this.PRIORITY_BUTTON_TOOLTIP, x, y);
        }
    }

    protected void drawAmmoCollectTooltip(Button button, PoseStack poseStack, int x, int y) {
        if (((QuiverBaseMenu)this.f_97732_).m_142621_().m_41619_()) {
            this.m_96602_(poseStack, this.isAmmoCollectEnabled ? this.AMMO_COLLECT_ENABLED_BUTTON_TOOLTIP : this.AMMO_COLLECT_DISABLED_BUTTON_TOOLTIP, x, y);
        }
    }
}

