/*
 * Decompiled with CFR 0.152.
 */
package com.oblivioussp.spartanweaponry.client;

import com.oblivioussp.spartanweaponry.api.ModelOverrides;
import com.oblivioussp.spartanweaponry.api.WeaponTraits;
import com.oblivioussp.spartanweaponry.api.oil.OilEffect;
import com.oblivioussp.spartanweaponry.api.trait.WeaponTrait;
import com.oblivioussp.spartanweaponry.block.ExtendedSkullBlock;
import com.oblivioussp.spartanweaponry.client.gui.HudCrosshair;
import com.oblivioussp.spartanweaponry.client.gui.HudLoadState;
import com.oblivioussp.spartanweaponry.client.gui.HudOilUses;
import com.oblivioussp.spartanweaponry.client.gui.HudQuiverAmmo;
import com.oblivioussp.spartanweaponry.client.gui.container.QuiverArrowScreen;
import com.oblivioussp.spartanweaponry.client.gui.container.QuiverBoltScreen;
import com.oblivioussp.spartanweaponry.client.inventory.ClientOilCoatingTooltip;
import com.oblivioussp.spartanweaponry.client.inventory.ClientQuiverTooltip;
import com.oblivioussp.spartanweaponry.client.model.CurioRenderer;
import com.oblivioussp.spartanweaponry.client.model.LargeArrowQuiverModel;
import com.oblivioussp.spartanweaponry.client.model.LargeBoltQuiverModel;
import com.oblivioussp.spartanweaponry.client.model.MediumArrowQuiverModel;
import com.oblivioussp.spartanweaponry.client.model.MediumBoltQuiverModel;
import com.oblivioussp.spartanweaponry.client.model.SmallArrowQuiverModel;
import com.oblivioussp.spartanweaponry.client.model.SmallBoltQuiverModel;
import com.oblivioussp.spartanweaponry.client.renderer.entity.ArrowBaseRenderer;
import com.oblivioussp.spartanweaponry.client.renderer.entity.BoltRenderer;
import com.oblivioussp.spartanweaponry.client.renderer.entity.BoomerangRenderer;
import com.oblivioussp.spartanweaponry.client.renderer.entity.EndermanHeadModel;
import com.oblivioussp.spartanweaponry.client.renderer.entity.ExtendedSkullHelper;
import com.oblivioussp.spartanweaponry.client.renderer.entity.IllagerHeadModel;
import com.oblivioussp.spartanweaponry.client.renderer.entity.JavelinRenderer;
import com.oblivioussp.spartanweaponry.client.renderer.entity.ModelLayers;
import com.oblivioussp.spartanweaponry.client.renderer.entity.PiglinHeadModel;
import com.oblivioussp.spartanweaponry.client.renderer.entity.SimpleArrowRenderer;
import com.oblivioussp.spartanweaponry.client.renderer.entity.ThrowingWeaponRenderer;
import com.oblivioussp.spartanweaponry.client.renderer.entity.TomahawkRenderer;
import com.oblivioussp.spartanweaponry.client.renderer.entity.WitchHeadModel;
import com.oblivioussp.spartanweaponry.init.ModBlockEntities;
import com.oblivioussp.spartanweaponry.init.ModEntities;
import com.oblivioussp.spartanweaponry.init.ModItems;
import com.oblivioussp.spartanweaponry.init.ModMenus;
import com.oblivioussp.spartanweaponry.inventory.tooltip.OilCoatingTooltip;
import com.oblivioussp.spartanweaponry.inventory.tooltip.QuiverTooltip;
import com.oblivioussp.spartanweaponry.item.HeavyCrossbowItem;
import com.oblivioussp.spartanweaponry.item.LongbowItem;
import com.oblivioussp.spartanweaponry.item.QuiverBaseItem;
import com.oblivioussp.spartanweaponry.item.SwordBaseItem;
import com.oblivioussp.spartanweaponry.item.ThrowingWeaponItem;
import com.oblivioussp.spartanweaponry.item.WeaponOilItem;
import com.oblivioussp.spartanweaponry.util.Log;
import com.oblivioussp.spartanweaponry.util.OilHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.client.model.SkullModel;
import net.minecraft.client.model.SkullModelBase;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.renderer.blockentity.SkullBlockRenderer;
import net.minecraft.client.renderer.entity.ThrownItemRenderer;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.SkullBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.RegisterClientReloadListenersEvent;
import net.minecraftforge.client.gui.ForgeIngameGui;
import net.minecraftforge.client.gui.IIngameOverlay;
import net.minecraftforge.client.gui.OverlayRegistry;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class ClientHelper {
    public static final IIngameOverlay LOAD_STATE = HudLoadState::render;
    public static final IIngameOverlay QUIVER_AMMO = HudQuiverAmmo::render;
    public static final IIngameOverlay OIL_USES = HudOilUses::render;
    public static final IIngameOverlay NEW_CROSSHAIR = HudCrosshair::render;

    public static void registerItemRenders() {
        ClientHelper.registerTippedProjectile((Item)ModItems.TIPPED_WOODEN_ARROW.get());
        ClientHelper.registerTippedProjectile((Item)ModItems.TIPPED_COPPER_ARROW.get());
        ClientHelper.registerTippedProjectile((Item)ModItems.TIPPED_IRON_ARROW.get());
        ClientHelper.registerTippedProjectile((Item)ModItems.TIPPED_DIAMOND_ARROW.get());
        ClientHelper.registerTippedProjectile((Item)ModItems.TIPPED_NETHERITE_ARROW.get());
        ClientHelper.registerTippedProjectile((Item)ModItems.TIPPED_BOLT.get());
        ClientHelper.registerTippedProjectile((Item)ModItems.TIPPED_COPPER_BOLT.get());
        ClientHelper.registerTippedProjectile((Item)ModItems.TIPPED_DIAMOND_BOLT.get());
        ClientHelper.registerTippedProjectile((Item)ModItems.TIPPED_NETHERITE_BOLT.get());
        ClientHelper.registerOil((WeaponOilItem)((Object)ModItems.WEAPON_OIL.get()));
        if (ModList.get().isLoaded("curios")) {
            CurioRenderer.register();
        }
    }

    public static void registerMeleeWeaponPropertyOverrides(SwordBaseItem meleeWeapon) {
        ItemProperties.register((Item)meleeWeapon, (ResourceLocation)ModelOverrides.BLOCKING, (stack, world, living, value) -> meleeWeapon.hasWeaponTrait((WeaponTrait)((Object)((Object)WeaponTraits.BLOCK_MELEE.get()))) && living != null && living.m_6117_() && living.m_21211_() == stack ? 1.0f : 0.0f);
        SwordBaseItem weapon = meleeWeapon.getAsItem();
        ItemProperties.register((Item)weapon, (ResourceLocation)ModelOverrides.THROWING, (stack, world, living, value) -> {
            if (living == null || !meleeWeapon.hasWeaponTrait((WeaponTrait)((Object)((Object)WeaponTraits.THROWABLE.get()))) || !stack.m_150930_(living.m_21211_().m_41720_())) {
                return 0.0f;
            }
            return living.m_21252_() > 0 ? 1.0f : 0.0f;
        });
    }

    public static void registerHeavyCrossbowPropertyOverrides(HeavyCrossbowItem crossbow) {
        ItemProperties.register((Item)crossbow, (ResourceLocation)ModelOverrides.PULL, (stack, world, living, value) -> {
            if (living != null) {
                return crossbow.isLoaded(stack) ? 0.0f : (float)crossbow.getLoadingTicks(stack, living) / (float)crossbow.getFullLoadTicks(stack);
            }
            return 0.0f;
        });
        ItemProperties.register((Item)crossbow, (ResourceLocation)ModelOverrides.PULLING, (stack, world, living, value) -> living != null && living.m_6117_() && living.m_21211_() == stack ? 1.0f : 0.0f);
        ItemProperties.register((Item)crossbow, (ResourceLocation)ModelOverrides.CHARGED, (stack, world, living, value) -> crossbow.isLoaded(stack) ? 1.0f : 0.0f);
    }

    public static void registerLongbowPropertyOverrides(LongbowItem longbow) {
        ItemProperties.register((Item)longbow, (ResourceLocation)ModelOverrides.PULLING, (stack, world, living, value) -> living != null && living.m_6117_() && living.m_21211_() == stack ? 1.0f : 0.0f);
        ItemProperties.register((Item)longbow, (ResourceLocation)ModelOverrides.PULL, (stack, world, shooter, value) -> shooter != null && shooter.m_21211_() == stack ? longbow.getNockProgress(stack, shooter) : 0.0f);
    }

    public static void registerThrowingWeaponPropertyOverrides(ThrowingWeaponItem throwingWeapon) {
        ItemProperties.register((Item)throwingWeapon, (ResourceLocation)ModelOverrides.THROWING, (stack, world, living, value) -> {
            if (living == null || !stack.m_150930_(living.m_21211_().m_41720_())) {
                return 0.0f;
            }
            return living.m_21252_() > 0 ? 1.0f : 0.0f;
        });
        ItemProperties.register((Item)throwingWeapon, (ResourceLocation)ModelOverrides.EMPTY, (stack, world, living, value) -> stack.m_41784_().m_128451_("AmmoUsed") == throwingWeapon.getMaxAmmo(stack) ? 1.0f : 0.0f);
    }

    public static void registerQuiverPropertyOverrides(QuiverBaseItem quiver) {
        ItemProperties.register((Item)quiver, (ResourceLocation)ModelOverrides.ARROW, (stack, world, living, value) -> quiver.getAmmoCount(stack));
    }

    public static void registerTippedProjectile(Item arrow) {
        Minecraft.m_91087_().getItemColors().m_92689_((stack, idx) -> idx == 1 ? PotionUtils.m_43575_((ItemStack)stack) : 0xFFFFFF, new ItemLike[]{arrow});
    }

    public static void registerOil(WeaponOilItem oil) {
        Minecraft.m_91087_().getItemColors().m_92689_((stack, idx) -> {
            OilEffect oilEffect = OilHelper.getOilFromStack(stack);
            return idx == 1 ? oilEffect.getColor(stack) : 0xFFFFFF;
        }, new ItemLike[]{oil});
    }

    @SubscribeEvent
    public static void registerEntityRenders(EntityRenderersEvent.RegisterRenderers ev) {
        Log.info("Registering Entity Renderers!");
        ev.registerEntityRenderer((EntityType)ModEntities.ARROW_SW.get(), ArrowBaseRenderer::new);
        ev.registerEntityRenderer((EntityType)ModEntities.ARROW_EXPLOSIVE.get(), rendererProvider -> new SimpleArrowRenderer(rendererProvider, new ResourceLocation("spartanweaponry", "textures/entity/projectiles/explosive_arrow.png")));
        ev.registerEntityRenderer((EntityType)ModEntities.BOLT.get(), BoltRenderer::new);
        ev.registerEntityRenderer((EntityType)ModEntities.BOLT_SPECTRAL.get(), BoltRenderer::new);
        ev.registerEntityRenderer((EntityType)ModEntities.THROWING_WEAPON.get(), ThrowingWeaponRenderer::new);
        ev.registerEntityRenderer((EntityType)ModEntities.THROWING_KNIFE.get(), ThrowingWeaponRenderer::new);
        ev.registerEntityRenderer((EntityType)ModEntities.TOMAHAWK.get(), TomahawkRenderer::new);
        ev.registerEntityRenderer((EntityType)ModEntities.JAVELIN.get(), JavelinRenderer::new);
        ev.registerEntityRenderer((EntityType)ModEntities.BOOMERANG.get(), BoomerangRenderer::new);
        ev.registerEntityRenderer((EntityType)ModEntities.DYNAMITE.get(), ThrownItemRenderer::new);
        ev.registerBlockEntityRenderer((BlockEntityType)ModBlockEntities.EXTENDED_SKULL_TYPE.get(), SkullBlockRenderer::new);
    }

    @SubscribeEvent
    public static void registerModelLayers(EntityRenderersEvent.RegisterLayerDefinitions ev) {
        Log.info("Registering Model Layers!");
        ev.registerLayerDefinition(ModelLayers.SMALL_ARROW_QUIVER, SmallArrowQuiverModel::createLayer);
        ev.registerLayerDefinition(ModelLayers.MEDIUM_ARROW_QUIVER, MediumArrowQuiverModel::createLayer);
        ev.registerLayerDefinition(ModelLayers.LARGE_ARROW_QUIVER, LargeArrowQuiverModel::createLayer);
        ev.registerLayerDefinition(ModelLayers.SMALL_BOLT_QUIVER, SmallBoltQuiverModel::createLayer);
        ev.registerLayerDefinition(ModelLayers.MEDIUM_BOLT_QUIVER, MediumBoltQuiverModel::createLayer);
        ev.registerLayerDefinition(ModelLayers.LARGE_BOLT_QUIVER, LargeBoltQuiverModel::createLayer);
        ev.registerLayerDefinition(ModelLayers.BLAZE_HEAD, SkullModel::m_170948_);
        ev.registerLayerDefinition(ModelLayers.ENDERMAN_HEAD, EndermanHeadModel::createLayer);
        ev.registerLayerDefinition(ModelLayers.SPIDER_HEAD, ExtendedSkullHelper::createSpiderLayer);
        ev.registerLayerDefinition(ModelLayers.CAVE_SPIDER_HEAD, ExtendedSkullHelper::createSpiderLayer);
        ev.registerLayerDefinition(ModelLayers.PIGLIN_HEAD, PiglinHeadModel::createLayer);
        ev.registerLayerDefinition(ModelLayers.ZOMBIFIED_PIGLIN_HEAD, PiglinHeadModel::createLayer);
        ev.registerLayerDefinition(ModelLayers.HUSK_HEAD, ExtendedSkullHelper::createHuskLayer);
        ev.registerLayerDefinition(ModelLayers.STRAY_SKULL, ExtendedSkullHelper::createHeadWithHatLayer);
        ev.registerLayerDefinition(ModelLayers.DROWNED_HEAD, ExtendedSkullHelper::createHeadWithHatLayer);
        ev.registerLayerDefinition(ModelLayers.ILLAGER_HEAD, IllagerHeadModel::createLayer);
        ev.registerLayerDefinition(ModelLayers.WITCH_HEAD, WitchHeadModel::createLayer);
        Log.info("Model Layer registration complete!");
    }

    @SubscribeEvent
    public static void reload(RegisterClientReloadListenersEvent ev) {
        if (ModList.get().isLoaded("curios")) {
            ev.registerReloadListener((PreparableReloadListener)CurioRenderer.INSTANCE);
        }
    }

    @SubscribeEvent
    public static void registerSkullModels(EntityRenderersEvent.CreateSkullModels ev) {
        EntityModelSet entityModelSet = ev.getEntityModelSet();
        ev.registerSkullModel((SkullBlock.Type)ExtendedSkullBlock.Types.BLAZE, (SkullModelBase)new SkullModel(entityModelSet.m_171103_(ModelLayers.BLAZE_HEAD)));
        ev.registerSkullModel((SkullBlock.Type)ExtendedSkullBlock.Types.ENDERMAN, (SkullModelBase)new EndermanHeadModel(entityModelSet.m_171103_(ModelLayers.ENDERMAN_HEAD)));
        ev.registerSkullModel((SkullBlock.Type)ExtendedSkullBlock.Types.SPIDER, (SkullModelBase)new SkullModel(entityModelSet.m_171103_(ModelLayers.SPIDER_HEAD)));
        ev.registerSkullModel((SkullBlock.Type)ExtendedSkullBlock.Types.CAVE_SPIDER, (SkullModelBase)new SkullModel(entityModelSet.m_171103_(ModelLayers.CAVE_SPIDER_HEAD)));
        ev.registerSkullModel((SkullBlock.Type)ExtendedSkullBlock.Types.PIGLIN, (SkullModelBase)new SkullModel(entityModelSet.m_171103_(ModelLayers.PIGLIN_HEAD)));
        ev.registerSkullModel((SkullBlock.Type)ExtendedSkullBlock.Types.ZOMBIE_PIGLIN, (SkullModelBase)new SkullModel(entityModelSet.m_171103_(ModelLayers.ZOMBIFIED_PIGLIN_HEAD)));
        ev.registerSkullModel((SkullBlock.Type)ExtendedSkullBlock.Types.HUSK, (SkullModelBase)new SkullModel(entityModelSet.m_171103_(ModelLayers.HUSK_HEAD)));
        ev.registerSkullModel((SkullBlock.Type)ExtendedSkullBlock.Types.STRAY, (SkullModelBase)new SkullModel(entityModelSet.m_171103_(ModelLayers.STRAY_SKULL)));
        ev.registerSkullModel((SkullBlock.Type)ExtendedSkullBlock.Types.DROWNED, (SkullModelBase)new SkullModel(entityModelSet.m_171103_(ModelLayers.DROWNED_HEAD)));
        ev.registerSkullModel((SkullBlock.Type)ExtendedSkullBlock.Types.ILLAGER, (SkullModelBase)new SkullModel(entityModelSet.m_171103_(ModelLayers.ILLAGER_HEAD)));
        ev.registerSkullModel((SkullBlock.Type)ExtendedSkullBlock.Types.WITCH, (SkullModelBase)new SkullModel(entityModelSet.m_171103_(ModelLayers.WITCH_HEAD)));
    }

    public static void registerSkullTextures() {
        SkullBlockRenderer.f_112519_.put(ExtendedSkullBlock.Types.BLAZE, new ResourceLocation("minecraft", "textures/entity/blaze.png"));
        SkullBlockRenderer.f_112519_.put(ExtendedSkullBlock.Types.ENDERMAN, new ResourceLocation("spartanweaponry", "textures/entity/skull/enderman_head.png"));
        SkullBlockRenderer.f_112519_.put(ExtendedSkullBlock.Types.SPIDER, new ResourceLocation("minecraft", "textures/entity/spider/spider.png"));
        SkullBlockRenderer.f_112519_.put(ExtendedSkullBlock.Types.CAVE_SPIDER, new ResourceLocation("minecraft", "textures/entity/spider/cave_spider.png"));
        SkullBlockRenderer.f_112519_.put(ExtendedSkullBlock.Types.PIGLIN, new ResourceLocation("minecraft", "textures/entity/piglin/piglin.png"));
        SkullBlockRenderer.f_112519_.put(ExtendedSkullBlock.Types.ZOMBIE_PIGLIN, new ResourceLocation("minecraft", "textures/entity/piglin/zombified_piglin.png"));
        SkullBlockRenderer.f_112519_.put(ExtendedSkullBlock.Types.HUSK, new ResourceLocation("minecraft", "textures/entity/zombie/husk.png"));
        SkullBlockRenderer.f_112519_.put(ExtendedSkullBlock.Types.STRAY, new ResourceLocation("spartanweaponry", "textures/entity/skull/stray_skull.png"));
        SkullBlockRenderer.f_112519_.put(ExtendedSkullBlock.Types.DROWNED, new ResourceLocation("spartanweaponry", "textures/entity/skull/drowned_head.png"));
        SkullBlockRenderer.f_112519_.put(ExtendedSkullBlock.Types.ILLAGER, new ResourceLocation("minecraft", "textures/entity/illager/pillager.png"));
        SkullBlockRenderer.f_112519_.put(ExtendedSkullBlock.Types.WITCH, new ResourceLocation("minecraft", "textures/entity/witch.png"));
    }

    public static void registerScreens() {
        MenuScreens.m_96206_((MenuType)((MenuType)ModMenus.QUIVER_ARROW.get()), QuiverArrowScreen::new);
        MenuScreens.m_96206_((MenuType)((MenuType)ModMenus.QUIVER_BOLT.get()), QuiverBoltScreen::new);
    }

    public static void registerHudOverlays() {
        OverlayRegistry.registerOverlayTop((String)"spartanweaponry:LoadState", (IIngameOverlay)LOAD_STATE);
        OverlayRegistry.registerOverlayTop((String)"spartanweaponry:QuiverAmmo", (IIngameOverlay)QUIVER_AMMO);
        OverlayRegistry.registerOverlayTop((String)"spartanweaponry:OilUses", (IIngameOverlay)OIL_USES);
        OverlayRegistry.registerOverlayAbove((IIngameOverlay)ForgeIngameGui.CROSSHAIR_ELEMENT, (String)"spartanweaponry:Crosshair", (IIngameOverlay)NEW_CROSSHAIR);
    }

    public static void registerTooltipComponents() {
        MinecraftForgeClient.registerTooltipComponentFactory(QuiverTooltip.class, ClientQuiverTooltip::new);
        MinecraftForgeClient.registerTooltipComponentFactory(OilCoatingTooltip.class, ClientOilCoatingTooltip::new);
    }
}

