/*
 * Decompiled with CFR 0.152.
 */
package com.oblivioussp.spartanweaponry.capability;

import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class QuiverCapabilityProvider
implements ICapabilitySerializable<CompoundTag> {
    protected ItemStack quiver;
    protected final LazyOptional<ItemStackHandler> handler;
    protected final int inventorySize;

    public QuiverCapabilityProvider(ItemStack stack, int invSize, CompoundTag nbt) {
        this.quiver = stack;
        this.inventorySize = invSize;
        this.handler = LazyOptional.of(() -> new ItemStackHandler(invSize));
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        return CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.orEmpty(cap, this.handler.cast());
    }

    public CompoundTag serializeNBT() {
        return ((ItemStackHandler)this.handler.resolve().get()).serializeNBT();
    }

    public void deserializeNBT(CompoundTag nbt) {
        ((ItemStackHandler)this.handler.resolve().get()).deserializeNBT(nbt);
    }
}

