/*
 * Decompiled with CFR 0.152.
 */
package com.oblivioussp.spartanweaponry.api.trait;

import com.oblivioussp.spartanweaponry.api.trait.WeaponTrait;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;

public class VersatileWeaponTrait
extends WeaponTrait {
    private final TagKey<Block> effectiveBlocks;
    private final String toolName;

    public VersatileWeaponTrait(String type, String modId, TagKey<Block> effectiveBlocksTag, String effectiveToolName) {
        super(type, modId, WeaponTrait.TraitQuality.POSITIVE);
        this.effectiveBlocks = effectiveBlocksTag;
        this.toolName = effectiveToolName;
    }

    @Override
    protected void addTooltipTitle(ItemStack stack, List<Component> tooltip, ChatFormatting ... formatting) {
        MutableComponent titleText = new TextComponent("- ").m_130944_(formatting);
        String toolType = this.effectiveBlocks != null && this.toolName != null && this.toolName != "" ? String.format("tooltip.%s.trait.versatile." + this.toolName, "spartanweaponry") : String.format("tooltip.%s.trait.versatile.nothing", "spartanweaponry");
        tooltip.add((Component)titleText.m_7220_((Component)new TranslatableComponent(String.format("tooltip.%s.trait.%s", this.modId, this.type), new Object[]{new TranslatableComponent(toolType)}).m_130944_(formatting)));
    }

    @Override
    protected void addTooltipDescription(ItemStack stack, List<Component> tooltip) {
        tooltip.add((Component)VersatileWeaponTrait.tooltipIndent().m_7220_((Component)new TranslatableComponent(String.format("tooltip.%s.trait.%s.desc", "spartanweaponry", this.type))).m_130944_(WeaponTrait.DESCRIPTION_FORMAT));
    }

    public TagKey<Block> getEffectiveBlocks() {
        return this.effectiveBlocks;
    }
}

