/*
 * Decompiled with CFR 0.152.
 */
package com.oblivioussp.spartanweaponry.api.data.recipe;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.RequirementsStrategy;
import net.minecraft.advancements.critereon.RecipeUnlockedTrigger;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class ConditionalShapedRecipeBuilder {
    private final Item result;
    private final int count;
    private final List<String> pattern = Lists.newArrayList();
    private final Map<Character, Ingredient> keys = Maps.newLinkedHashMap();
    private final Advancement.Builder advancementBuilder = Advancement.Builder.m_138353_();
    private String group;
    private List<ICondition> conditions = new ArrayList<ICondition>();

    private ConditionalShapedRecipeBuilder(ItemLike resultIn, int countIn) {
        this.result = resultIn.m_5456_();
        this.count = countIn;
    }

    public static ConditionalShapedRecipeBuilder shaped(ItemLike itemIn) {
        return new ConditionalShapedRecipeBuilder(itemIn, 1);
    }

    public static ConditionalShapedRecipeBuilder shaped(ItemLike itemIn, int countIn) {
        return new ConditionalShapedRecipeBuilder(itemIn, countIn);
    }

    public ConditionalShapedRecipeBuilder define(Character character, TagKey<Item> tagIn) {
        return this.define(character, Ingredient.m_204132_(tagIn));
    }

    public ConditionalShapedRecipeBuilder define(Character character, ItemLike itemIn) {
        return this.define(character, Ingredient.m_43929_((ItemLike[])new ItemLike[]{itemIn}));
    }

    public ConditionalShapedRecipeBuilder define(Character character, Ingredient ingredientIn) {
        if (this.keys.containsKey(character)) {
            throw new IllegalArgumentException("Key character '" + character + "' is already defined!");
        }
        if (character.charValue() == ' ') {
            throw new IllegalArgumentException("Key character ' ' (whitespace) cannot be defined as it is reserved!");
        }
        this.keys.put(character, ingredientIn);
        return this;
    }

    public ConditionalShapedRecipeBuilder pattern(String patternIn) {
        if (patternIn.isEmpty() && patternIn.length() != this.pattern.get(0).length()) {
            throw new IllegalArgumentException("Pattern must be the same width on every line!");
        }
        this.pattern.add(patternIn);
        return this;
    }

    public ConditionalShapedRecipeBuilder unlockedBy(String name, CriterionTriggerInstance criterionIn) {
        this.advancementBuilder.m_138386_(name, criterionIn);
        return this;
    }

    public ConditionalShapedRecipeBuilder group(String groupIn) {
        this.group = groupIn;
        return this;
    }

    public ConditionalShapedRecipeBuilder condition(ICondition conditionIn) {
        this.conditions.add(conditionIn);
        return this;
    }

    public void save(Consumer<FinishedRecipe> consumerIn) {
        this.save(consumerIn, ForgeRegistries.ITEMS.getKey((IForgeRegistryEntry)this.result));
    }

    public void save(Consumer<FinishedRecipe> consumerIn, String save) {
        ResourceLocation saveLoc = new ResourceLocation(save);
        ResourceLocation resultLoc = ForgeRegistries.ITEMS.getKey((IForgeRegistryEntry)this.result);
        if (saveLoc.equals((Object)resultLoc)) {
            throw new IllegalStateException("Shaped recipe " + save + " save argument is redundant as it's the same as the item id!");
        }
        this.save(consumerIn, saveLoc);
    }

    public void save(Consumer<FinishedRecipe> consumerIn, ResourceLocation id) {
        this.validate(id);
        this.advancementBuilder.m_138396_(new ResourceLocation("minecraft:recipes/root")).m_138386_("has_the_recipe", (CriterionTriggerInstance)RecipeUnlockedTrigger.m_63728_((ResourceLocation)id)).m_138354_(AdvancementRewards.Builder.m_10009_((ResourceLocation)id)).m_138360_(RequirementsStrategy.f_15979_);
        consumerIn.accept(new Result(id, this.result, this.count, this.group == null ? "" : this.group, this.pattern, this.keys, this.conditions, this.advancementBuilder, new ResourceLocation(id.m_135827_(), "recipes/" + this.result.m_41471_().m_40783_() + "/" + id.m_135815_())));
    }

    private void validate(ResourceLocation id) {
        if (this.pattern.isEmpty()) {
            throw new IllegalStateException("No pattern was defined for recipe " + id + "!");
        }
        HashSet<Character> characters = new HashSet<Character>(this.keys.keySet());
        characters.remove(Character.valueOf(' '));
        for (int iS = 0; iS < this.pattern.size(); ++iS) {
            String s = this.pattern.get(iS);
            if (s.length() != this.pattern.get(0).length()) {
                throw new IllegalStateException("Pattern rows in recipe " + id + " must be the same length! Expected row size " + this.pattern.get(0).length() + "; got " + s.length() + " on row " + iS);
            }
            for (int i = 0; i < s.length(); ++i) {
                char c = s.charAt(i);
                if (!this.keys.containsKey(Character.valueOf(c)) && c != ' ') {
                    throw new IllegalStateException("Pattern in recipe " + id + " uses an undefined key '" + c + "' in location " + iS + ", " + i);
                }
                characters.remove(Character.valueOf(c));
            }
        }
        if (!characters.isEmpty()) {
            throw new IllegalStateException("Defined ingredients are not used in recipe " + id + "!");
        }
        if (this.pattern.size() == 1 && this.pattern.get(0).length() == 1) {
            throw new IllegalStateException("Single item only defined in shaped recipe " + id + "! Use a shapeless recipe instead!");
        }
        if (this.advancementBuilder.m_138405_().isEmpty()) {
            throw new IllegalStateException("Impossible to obtain recipe " + id + "!");
        }
    }

    public class Result
    implements FinishedRecipe {
        private final ResourceLocation id;
        private final Item result;
        private final int count;
        private final String group;
        private final List<String> pattern;
        private final Map<Character, Ingredient> keys;
        private final Advancement.Builder advancementBuilder;
        private final ResourceLocation advancementId;
        private final List<ICondition> conditions;

        public Result(ResourceLocation idIn, Item resultIn, int countIn, String groupIn, List<String> patternIn, Map<Character, Ingredient> keyIn, List<ICondition> conditionsIn, Advancement.Builder advancementBuilderIn, ResourceLocation advancementIdIn) {
            this.id = idIn;
            this.result = resultIn;
            this.count = countIn;
            this.group = groupIn;
            this.pattern = patternIn;
            this.keys = keyIn;
            this.conditions = conditionsIn;
            this.advancementBuilder = advancementBuilderIn;
            this.advancementId = advancementIdIn;
        }

        public void m_7917_(JsonObject json) {
            if (!this.group.isEmpty()) {
                json.addProperty("group", this.group);
            }
            JsonArray patternArray = new JsonArray();
            for (String string : this.pattern) {
                patternArray.add(string);
            }
            json.add("pattern", (JsonElement)patternArray);
            JsonObject keysJson = new JsonObject();
            for (Map.Entry<Character, Ingredient> entry : this.keys.entrySet()) {
                keysJson.add(String.valueOf(entry.getKey()), entry.getValue().m_43942_());
            }
            json.add("key", (JsonElement)keysJson);
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty("item", ForgeRegistries.ITEMS.getKey((IForgeRegistryEntry)this.result).toString());
            if (this.count > 1) {
                jsonObject.addProperty("count", (Number)this.count);
            }
            json.add("result", (JsonElement)jsonObject);
            JsonArray jsonArray = new JsonArray();
            for (ICondition condition : this.conditions) {
                jsonArray.add((JsonElement)CraftingHelper.serialize((ICondition)condition));
            }
            json.add("conditions", (JsonElement)jsonArray);
        }

        public ResourceLocation m_6445_() {
            return this.id;
        }

        public RecipeSerializer<?> m_6637_() {
            return RecipeSerializer.f_44076_;
        }

        public JsonObject m_5860_() {
            return this.advancementBuilder.m_138400_();
        }

        public ResourceLocation m_6448_() {
            return this.advancementId;
        }
    }
}

