/*
 * Decompiled with CFR 0.152.
 */
package com.oblivioussp.spartanweaponry.api.data.model;

import com.oblivioussp.spartanweaponry.api.ModelOverrides;
import com.oblivioussp.spartanweaponry.api.data.OilCoatingTextures;
import com.oblivioussp.spartanweaponry.api.data.model.BaseModels;
import com.oblivioussp.spartanweaponry.api.data.model.OilCoatingItemModelBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ItemModelProvider;
import net.minecraftforge.client.model.generators.ModelFile;

public class ModelGenerator {
    protected final ItemModelProvider itemModelProvider;

    public ModelGenerator(ItemModelProvider itemModelProviderIn) {
        this.itemModelProvider = itemModelProviderIn;
    }

    public ResourceLocation createSimpleModel(Item item) {
        String itemPath = item.getRegistryName().m_135815_();
        return ((ItemModelBuilder)((ItemModelBuilder)this.itemModelProvider.withExistingParent(itemPath, this.itemModelProvider.mcLoc("item/generated"))).texture("layer0", "item/" + itemPath)).getLocation();
    }

    public ResourceLocation createSimpleModel(Item item, ResourceLocation parent) {
        String itemPath = item.getRegistryName().m_135815_();
        return ((ItemModelBuilder)((ItemModelBuilder)this.itemModelProvider.withExistingParent(itemPath, parent)).texture("layer0", "item/" + itemPath)).getLocation();
    }

    public ResourceLocation createMeleeWeaponModels(Item item, ResourceLocation baseModel, ResourceLocation coatingTexture) {
        String itemPath = item.getRegistryName().m_135815_();
        ResourceLocation blockingModel = ((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)((OilCoatingItemModelBuilder)((ItemModelBuilder)this.itemModelProvider.withExistingParent(itemPath + "_blocking", new ResourceLocation(baseModel.m_135827_(), baseModel.m_135815_() + "_blocking"))).customLoader(OilCoatingItemModelBuilder::new)).end()).texture("layer0", "item/" + itemPath)).texture("coating", coatingTexture.m_135815_())).getLocation();
        ResourceLocation throwingModel = ((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)((OilCoatingItemModelBuilder)((ItemModelBuilder)this.itemModelProvider.withExistingParent(itemPath + "_throwing", new ResourceLocation(baseModel.m_135827_(), baseModel.m_135815_() + "_throwing"))).customLoader(OilCoatingItemModelBuilder::new)).end()).texture("layer0", "item/" + itemPath)).texture("coating", coatingTexture.m_135815_())).getLocation();
        return ((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)((OilCoatingItemModelBuilder)((ItemModelBuilder)this.itemModelProvider.withExistingParent(itemPath, baseModel)).customLoader(OilCoatingItemModelBuilder::new)).end()).texture("layer0", "item/" + itemPath)).texture("coating", coatingTexture.m_135815_())).override().predicate(ModelOverrides.BLOCKING, 1.0f).model((ModelFile)new ModelFile.ExistingModelFile(blockingModel, this.itemModelProvider.existingFileHelper)).end().override().predicate(ModelOverrides.THROWING, 1.0f).model((ModelFile)new ModelFile.ExistingModelFile(throwingModel, this.itemModelProvider.existingFileHelper)).end().getLocation();
    }

    public ResourceLocation createCestusModels(Item item, ResourceLocation baseModel, ResourceLocation coatingTexture) {
        String itemPath = item.getRegistryName().m_135815_();
        ResourceLocation blockingModel = ((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.itemModelProvider.withExistingParent(itemPath + "_blocking", new ResourceLocation(baseModel.m_135827_(), baseModel.m_135815_() + "_blocking"))).texture("layer0", "item/" + itemPath)).texture("coating", coatingTexture.m_135815_())).getLocation();
        ResourceLocation throwingModel = ((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.itemModelProvider.withExistingParent(itemPath + "_throwing", new ResourceLocation(baseModel.m_135827_(), baseModel.m_135815_() + "_throwing"))).texture("layer0", "item/" + itemPath)).texture("coating", coatingTexture.m_135815_())).getLocation();
        return ((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.itemModelProvider.withExistingParent(itemPath, baseModel)).texture("layer0", "item/" + itemPath)).texture("coating", coatingTexture.m_135815_())).override().predicate(ModelOverrides.BLOCKING, 1.0f).model((ModelFile)new ModelFile.ExistingModelFile(blockingModel, this.itemModelProvider.existingFileHelper)).end().override().predicate(ModelOverrides.THROWING, 1.0f).model((ModelFile)new ModelFile.ExistingModelFile(throwingModel, this.itemModelProvider.existingFileHelper)).end().getLocation();
    }

    public ResourceLocation createThrowingWeaponModels(Item item, ResourceLocation baseModel, ResourceLocation baseThrowingModel, ResourceLocation emptyModel) {
        String itemPath = item.getRegistryName().m_135815_();
        ResourceLocation throwingModel = ((ItemModelBuilder)((ItemModelBuilder)this.itemModelProvider.withExistingParent(itemPath + "_throwing", baseThrowingModel)).texture("layer0", "item/" + itemPath)).getLocation();
        return ((ItemModelBuilder)((ItemModelBuilder)this.itemModelProvider.withExistingParent(itemPath, baseModel)).texture("layer0", "item/" + itemPath)).override().predicate(ModelOverrides.THROWING, 1.0f).predicate(ModelOverrides.EMPTY, 0.0f).model((ModelFile)new ModelFile.ExistingModelFile(throwingModel, this.itemModelProvider.existingFileHelper)).end().override().predicate(ModelOverrides.EMPTY, 1.0f).model((ModelFile)new ModelFile.ExistingModelFile(emptyModel, this.itemModelProvider.existingFileHelper)).end().getLocation();
    }

    public ResourceLocation createVanillaSwordModels(Item item) {
        String itemPath = item.getRegistryName().m_135815_();
        return ((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)((OilCoatingItemModelBuilder)((ItemModelBuilder)this.itemModelProvider.withExistingParent(itemPath, "minecraft:item/handheld")).customLoader(OilCoatingItemModelBuilder::new)).end()).texture("layer0", "minecraft:item/" + itemPath)).texture("coating", OilCoatingTextures.VANILLA_SWORD.m_135815_())).getLocation();
    }

    public ResourceLocation createDaggerModels(Item item) {
        return this.createMeleeWeaponModels(item, BaseModels.DAGGER, OilCoatingTextures.DAGGER);
    }

    public ResourceLocation createParryingDaggerModels(Item item) {
        return this.createMeleeWeaponModels(item, BaseModels.PARRYING_DAGGER, OilCoatingTextures.PARRYING_DAGGER);
    }

    public ResourceLocation createLongswordModel(Item item) {
        return this.createMeleeWeaponModels(item, BaseModels.LONGSWORD, OilCoatingTextures.LONGSWORD);
    }

    public ResourceLocation createKatanaModel(Item item) {
        return this.createMeleeWeaponModels(item, BaseModels.KATANA, OilCoatingTextures.KATANA);
    }

    public ResourceLocation createSaberModel(Item item) {
        return this.createMeleeWeaponModels(item, BaseModels.SABER, OilCoatingTextures.SABER);
    }

    public ResourceLocation createRapierModel(Item item) {
        return this.createMeleeWeaponModels(item, BaseModels.RAPIER, OilCoatingTextures.RAPIER);
    }

    public ResourceLocation createGreatswordModel(Item item) {
        return this.createMeleeWeaponModels(item, BaseModels.GREATSWORD, OilCoatingTextures.GREATSWORD);
    }

    public ResourceLocation createClubModel(Item item) {
        return this.createMeleeWeaponModels(item, BaseModels.CLUB, OilCoatingTextures.CLUB);
    }

    public ResourceLocation createCestusModel(Item item) {
        return this.createCestusModels(item, BaseModels.CESTUS, OilCoatingTextures.CESTUS);
    }

    public ResourceLocation createBattleHammerModel(Item item) {
        return this.createMeleeWeaponModels(item, BaseModels.BATTLE_HAMMER, OilCoatingTextures.BATTLE_HAMMER);
    }

    public ResourceLocation createWarhammerModel(Item item) {
        return this.createMeleeWeaponModels(item, BaseModels.WARHAMMER, OilCoatingTextures.WARHAMMER);
    }

    public ResourceLocation createSpearModel(Item item) {
        return this.createMeleeWeaponModels(item, BaseModels.SPEAR, OilCoatingTextures.SPEAR);
    }

    public ResourceLocation createHalberdModel(Item item) {
        return this.createMeleeWeaponModels(item, BaseModels.HALBERD, OilCoatingTextures.HALBERD);
    }

    public ResourceLocation createPikeModel(Item item) {
        return this.createMeleeWeaponModels(item, BaseModels.PIKE, OilCoatingTextures.PIKE);
    }

    public ResourceLocation createLanceModel(Item item) {
        return this.createMeleeWeaponModels(item, BaseModels.LANCE, OilCoatingTextures.LANCE);
    }

    public ResourceLocation createLongbowModels(Item item) {
        String itemPath = item.getRegistryName().m_135815_();
        ResourceLocation pulling0 = ((ItemModelBuilder)((ItemModelBuilder)this.itemModelProvider.withExistingParent(itemPath + "_pulling_0", BaseModels.LONGBOW_PULLING)).texture("layer0", "item/" + itemPath + "_pulling_0")).getLocation();
        ResourceLocation pulling1 = ((ItemModelBuilder)((ItemModelBuilder)this.itemModelProvider.withExistingParent(itemPath + "_pulling_1", BaseModels.LONGBOW_PULLING)).texture("layer0", "item/" + itemPath + "_pulling_1")).getLocation();
        ResourceLocation pulling2 = ((ItemModelBuilder)((ItemModelBuilder)this.itemModelProvider.withExistingParent(itemPath + "_pulling_2", BaseModels.LONGBOW_PULLING)).texture("layer0", "item/" + itemPath + "_pulling_2")).getLocation();
        return ((ItemModelBuilder)((ItemModelBuilder)this.itemModelProvider.withExistingParent(itemPath, BaseModels.LONGBOW)).texture("layer0", "item/" + itemPath + "_standby")).override().predicate(ModelOverrides.PULLING, 1.0f).model((ModelFile)new ModelFile.ExistingModelFile(pulling0, this.itemModelProvider.existingFileHelper)).end().override().predicate(ModelOverrides.PULLING, 1.0f).predicate(ModelOverrides.PULL, 0.65f).model((ModelFile)new ModelFile.ExistingModelFile(pulling1, this.itemModelProvider.existingFileHelper)).end().override().predicate(ModelOverrides.PULLING, 1.0f).predicate(ModelOverrides.PULL, 0.9f).model((ModelFile)new ModelFile.ExistingModelFile(pulling2, this.itemModelProvider.existingFileHelper)).end().getLocation();
    }

    public ResourceLocation createHeavyCrossbowModels(Item item) {
        String itemPath = item.getRegistryName().m_135815_();
        ResourceLocation pulling0 = ((ItemModelBuilder)((ItemModelBuilder)this.itemModelProvider.withExistingParent(itemPath + "_pulling_0", BaseModels.HEAVY_CROSSBOW_PULLING)).texture("layer0", "item/" + itemPath + "_pulling_0")).getLocation();
        ResourceLocation pulling1 = ((ItemModelBuilder)((ItemModelBuilder)this.itemModelProvider.withExistingParent(itemPath + "_pulling_1", BaseModels.HEAVY_CROSSBOW_PULLING)).texture("layer0", "item/" + itemPath + "_pulling_1")).getLocation();
        ResourceLocation pulling2 = ((ItemModelBuilder)((ItemModelBuilder)this.itemModelProvider.withExistingParent(itemPath + "_pulling_2", BaseModels.HEAVY_CROSSBOW_PULLING)).texture("layer0", "item/" + itemPath + "_pulling_2")).getLocation();
        ResourceLocation loaded = ((ItemModelBuilder)((ItemModelBuilder)this.itemModelProvider.withExistingParent(itemPath + "_loaded", BaseModels.HEAVY_CROSSBOW_LOADED)).texture("layer0", "item/" + itemPath + "_loaded")).getLocation();
        ResourceLocation firing = ((ItemModelBuilder)((ItemModelBuilder)this.itemModelProvider.withExistingParent(itemPath + "_firing", BaseModels.HEAVY_CROSSBOW_FIRING)).texture("layer0", "item/" + itemPath + "_loaded")).getLocation();
        return ((ItemModelBuilder)((ItemModelBuilder)this.itemModelProvider.withExistingParent(itemPath, BaseModels.HEAVY_CROSSBOW)).texture("layer0", "item/" + itemPath + "_standby")).override().predicate(ModelOverrides.PULLING, 1.0f).model((ModelFile)new ModelFile.ExistingModelFile(pulling0, this.itemModelProvider.existingFileHelper)).end().override().predicate(ModelOverrides.PULLING, 1.0f).predicate(ModelOverrides.PULL, 0.65f).model((ModelFile)new ModelFile.ExistingModelFile(pulling1, this.itemModelProvider.existingFileHelper)).end().override().predicate(ModelOverrides.PULLING, 1.0f).predicate(ModelOverrides.PULL, 1.0f).model((ModelFile)new ModelFile.ExistingModelFile(pulling2, this.itemModelProvider.existingFileHelper)).end().override().predicate(ModelOverrides.CHARGED, 1.0f).model((ModelFile)new ModelFile.ExistingModelFile(loaded, this.itemModelProvider.existingFileHelper)).end().override().predicate(ModelOverrides.PULLING, 1.0f).predicate(ModelOverrides.CHARGED, 1.0f).model((ModelFile)new ModelFile.ExistingModelFile(firing, this.itemModelProvider.existingFileHelper)).end().getLocation();
    }

    public ResourceLocation createThrowingKnifeModels(Item item) {
        return this.createThrowingWeaponModels(item, BaseModels.THROWING_KNIFE, BaseModels.THROWING_KNIFE_THROWING, BaseModels.THROWING_KNIFE_EMPTY);
    }

    public ResourceLocation createTomahawkModels(Item item) {
        return this.createThrowingWeaponModels(item, BaseModels.TOMAHAWK, BaseModels.TOMAHAWK_THROWING, BaseModels.TOMAHAWK_EMPTY);
    }

    public ResourceLocation createJavelinModels(Item item) {
        return this.createThrowingWeaponModels(item, BaseModels.JAVELIN, BaseModels.JAVELIN_THROWING, BaseModels.JAVELIN_EMPTY);
    }

    public ResourceLocation createBoomerangModels(Item item) {
        return this.createThrowingWeaponModels(item, BaseModels.BOOMERANG, BaseModels.BOOMERANG_THROWING, BaseModels.BOOMERANG_EMPTY);
    }

    public ResourceLocation createBattleaxeModel(Item item) {
        return this.createMeleeWeaponModels(item, BaseModels.BATTLEAXE, OilCoatingTextures.BATTLEAXE);
    }

    public ResourceLocation createFlangedMaceModel(Item item) {
        return this.createMeleeWeaponModels(item, BaseModels.FLANGED_MACE, OilCoatingTextures.FLANGED_MACE);
    }

    public ResourceLocation createGlaiveModel(Item item) {
        return this.createMeleeWeaponModels(item, BaseModels.GLAIVE, OilCoatingTextures.GLAIVE);
    }

    public ResourceLocation createQuarterstaffModel(Item item) {
        return this.createMeleeWeaponModels(item, BaseModels.QUARTERSTAFF, OilCoatingTextures.QUARTERSTAFF);
    }

    public ResourceLocation createScytheModel(Item item) {
        return this.createMeleeWeaponModels(item, BaseModels.SCYTHE, OilCoatingTextures.SCYTHE);
    }
}

