/*
 * Decompiled with CFR 0.152.
 */
package com.oblivioussp.spartanweaponry.advancement.criterion;

import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.oblivioussp.spartanweaponry.api.OilEffects;
import com.oblivioussp.spartanweaponry.api.oil.OilEffect;
import javax.annotation.Nullable;
import net.minecraft.advancements.critereon.AbstractCriterionTriggerInstance;
import net.minecraft.advancements.critereon.DeserializationContext;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.SerializationContext;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.GsonHelper;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.RegistryManager;

public class BrewOilTrigger
extends SimpleCriterionTrigger<TriggerInstance> {
    private static final String JSON_OIL = "oil_effect";
    private static final ResourceLocation ID = new ResourceLocation("spartanweaponry", "brew_oil");

    public ResourceLocation m_7295_() {
        return ID;
    }

    protected TriggerInstance createInstance(JsonObject jsonIn, EntityPredicate.Composite predicateIn, DeserializationContext contextIn) {
        OilEffect oilEffect = null;
        if (jsonIn.has(JSON_OIL)) {
            ResourceLocation loc = new ResourceLocation(GsonHelper.m_13906_((JsonObject)jsonIn, (String)JSON_OIL));
            oilEffect = (OilEffect)RegistryManager.ACTIVE.getRegistry(OilEffects.REGISTRY_KEY).getValue(loc);
            if (oilEffect == null) {
                throw new JsonSyntaxException("Unknown Oil Effect: '" + loc + "'");
            }
        }
        return new TriggerInstance(predicateIn, oilEffect);
    }

    public void trigger(ServerPlayer playerIn, OilEffect oilEffectIn) {
        this.m_66234_(playerIn, triggerInstance -> triggerInstance.matches(oilEffectIn));
    }

    public static class TriggerInstance
    extends AbstractCriterionTriggerInstance {
        private final OilEffect oilEffect;

        public TriggerInstance(EntityPredicate.Composite predicateIn, @Nullable OilEffect oilEffectIn) {
            super(ID, predicateIn);
            this.oilEffect = oilEffectIn;
        }

        public static TriggerInstance brewedOil() {
            return new TriggerInstance(EntityPredicate.Composite.f_36667_, null);
        }

        public boolean matches(OilEffect oilEffectIn) {
            return this.oilEffect == null || this.oilEffect == oilEffectIn;
        }

        public JsonObject m_7683_(SerializationContext contextIn) {
            JsonObject json = super.m_7683_(contextIn);
            if (this.oilEffect != null && this.oilEffect != OilEffects.NONE.get()) {
                json.addProperty(BrewOilTrigger.JSON_OIL, RegistryManager.ACTIVE.getRegistry(OilEffects.REGISTRY_KEY).getKey((IForgeRegistryEntry)this.oilEffect).toString());
            }
            return json;
        }
    }
}

