/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.mixin.features.block;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.List;
import java.util.Random;
import me.jellysquid.mods.sodium.client.model.quad.ModelQuadView;
import me.jellysquid.mods.sodium.client.model.vertex.VanillaVertexTypes;
import me.jellysquid.mods.sodium.client.model.vertex.VertexDrain;
import me.jellysquid.mods.sodium.client.model.vertex.formats.quad.QuadVertexSink;
import me.jellysquid.mods.sodium.client.render.texture.SpriteUtil;
import me.jellysquid.mods.sodium.client.util.ModelQuadUtil;
import me.jellysquid.mods.sodium.client.util.color.ColorABGR;
import me.jellysquid.mods.sodium.client.util.rand.XoRoShiRoRandom;
import me.jellysquid.mods.sodium.common.util.DirectionUtil;
import net.minecraft.client.renderer.block.ModelBlockRenderer;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.data.IModelData;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ModelBlockRenderer.class})
public class MixinBlockModelRenderer {
    private final XoRoShiRoRandom random = new XoRoShiRoRandom();

    @Inject(method={"render(Lnet/minecraft/world/BlockRenderView;Lnet/minecraft/client/render/model/BakedModel;Lnet/minecraft/block/BlockState;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/client/util/math/MatrixStack;Lnet/minecraft/client/render/VertexConsumer;ZLjava/util/Random;JI)Z"}, at={@At(value="HEAD")}, cancellable=true)
    private void preRenderBlockInWorld(BlockAndTintGetter world, BakedModel model, BlockState state, BlockPos pos, PoseStack matrixStack, VertexConsumer consumer, boolean cull, Random rand, long seed, int int_1, CallbackInfoReturnable<Boolean> cir) {
    }

    @Overwrite
    public void renderModel(PoseStack.Pose entry, VertexConsumer vertexConsumer, BlockState blockState, BakedModel bakedModel, float red, float green, float blue, int light, int overlay, IModelData data) {
        QuadVertexSink drain = VertexDrain.of(vertexConsumer).createSink(VanillaVertexTypes.QUADS);
        XoRoShiRoRandom random = this.random;
        red = Mth.m_14036_((float)red, (float)0.0f, (float)1.0f);
        green = Mth.m_14036_((float)green, (float)0.0f, (float)1.0f);
        blue = Mth.m_14036_((float)blue, (float)0.0f, (float)1.0f);
        int defaultColor = ColorABGR.pack(red, green, blue, 1.0f);
        for (Direction direction : DirectionUtil.ALL_DIRECTIONS) {
            List quads = bakedModel.getQuads(blockState, direction, (Random)random.setSeedAndReturn(42L), data);
            if (quads.isEmpty()) continue;
            MixinBlockModelRenderer.renderQuad(entry, drain, defaultColor, quads, light, overlay);
        }
        List quads = bakedModel.getQuads(blockState, null, (Random)random.setSeedAndReturn(42L), data);
        if (!quads.isEmpty()) {
            MixinBlockModelRenderer.renderQuad(entry, drain, defaultColor, quads, light, overlay);
        }
        drain.flush();
    }

    private static void renderQuad(PoseStack.Pose entry, QuadVertexSink drain, int defaultColor, List<BakedQuad> list, int light, int overlay) {
        if (list.isEmpty()) {
            return;
        }
        drain.ensureCapacity(list.size() * 4);
        for (BakedQuad bakedQuad : list) {
            int color = bakedQuad.m_111304_() ? defaultColor : -1;
            ModelQuadView quad = (ModelQuadView)bakedQuad;
            for (int i = 0; i < 4; ++i) {
                drain.writeQuad(entry, quad.getX(i), quad.getY(i), quad.getZ(i), color, quad.getTexU(i), quad.getTexV(i), light, overlay, ModelQuadUtil.getFacingNormal(bakedQuad.m_111306_(), quad.getNormal(i)));
            }
            SpriteUtil.markSpriteActive(quad.getSprite());
        }
    }
}

