/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.block;

import dev.architectury.utils.value.IntValue;
import dev.latvian.mods.kubejs.entity.EntityJS;
import dev.latvian.mods.kubejs.level.BlockContainerJS;
import dev.latvian.mods.kubejs.player.PlayerEventJS;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class BlockBreakEventJS
extends PlayerEventJS {
    private final ServerPlayer entity;
    private final Level level;
    private final BlockPos pos;
    private final BlockState state;
    @Nullable
    private final IntValue xp;

    public BlockBreakEventJS(ServerPlayer entity, Level level, BlockPos pos, BlockState state, @Nullable IntValue xp) {
        this.entity = entity;
        this.level = level;
        this.pos = pos;
        this.state = state;
        this.xp = xp;
    }

    @Override
    public boolean canCancel() {
        return true;
    }

    @Override
    public EntityJS getEntity() {
        return this.entityOf((Entity)this.entity);
    }

    public BlockContainerJS getBlock() {
        return new BlockContainerJS(this.level, this.pos){

            @Override
            public BlockState getBlockState() {
                return BlockBreakEventJS.this.state;
            }
        };
    }

    public int getXp() {
        if (this.xp == null) {
            return 0;
        }
        return this.xp.getAsInt();
    }

    public void setXp(int xp) {
        if (this.xp != null) {
            this.xp.accept(xp);
        }
    }
}

