/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.rhino.mod.util;

import dev.latvian.mods.rhino.mod.util.RemapperException;
import dev.latvian.mods.rhino.mod.util.RemappingHelper;
import java.io.OutputStream;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang3.mutable.MutableObject;
import org.jetbrains.annotations.Nullable;

public class MojangMappings {
    private final String mcVersion;
    private final Map<String, ClassDef> classes;
    private final Map<String, ClassDef> classesMM;
    private final Map<TypeDef, TypeDef> allTypes;
    private final Map<MethodDefSignature, MethodDefSignature> methodSignatures;
    private final ClassDef VOID = new ClassDef(this, "void").descriptor("V");
    private final ClassDef BOOLEAN = new ClassDef(this, "boolean").descriptor("Z");
    private final ClassDef CHAR = new ClassDef(this, "char").descriptor("C");
    private final ClassDef BYTE = new ClassDef(this, "byte").descriptor("B");
    private final ClassDef SHORT = new ClassDef(this, "short").descriptor("S");
    private final ClassDef INT = new ClassDef(this, "int").descriptor("I");
    private final ClassDef LONG = new ClassDef(this, "long").descriptor("J");
    private final ClassDef FLOAT = new ClassDef(this, "float").descriptor("F");
    private final ClassDef DOUBLE = new ClassDef(this, "double").descriptor("D");
    private final MethodDefSignature SIG_EMPTY = new MethodDefSignature(new TypeDef[0]);

    private MojangMappings(String mc) {
        this.mcVersion = mc;
        this.classes = new HashMap<String, ClassDef>();
        this.classesMM = new HashMap<String, ClassDef>();
        this.allTypes = new HashMap<TypeDef, TypeDef>();
        this.methodSignatures = new HashMap<MethodDefSignature, MethodDefSignature>();
        for (ClassDef c : new ClassDef[]{this.VOID, this.BOOLEAN, this.CHAR, this.BYTE, this.SHORT, this.INT, this.LONG, this.FLOAT, this.DOUBLE}) {
            this.classes.put(c.rawName, c);
            this.allTypes.put(c.noArrayType, c.noArrayType);
        }
    }

    public MethodDefSignature getSignature(TypeDef[] types) {
        if (types.length == 0) {
            return this.SIG_EMPTY;
        }
        if (types.length == 1) {
            return types[0].getSingleArgumentSignature();
        }
        MethodDefSignature sig = new MethodDefSignature(types);
        MethodDefSignature cached = this.methodSignatures.get(sig);
        if (cached != null) {
            return cached;
        }
        this.methodSignatures.put(sig, sig);
        return sig;
    }

    public MethodDefSignature readSignatureFromDescriptor(String descriptor) throws Exception {
        ArrayList<TypeDef> types;
        block18: {
            if (descriptor.length() >= 2 && descriptor.charAt(0) == '(' && descriptor.charAt(1) == ')') {
                return this.SIG_EMPTY;
            }
            StringReader reader = new StringReader(descriptor);
            types = new ArrayList<TypeDef>(2);
            while (true) {
                int c;
                if ((c = reader.read()) == 40) {
                    continue;
                }
                int array = 0;
                while (c == 91) {
                    ++array;
                    c = reader.read();
                }
                if (c == -1 || c == 41) break block18;
                if (c == 76) {
                    StringBuilder sb = new StringBuilder();
                    while (true) {
                        if ((c = reader.read()) == -1) {
                            throw new RemapperException("Invalid descriptor: " + descriptor);
                        }
                        if (c == 59) break;
                        if (c == 47) {
                            sb.append('.');
                            continue;
                        }
                        sb.append((char)c);
                    }
                    types.add(this.getType((String)sb.toString()).parent.array(array));
                    continue;
                }
                if (c == 90) {
                    types.add(this.BOOLEAN.array(array));
                    continue;
                }
                if (c == 67) {
                    types.add(this.CHAR.array(array));
                    continue;
                }
                if (c == 66) {
                    types.add(this.BYTE.array(array));
                    continue;
                }
                if (c == 83) {
                    types.add(this.SHORT.array(array));
                    continue;
                }
                if (c == 73) {
                    types.add(this.INT.array(array));
                    continue;
                }
                if (c == 74) {
                    types.add(this.LONG.array(array));
                    continue;
                }
                if (c == 70) {
                    types.add(this.FLOAT.array(array));
                    continue;
                }
                if (c == 68) {
                    types.add(this.DOUBLE.array(array));
                    continue;
                }
                if (c != 86) break;
                types.add(this.VOID.array(array));
            }
            throw new RemapperException("Invalid descriptor: " + descriptor);
        }
        if (types.isEmpty()) {
            return this.SIG_EMPTY;
        }
        if (types.size() == 1) {
            return ((TypeDef)types.get(0)).getSingleArgumentSignature();
        }
        return this.getSignature(types.toArray(new TypeDef[0]));
    }

    @Nullable
    public ClassDef getClass(String name) {
        ClassDef mmc = this.classesMM.get(name);
        return mmc != null ? mmc : this.classes.get(name);
    }

    public TypeDef getType(String string) {
        int array = 0;
        while (string.endsWith("[]")) {
            ++array;
            string = string.substring(0, string.length() - 2);
        }
        while (string.startsWith("[")) {
            ++array;
            string = string.substring(1);
        }
        ClassDef c = this.getClass(string);
        if (c != null) {
            return c.array(array);
        }
        c = new ClassDef(this, string);
        this.classes.put(string, c);
        this.allTypes.put(c.noArrayType, c.noArrayType);
        return c.array(array);
    }

    private static boolean invalidLine(String s) {
        return s.isBlank() || s.startsWith("#") || s.endsWith("init>") || s.contains(".package-info ");
    }

    private void parse0(List<String> lines) {
        lines.removeIf(MojangMappings::invalidLine);
        for (String line : lines) {
            if (line.charAt(line.length() - 1) != ':') continue;
            String[] s = line.split(" -> ", 2);
            ClassDef c = new ClassDef(this, s[1].substring(0, s[1].length() - 1), s[0], new HashMap<NamedSignature, MemberDef>(0), new HashSet<NamedSignature>(0));
            c.mapped = true;
            this.classes.put(c.rawName, c);
            this.classesMM.put(c.mmName, c);
            this.allTypes.put(c.noArrayType, c.noArrayType);
        }
        ClassDef currentClassDef = null;
        for (String line : lines) {
            if (line.charAt(0) == ' ') {
                MethodDefSignature sig;
                String name;
                if (currentClassDef == null) {
                    throw new RemapperException("Field or method without class! " + line);
                }
                line = line.substring(Math.max(4, line.lastIndexOf(58) + 1));
                int typeSpace = line.indexOf(32);
                TypeDef type = this.getType(line.substring(0, typeSpace));
                line = line.substring(typeSpace + 1);
                String rawName = line.substring(line.lastIndexOf(32) + 1);
                if ((line = line.substring(0, line.indexOf(32))).charAt(line.length() - 1) == ')') {
                    int lp = line.indexOf(40);
                    name = line.substring(0, lp);
                    if ((line = line.substring(lp + 1, line.length() - 1)).isEmpty()) {
                        sig = this.SIG_EMPTY;
                    } else {
                        String[] sclasses = line.split(",");
                        TypeDef[] types = new TypeDef[sclasses.length];
                        for (int i = 0; i < sclasses.length; ++i) {
                            types[i] = this.getType(sclasses[i]);
                        }
                        sig = this.getSignature(types);
                    }
                } else {
                    name = line;
                    sig = null;
                }
                NamedSignature rawNameSig = new NamedSignature(rawName, sig);
                if (name.startsWith("lambda$") || name.startsWith("access$") || line.startsWith("val$") || line.startsWith("this$")) {
                    currentClassDef.ignoredMembers.add(rawNameSig);
                    continue;
                }
                MemberDef m = new MemberDef(currentClassDef, rawNameSig, name, type, (MutableObject<String>)new MutableObject((Object)""));
                currentClassDef.members.put(rawNameSig, m);
                continue;
            }
            if (line.charAt(line.length() - 1) != ':') continue;
            currentClassDef = this.classes.get(line.substring(line.lastIndexOf(32) + 1, line.length() - 1));
        }
    }

    public void cleanup() {
        this.classes.values().removeIf(ClassDef::cleanup);
    }

    public void updateOccurrences() {
        for (TypeDef typeDef : this.allTypes.values()) {
            typeDef.occurrences = 0;
        }
        for (MethodDefSignature methodDefSignature : this.methodSignatures.values()) {
            methodDefSignature.occurrences = 0;
        }
        for (ClassDef classDef : this.classes.values()) {
            for (MemberDef m : classDef.members.values()) {
                if (m.rawName.signature == null || m.rawName.signature.types.length <= 0) continue;
                ++m.rawName.signature.occurrences;
                for (TypeDef t : m.rawName.signature.types) {
                    ++t.occurrences;
                }
            }
        }
    }

    private static void writeVarInt(OutputStream stream, int value) throws Exception {
        RemappingHelper.writeVarInt(stream, value);
    }

    private static void writeUtf(OutputStream stream, String value) throws Exception {
        RemappingHelper.writeUtf(stream, value);
    }

    public void write(OutputStream stream) throws Exception {
        this.cleanup();
        this.updateOccurrences();
        ArrayList<TypeDef> typeDefList = new ArrayList<TypeDef>(this.allTypes.values());
        typeDefList.sort(TypeDef::compareTo);
        ArrayList<TypeDef> unmappedTypes = new ArrayList<TypeDef>();
        ArrayList<TypeDef> mappedTypes = new ArrayList<TypeDef>();
        ArrayList<TypeDef> arrayTypes = new ArrayList<TypeDef>();
        for (int i = 0; i < typeDefList.size(); ++i) {
            TypeDef c = typeDefList.get(i);
            c.index = i;
            if (c.array > 0) {
                arrayTypes.add(c);
                continue;
            }
            if (c.parent.mapped) {
                mappedTypes.add(c);
                continue;
            }
            unmappedTypes.add(c);
        }
        ArrayList<MethodDefSignature> sigList = new ArrayList<MethodDefSignature>(this.methodSignatures.values());
        sigList.sort(MethodDefSignature::compareTo);
        for (int i = 0; i < sigList.size(); ++i) {
            sigList.get((int)i).index = i;
        }
        RemappingHelper.LOGGER.info("Total Types: " + typeDefList.size());
        RemappingHelper.LOGGER.info("Total Signatures: " + sigList.size());
        RemappingHelper.LOGGER.info("Unmapped Types: " + unmappedTypes.size());
        RemappingHelper.LOGGER.info("Mapped Types: " + mappedTypes.size());
        RemappingHelper.LOGGER.info("Array Types: " + arrayTypes.size());
        stream.write(0);
        stream.write(1);
        MojangMappings.writeUtf(stream, this.mcVersion);
        MojangMappings.writeVarInt(stream, unmappedTypes.size());
        MojangMappings.writeVarInt(stream, mappedTypes.size());
        MojangMappings.writeVarInt(stream, arrayTypes.size());
        for (TypeDef c : unmappedTypes) {
            MojangMappings.writeVarInt(stream, c.index);
            MojangMappings.writeUtf(stream, c.parent.rawName);
        }
        for (TypeDef c : mappedTypes) {
            MojangMappings.writeVarInt(stream, c.index);
            MojangMappings.writeUtf(stream, (String)c.parent.unmappedName.getValue());
            MojangMappings.writeUtf(stream, c.parent.mmName);
        }
        for (TypeDef c : arrayTypes) {
            MojangMappings.writeVarInt(stream, c.index);
            MojangMappings.writeVarInt(stream, c.parent.noArrayType.index);
            MojangMappings.writeVarInt(stream, c.array);
        }
        MojangMappings.writeVarInt(stream, sigList.size());
        for (MethodDefSignature s : sigList) {
            MojangMappings.writeVarInt(stream, s.types.length);
            for (TypeDef c : s.types) {
                MojangMappings.writeVarInt(stream, c.index);
            }
        }
        for (TypeDef c : mappedTypes) {
            ArrayList<MemberDef> fields = new ArrayList<MemberDef>();
            ArrayList<MemberDef> arg0methods = new ArrayList<MemberDef>();
            ArrayList<MemberDef> argNmethods = new ArrayList<MemberDef>();
            for (MemberDef f : c.parent.members.values()) {
                if (f.rawName.signature == null) {
                    fields.add(f);
                    continue;
                }
                if (f.rawName.signature.types.length == 0) {
                    arg0methods.add(f);
                    continue;
                }
                argNmethods.add(f);
            }
            MojangMappings.writeVarInt(stream, fields.size());
            MojangMappings.writeVarInt(stream, arg0methods.size());
            MojangMappings.writeVarInt(stream, argNmethods.size());
            for (MemberDef m : fields) {
                MojangMappings.writeUtf(stream, (String)m.unmappedName.getValue());
                MojangMappings.writeUtf(stream, m.mmName);
            }
            for (MemberDef m : arg0methods) {
                MojangMappings.writeUtf(stream, (String)m.unmappedName.getValue());
                MojangMappings.writeUtf(stream, m.mmName);
            }
            for (MemberDef m : argNmethods) {
                MojangMappings.writeUtf(stream, (String)m.unmappedName.getValue());
                MojangMappings.writeUtf(stream, m.mmName);
                MojangMappings.writeVarInt(stream, m.rawName.signature.index);
            }
        }
    }

    public static MojangMappings parse(String mcVersion, List<String> lines) throws Exception {
        MojangMappings mappings = new MojangMappings(mcVersion);
        mappings.parse0(lines);
        return mappings;
    }

    public static final class ClassDef {
        public final MojangMappings mappings;
        public final String rawName;
        public final String mmName;
        public final String displayName;
        public final Map<NamedSignature, MemberDef> members;
        public final Set<NamedSignature> ignoredMembers;
        private final MutableObject<String> unmappedName;
        public boolean mapped;
        public TypeDef noArrayType;
        public String rawDescriptor;

        public ClassDef(MojangMappings mappings, String rawName, String mmName, Map<NamedSignature, MemberDef> members, Set<NamedSignature> ignoredMembers) {
            this.mappings = mappings;
            this.rawName = rawName;
            this.mmName = mmName;
            String dn = mmName.isEmpty() ? rawName : mmName;
            int dni = dn.lastIndexOf(46);
            this.displayName = dni == -1 ? dn : dn.substring(dni + 1);
            this.members = members;
            this.ignoredMembers = ignoredMembers;
            this.unmappedName = new MutableObject((Object)"");
            this.mapped = false;
            this.noArrayType = new TypeDef(this, 0);
        }

        public ClassDef(MojangMappings mappings, String name) {
            this(mappings, name, "", Map.of(), Set.of());
        }

        public ClassDef descriptor(String s) {
            this.rawDescriptor = s;
            return this;
        }

        private TypeDef array(int a) {
            if (a == 0) {
                return this.noArrayType;
            }
            TypeDef t = new TypeDef(this, a);
            TypeDef t1 = this.mappings.allTypes.get(t);
            if (t1 == null) {
                this.mappings.allTypes.put(t, t);
                return t;
            }
            return t1;
        }

        public int hashCode() {
            return this.rawName.hashCode();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object obj) {
            if (obj == this) return true;
            if (!(obj instanceof ClassDef)) return false;
            ClassDef other = (ClassDef)obj;
            if (!this.rawName.equals(other.rawName)) return false;
            return true;
        }

        public String toString() {
            return this.displayName;
        }

        public MutableObject<String> unmappedName() {
            return this.unmappedName;
        }

        public String getRawDescriptor() {
            if (this.rawDescriptor == null) {
                this.rawDescriptor = "L" + this.rawName.replace('.', '/') + ";";
            }
            return this.rawDescriptor;
        }

        public boolean cleanup() {
            if (this.mapped) {
                this.members.values().removeIf(MemberDef::cleanup);
                return this.members.isEmpty() && ((String)this.unmappedName.getValue()).isEmpty();
            }
            return false;
        }
    }

    public static class MethodDefSignature {
        public final TypeDef[] types;
        public int occurrences;
        public int index;

        public MethodDefSignature(TypeDef ... types) {
            this.types = types;
            this.occurrences = 0;
            this.index = -1;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object o) {
            if (this == o) return true;
            if (!(o instanceof MethodDefSignature)) return false;
            MethodDefSignature sig = (MethodDefSignature)o;
            if (!Arrays.equals(this.types, sig.types)) return false;
            return true;
        }

        public int hashCode() {
            return Arrays.hashCode(this.types);
        }

        public String toString() {
            if (this.types.length == 0) {
                return "";
            }
            if (this.types.length == 1) {
                return this.types[0].toString();
            }
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < this.types.length; ++i) {
                if (i > 0) {
                    sb.append(',');
                }
                sb.append(this.types[i]);
            }
            return sb.toString();
        }

        public int compareTo(MethodDefSignature other) {
            return Integer.compare(other.occurrences, this.occurrences);
        }
    }

    public static final class TypeDef {
        public final ClassDef parent;
        public final int array;
        public int occurrences;
        private MethodDefSignature singleArgumentSignature;
        private String rawDescriptor;
        public int index;

        public TypeDef(ClassDef parent, int array) {
            this.parent = parent;
            this.array = array;
            this.occurrences = 0;
            this.singleArgumentSignature = null;
            this.rawDescriptor = null;
            this.index = -1;
        }

        public String getRawDescriptor() {
            if (this.rawDescriptor == null) {
                this.rawDescriptor = this.array > 0 ? "[".repeat(this.array) + this.parent.getRawDescriptor() : this.parent.getRawDescriptor();
            }
            return this.rawDescriptor;
        }

        public MethodDefSignature getSingleArgumentSignature() {
            if (this.singleArgumentSignature == null) {
                this.singleArgumentSignature = new MethodDefSignature(this);
                this.parent.mappings.methodSignatures.put(this.singleArgumentSignature, this.singleArgumentSignature);
            }
            return this.singleArgumentSignature;
        }

        public int compareTo(TypeDef other) {
            return Integer.compare(other.occurrences, this.occurrences);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object obj) {
            if (obj == this) return true;
            if (!(obj instanceof TypeDef)) return false;
            TypeDef t = (TypeDef)obj;
            if (!this.parent.equals(t.parent)) return false;
            if (this.array != t.array) return false;
            return true;
        }

        public int hashCode() {
            return Objects.hash(this.parent, this.array);
        }

        public String toString() {
            return this.getRawDescriptor();
        }
    }

    public record NamedSignature(String name, @Nullable MethodDefSignature signature) {
        @Override
        public String toString() {
            if (this.signature == null) {
                return this.name;
            }
            return this.name + "(" + this.signature + ")";
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object obj) {
            if (obj == this) return true;
            if (!(obj instanceof NamedSignature)) return false;
            NamedSignature other = (NamedSignature)obj;
            if (!this.name.equals(other.name)) return false;
            if (!Objects.equals(this.signature, other.signature)) return false;
            return true;
        }

        @Override
        public int hashCode() {
            return this.name.hashCode() * 31 + (this.signature == null ? 0 : this.signature.hashCode());
        }
    }

    public record MemberDef(ClassDef parent, NamedSignature rawName, String mmName, TypeDef type, MutableObject<String> unmappedName) {
        public boolean cleanup() {
            return ((String)this.unmappedName.getValue()).isEmpty();
        }
    }
}

