/*
 * Decompiled with CFR 0.152.
 */
package com.unrealdinnerbone.jamd;

import com.unrealdinnerbone.jamd.JAMDRegistry;
import com.unrealdinnerbone.jamd.data.DataEvent;
import com.unrealdinnerbone.jamd.world.CustomFlatLevelSource;
import java.util.Optional;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

@Mod(value="jamd")
public class JAMD {
    public static final String MOD_ID = "jamd";
    private static final ForgeConfigSpec.Builder builder = new ForgeConfigSpec.Builder();
    private static final ForgeConfigSpec.BooleanValue FLOWERS = builder.comment("Stop mods from adding custom flowers").define("flowers", true);
    private static final ForgeConfigSpec.BooleanValue STRUCTURES = builder.comment("Stop mods from adding surface structures").define("surface_structures", true);
    private static final ForgeConfigSpec.BooleanValue ENTITIES = builder.comment("Stop mods from adding entities").define("entities", true);
    private static final ForgeConfigSpec.BooleanValue LAKES = builder.comment("Stop mods from adding lakes").define("lakes", true);
    private static final ForgeConfigSpec.ConfigValue<String> MAIN_WORLD = builder.comment("Main world id").define("main_world", (Object)"minecraft:overworld");
    public static final ResourceLocation DIM_ID = new ResourceLocation("jamd", "mining");

    public JAMD() {
        JAMDRegistry.REGISTRIES.forEach(deferredRegister -> deferredRegister.register(FMLJavaModLoadingContext.get().getModEventBus()));
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)builder.build());
        MinecraftForge.EVENT_BUS.addListener(EventPriority.LOWEST, this::onBiomesLoad);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(DataEvent::onData);
        FMLJavaModLoadingContext.get().getModEventBus().addGenericListener(Item.class, JAMD::onRegister);
    }

    public static void onRegister(RegistryEvent.Register<Item> event) {
        Registry.m_122965_((Registry)Registry.f_122890_, (ResourceLocation)DIM_ID, CustomFlatLevelSource.CODEC);
    }

    public void onBiomesLoad(BiomeLoadingEvent biomeLoadingEvent) {
        if (biomeLoadingEvent.getName() != null && biomeLoadingEvent.getName().toString().equals(DIM_ID.toString())) {
            if (((Boolean)FLOWERS.get()).booleanValue()) {
                biomeLoadingEvent.getGeneration().getFeatures(GenerationStep.Decoration.VEGETAL_DECORATION).clear();
            }
            if (((Boolean)STRUCTURES.get()).booleanValue()) {
                biomeLoadingEvent.getGeneration().getFeatures(GenerationStep.Decoration.SURFACE_STRUCTURES).clear();
                biomeLoadingEvent.getGeneration().getFeatures(GenerationStep.Decoration.UNDERGROUND_STRUCTURES).clear();
            }
            if (((Boolean)ENTITIES.get()).booleanValue()) {
                biomeLoadingEvent.getSpawns().getSpawnerTypes().forEach(spawnerType -> biomeLoadingEvent.getSpawns().getSpawner(spawnerType).clear());
            }
            if (((Boolean)LAKES.get()).booleanValue()) {
                biomeLoadingEvent.getGeneration().getFeatures(GenerationStep.Decoration.LAKES).clear();
            }
        }
    }

    public static String getMainWorld() {
        return (String)MAIN_WORLD.get();
    }

    public static Optional<Level> getMainWorld(MinecraftServer server) {
        return Optional.ofNullable(server.m_129880_(ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)new ResourceLocation((String)MAIN_WORLD.get()))));
    }

    public static Optional<Level> getMining(MinecraftServer server) {
        return Optional.ofNullable(server.m_129880_(ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)DIM_ID)));
    }
}

