/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks;

import com.mojang.brigadier.CommandDispatcher;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.p3pp3rf1y.sophisticatedbackpacks.Config;
import net.p3pp3rf1y.sophisticatedbackpacks.SBItemGroup;
import net.p3pp3rf1y.sophisticatedbackpacks.api.CapabilityBackpackWrapper;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.BackpackItem;
import net.p3pp3rf1y.sophisticatedbackpacks.client.ClientEventHandler;
import net.p3pp3rf1y.sophisticatedbackpacks.client.KeybindHandler;
import net.p3pp3rf1y.sophisticatedbackpacks.client.render.ClientBackpackContentsTooltip;
import net.p3pp3rf1y.sophisticatedbackpacks.command.SBPCommand;
import net.p3pp3rf1y.sophisticatedbackpacks.common.CommonEventHandler;
import net.p3pp3rf1y.sophisticatedbackpacks.data.DataGenerators;
import net.p3pp3rf1y.sophisticatedbackpacks.init.ModCompat;
import net.p3pp3rf1y.sophisticatedbackpacks.init.ModItems;
import net.p3pp3rf1y.sophisticatedbackpacks.init.ModLoot;
import net.p3pp3rf1y.sophisticatedbackpacks.network.SBPPacketHandler;
import net.p3pp3rf1y.sophisticatedbackpacks.registry.RegistryLoader;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="sophisticatedbackpacks")
public class SophisticatedBackpacks {
    public static final String MOD_ID = "sophisticatedbackpacks";
    public static final Logger LOGGER = LogManager.getLogger((String)"sophisticatedbackpacks");
    public static final CreativeModeTab ITEM_GROUP = new SBItemGroup();
    private final RegistryLoader registryLoader = new RegistryLoader();
    public final CommonEventHandler commonEventHandler = new CommonEventHandler();

    public SophisticatedBackpacks() {
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, (IConfigSpec)Config.SERVER_SPEC);
        this.commonEventHandler.registerHandlers();
        if (FMLEnvironment.dist == Dist.CLIENT) {
            ClientEventHandler.registerHandlers();
        }
        IEventBus modBus = FMLJavaModLoadingContext.get().getModEventBus();
        modBus.addListener(SophisticatedBackpacks::setup);
        modBus.addListener(DataGenerators::gatherData);
        modBus.addListener(Config.SERVER::onConfigReload);
        modBus.addListener(CapabilityBackpackWrapper::onRegister);
        modBus.addListener(SophisticatedBackpacks::clientSetup);
        ModLoot.init(modBus);
        IEventBus eventBus = MinecraftForge.EVENT_BUS;
        eventBus.addListener(SophisticatedBackpacks::registerCommands);
        eventBus.addListener(this::onAddReloadListener);
    }

    private static void setup(FMLCommonSetupEvent event) {
        SBPPacketHandler.INSTANCE.init();
        ModCompat.initCompats();
        event.enqueueWork(ModItems::registerDispenseBehavior);
        ModItems.registerCauldronInteractions();
        SBPCommand.registerArgumentTypes();
    }

    private static void clientSetup(FMLClientSetupEvent event) {
        KeybindHandler.register(event);
        MinecraftForgeClient.registerTooltipComponentFactory(BackpackItem.BackpackContentsTooltip.class, ClientBackpackContentsTooltip::new);
    }

    private static void registerCommands(RegisterCommandsEvent event) {
        SBPCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }

    private void onAddReloadListener(AddReloadListenerEvent event) {
        event.addListener((PreparableReloadListener)this.registryLoader);
    }

    public static ResourceLocation getRL(String regName) {
        return new ResourceLocation(SophisticatedBackpacks.getRegistryName(regName));
    }

    public static String getRegistryName(String regName) {
        return "sophisticatedbackpacks:" + regName;
    }
}

