/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gtlib.worldgen.stonelayer;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.biome.Biome;
import org.gtreimagined.gtlib.material.Material;
import org.gtreimagined.gtlib.util.TagUtils;

public record StoneLayerOre(Material material, long chance, int minY, int maxY, List<String> biomes, boolean biomeBlacklist) {
    public static final Codec<StoneLayerOre> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Material.CODEC.fieldOf("material").forGetter(StoneLayerOre::material), (App)Codec.LONG.fieldOf("chance").forGetter(StoneLayerOre::chance), (App)Codec.INT.fieldOf("minY").forGetter(StoneLayerOre::minY), (App)Codec.INT.fieldOf("maxY").forGetter(StoneLayerOre::maxY), (App)Codec.STRING.listOf().optionalFieldOf("biomes", List.of()).forGetter(StoneLayerOre::biomes), (App)Codec.BOOL.optionalFieldOf("biomeBlacklist", (Object)true).forGetter(StoneLayerOre::biomeBlacklist)).apply((Applicative)instance, StoneLayerOre::new));

    public StoneLayerOre(Material material, long chance, int minY, int maxY) {
        this(material, StoneLayerOre.bind(1L, 18144000L, chance), minY, maxY, List.of(), true);
    }

    private StoneLayerOre addFilteredBiome(String biomeID) {
        ArrayList<String> biomes = new ArrayList<String>(this.biomes);
        if (!biomes.contains(biomeID)) {
            biomes.add(biomeID);
        }
        return new StoneLayerOre(this.material, this.chance, this.minY, this.maxY, biomes, !this.biomes.isEmpty() && this.biomeBlacklist);
    }

    public StoneLayerOre setBiomeBlacklist(boolean blacklist) {
        return new StoneLayerOre(this.material, this.chance, this.minY, this.maxY, this.biomes, blacklist);
    }

    public StoneLayerOre addFilteredBiome(ResourceKey<Biome> biome) {
        return this.addFilteredBiome(biome.m_135782_().toString());
    }

    public StoneLayerOre addFilteredBiome(TagKey<Biome> biomeTagKey) {
        return this.addFilteredBiome("#" + String.valueOf(biomeTagKey.f_203868_()));
    }

    public boolean canPlace(BlockPos pos, Random rand, LevelAccessor world) {
        Holder biome = world.m_204166_(pos);
        boolean biomeValid = this.isBiomeValid((Holder<Biome>)biome);
        return biomeValid && pos.m_123342_() >= this.minY && pos.m_123342_() <= this.maxY && rand.nextLong(18144000L) < this.chance;
    }

    public static long bind(long min, long max, long boundValue) {
        return min > max ? Math.max(max, Math.min(min, boundValue)) : Math.max(min, Math.min(max, boundValue));
    }

    public boolean isBiomeValid(Holder<Biome> biome) {
        if (this.biomes.isEmpty()) {
            return this.biomeBlacklist;
        }
        Predicate<String> predicate = s -> {
            if (s.contains("#")) {
                return biome.m_203656_(TagUtils.getBiomeTag(new ResourceLocation(s.replace("#", ""))));
            }
            return biome.m_203565_(ResourceKey.m_135785_((ResourceKey)Registry.f_122885_, (ResourceLocation)new ResourceLocation(s)));
        };
        return this.biomeBlacklist ? this.biomes.stream().anyMatch(predicate) : this.biomes.stream().noneMatch(predicate);
    }
}

