/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gtlib.recipe.material;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArraySet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.ShapedRecipe;
import org.gtreimagined.gtlib.recipe.BaseRecipeSerializer;
import org.gtreimagined.gtlib.recipe.ingredient.PropertyIngredient;
import org.gtreimagined.gtlib.recipe.material.MaterialRecipe;
import org.jetbrains.annotations.Nullable;

public class MaterialSerializer
extends BaseRecipeSerializer<MaterialRecipe> {
    public static final MaterialSerializer INSTANCE = new MaterialSerializer();
    private static final int MAX_HEIGHT = 3;
    private static final int MAX_WIDTH = 3;

    public MaterialSerializer() {
        super("gtlib", "material");
    }

    public static void init() {
    }

    public MaterialRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
        String s = GsonHelper.m_13851_((JsonObject)json, (String)"group", (String)"");
        Map<String, Ingredient> map = MaterialSerializer.deserializeKey(GsonHelper.m_13930_((JsonObject)json, (String)"key"));
        String[] astring = MaterialSerializer.shrink(MaterialSerializer.patternFromJson(GsonHelper.m_13933_((JsonObject)json, (String)"pattern")));
        int i = astring[0].length();
        int j = astring.length;
        NonNullList<Ingredient> nonnulllist = MaterialSerializer.deserializeIngredients(astring, map, i, j);
        NonNullList out = NonNullList.m_122779_();
        for (JsonElement output : GsonHelper.m_13933_((JsonObject)json, (String)"output")) {
            out.add((Object)ShapedRecipe.m_151278_((JsonObject)output.getAsJsonObject()).m_7968_());
        }
        return new MaterialRecipe(recipeId, s, i, j, nonnulllist, (NonNullList<ItemStack>)out, json.get("builder").getAsString(), MaterialSerializer.buildMaterialInput(nonnulllist));
    }

    @Nullable
    public MaterialRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
        int i = buffer.m_130242_();
        int j = buffer.m_130242_();
        String s = buffer.m_130136_(Short.MAX_VALUE);
        NonNullList nonnulllist = NonNullList.m_122780_((int)(i * j), (Object)Ingredient.f_43901_);
        for (int k = 0; k < nonnulllist.size(); ++k) {
            nonnulllist.set(k, (Object)Ingredient.m_43940_((FriendlyByteBuf)buffer));
        }
        int size = buffer.m_130242_();
        NonNullList out = NonNullList.m_122779_();
        for (int ii = 0; ii < size; ++ii) {
            out.add(ii, (Object)buffer.m_130267_());
        }
        return new MaterialRecipe(recipeId, s, i, j, (NonNullList<Ingredient>)nonnulllist, (NonNullList<ItemStack>)out, buffer.m_130277_(), MaterialSerializer.buildMaterialInput((NonNullList<Ingredient>)nonnulllist));
    }

    public void toNetwork(FriendlyByteBuf buffer, MaterialRecipe recipe) {
        buffer.m_130130_(recipe.m_44220_());
        buffer.m_130130_(recipe.m_44221_());
        buffer.m_130070_(recipe.m_6076_());
        for (Ingredient ingredient : recipe.m_7527_()) {
            ingredient.m_43923_(buffer);
        }
        buffer.m_130130_(recipe.outputs.size());
        for (ItemStack stack : recipe.outputs) {
            buffer.m_130055_(stack);
        }
        buffer.m_130070_(recipe.builderId);
    }

    private static Map<String, Set<Integer>> buildMaterialInput(NonNullList<Ingredient> ingredients) {
        Object2ObjectOpenHashMap ret = new Object2ObjectOpenHashMap();
        for (int i = 0; i < ingredients.size(); ++i) {
            Ingredient ing = (Ingredient)ingredients.get(i);
            if (!(ing instanceof PropertyIngredient)) continue;
            int finalI1 = i;
            ret.compute(((PropertyIngredient)ing).getId(), (s, v) -> {
                if (v == null) {
                    v = new ObjectArraySet();
                }
                v.add(finalI1);
                return v;
            });
        }
        return ret;
    }

    private static NonNullList<Ingredient> deserializeIngredients(String[] pattern, Map<String, Ingredient> keys, int patternWidth, int patternHeight) {
        NonNullList nonnulllist = NonNullList.m_122780_((int)(patternWidth * patternHeight), (Object)Ingredient.f_43901_);
        HashSet set = Sets.newHashSet(keys.keySet());
        set.remove(" ");
        for (int i = 0; i < pattern.length; ++i) {
            for (int j = 0; j < pattern[i].length(); ++j) {
                String s = pattern[i].substring(j, j + 1);
                Ingredient ingredient = keys.get(s);
                if (ingredient == null) {
                    throw new JsonSyntaxException("Pattern references symbol '" + s + "' but it's not defined in the key");
                }
                set.remove(s);
                nonnulllist.set(j + patternWidth * i, (Object)ingredient);
            }
        }
        if (!set.isEmpty()) {
            throw new JsonSyntaxException("Key defines symbols that aren't used in pattern: " + String.valueOf(set));
        }
        return nonnulllist;
    }

    private static Map<String, Ingredient> deserializeKey(JsonObject json) {
        HashMap map = Maps.newHashMap();
        for (Map.Entry entry : json.entrySet()) {
            if (((String)entry.getKey()).length() != 1) {
                throw new JsonSyntaxException("Invalid key entry: '" + (String)entry.getKey() + "' is an invalid symbol (must be 1 character only).");
            }
            if (" ".equals(entry.getKey())) {
                throw new JsonSyntaxException("Invalid key entry: ' ' is a reserved symbol.");
            }
            map.put((String)entry.getKey(), Ingredient.m_43917_((JsonElement)((JsonElement)entry.getValue())));
        }
        map.put(" ", Ingredient.f_43901_);
        return map;
    }

    private static String[] patternFromJson(JsonArray jsonArr) {
        String[] astring = new String[jsonArr.size()];
        if (astring.length > 3) {
            throw new JsonSyntaxException("Invalid pattern: too many rows, 3 is maximum");
        }
        if (astring.length == 0) {
            throw new JsonSyntaxException("Invalid pattern: empty pattern not allowed");
        }
        for (int i = 0; i < astring.length; ++i) {
            String s = GsonHelper.m_13805_((JsonElement)jsonArr.get(i), (String)("pattern[" + i + "]"));
            if (s.length() > 3) {
                throw new JsonSyntaxException("Invalid pattern: too many columns, 3 is maximum");
            }
            if (i > 0 && astring[0].length() != s.length()) {
                throw new JsonSyntaxException("Invalid pattern: each row must be the same width");
            }
            astring[i] = s;
        }
        return astring;
    }

    private static int firstNonSpace(String str) {
        int i;
        for (i = 0; i < str.length() && str.charAt(i) == ' '; ++i) {
        }
        return i;
    }

    private static int lastNonSpace(String str) {
        int i;
        for (i = str.length() - 1; i >= 0 && str.charAt(i) == ' '; --i) {
        }
        return i;
    }

    static String[] shrink(String ... toShrink) {
        int i = Integer.MAX_VALUE;
        int j = 0;
        int k = 0;
        int l = 0;
        for (int i1 = 0; i1 < toShrink.length; ++i1) {
            String s = toShrink[i1];
            i = Math.min(i, MaterialSerializer.firstNonSpace(s));
            int j1 = MaterialSerializer.lastNonSpace(s);
            j = Math.max(j, j1);
            if (j1 < 0) {
                if (k == i1) {
                    ++k;
                }
                ++l;
                continue;
            }
            l = 0;
        }
        if (toShrink.length == l) {
            return new String[0];
        }
        String[] astring = new String[toShrink.length - l - k];
        for (int k1 = 0; k1 < astring.length; ++k1) {
            astring[k1] = toShrink[k1 + k].substring(i, j + 1);
        }
        return astring;
    }
}

