/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gtlib.network.packets;

import com.teamresourceful.resourcefullib.common.networking.base.Packet;
import com.teamresourceful.resourcefullib.common.networking.base.PacketContext;
import com.teamresourceful.resourcefullib.common.networking.base.PacketHandler;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.gtreimagined.gtlib.blockentity.BlockEntityFakeBlock;
import org.gtreimagined.gtlib.blockentity.multi.BlockEntityBasicMultiMachine;
import org.gtreimagined.gtlib.network.GTLibNetwork;
import org.gtreimagined.gtlib.util.Utils;

public class FakeTilePacket
implements Packet<FakeTilePacket> {
    public static final PacketHandler<FakeTilePacket> HANDLER = new Handler();
    final BlockPos fakeTilePos;
    final BlockPos controllerPos;

    public FakeTilePacket(BlockPos fakeTilePos, BlockPos controllerPos) {
        this.fakeTilePos = fakeTilePos;
        this.controllerPos = controllerPos;
    }

    public ResourceLocation getID() {
        return GTLibNetwork.FAKE_TILE_PACKET_ID;
    }

    public PacketHandler<FakeTilePacket> getHandler() {
        return HANDLER;
    }

    private static class Handler
    implements PacketHandler<FakeTilePacket> {
        private Handler() {
        }

        public void encode(FakeTilePacket msg, FriendlyByteBuf buf) {
            buf.m_130064_(msg.fakeTilePos);
            buf.m_130064_(msg.controllerPos);
        }

        public FakeTilePacket decode(FriendlyByteBuf buf) {
            return new FakeTilePacket(buf.m_130135_(), buf.m_130135_());
        }

        public PacketContext handle(FakeTilePacket msg) {
            return (sender, level) -> {
                BlockEntity tile;
                if (sender != null && (tile = Utils.getTile((BlockGetter)sender.m_183503_(), msg.fakeTilePos)) instanceof BlockEntityFakeBlock) {
                    BlockEntityFakeBlock fakeBlock = (BlockEntityFakeBlock)tile;
                    BlockEntity controller = Utils.getTile((BlockGetter)sender.m_183503_(), msg.controllerPos);
                    if (controller instanceof BlockEntityBasicMultiMachine) {
                        BlockEntityBasicMultiMachine machine = (BlockEntityBasicMultiMachine)controller;
                        fakeBlock.setController(machine);
                    }
                }
            };
        }
    }
}

