/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gtlib.integration.jei;

import com.google.common.collect.ImmutableList;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import lombok.Generated;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.forge.ForgeTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.helpers.IJeiHelpers;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.ITypedIngredient;
import mezz.jei.api.ingredients.subtypes.UidContext;
import mezz.jei.api.recipe.IFocus;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.recipe.transfer.IRecipeTransferInfo;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.IRecipeTransferRegistration;
import mezz.jei.api.registration.ISubtypeRegistration;
import mezz.jei.api.registration.IVanillaCategoryExtensionRegistration;
import mezz.jei.api.runtime.IJeiRuntime;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.server.ServerLifecycleHooks;
import org.gtreimagined.gtlib.GTAPI;
import org.gtreimagined.gtlib.GTLib;
import org.gtreimagined.gtlib.block.BlockDimensionMarker;
import org.gtreimagined.gtlib.integration.jei.MachineTransferHandler;
import org.gtreimagined.gtlib.integration.jei.category.MultiMachineInfoCategory;
import org.gtreimagined.gtlib.integration.jei.category.RecipeMapCategory;
import org.gtreimagined.gtlib.integration.jei.category.SmallOreCategory;
import org.gtreimagined.gtlib.integration.jei.category.VeinCategory;
import org.gtreimagined.gtlib.integration.jei.extension.JEIMaterialRecipeExtension;
import org.gtreimagined.gtlib.integration.xei.GTLibXEIPlugin;
import org.gtreimagined.gtlib.recipe.IRecipe;
import org.gtreimagined.gtlib.recipe.map.IRecipeMap;
import org.gtreimagined.gtlib.recipe.map.RecipeBuilder;
import org.gtreimagined.gtlib.recipe.map.RecipeMap;
import org.gtreimagined.gtlib.recipe.map.SubCategory;
import org.gtreimagined.gtlib.recipe.material.MaterialRecipe;
import org.gtreimagined.gtlib.util.RegistryUtils;
import org.gtreimagined.gtlib.util.Utils;
import org.gtreimagined.gtlib.worldgen.smallore.SmallOreData;
import org.gtreimagined.gtlib.worldgen.vein.VeinData;
import org.gtreimagined.tesseract.api.context.TesseractItemContext;
import org.gtreimagined.tesseract.api.eu.IEnergyHandler;
import org.gtreimagined.tesseract.api.eu.IEnergyItem;
import org.gtreimagined.tesseract.api.forge.TesseractCaps;
import org.gtreimagined.tesseract.api.wrapper.ItemStackWrapper;
import org.jetbrains.annotations.NotNull;

@JeiPlugin
public class GTLibJEIPlugin
implements IModPlugin {
    public static final Map<String, RecipeType<IRecipe>> RECIPE_TYPES = new Object2ObjectOpenHashMap();
    private static IJeiRuntime runtime;
    private static IJeiHelpers helpers;

    public GTLibJEIPlugin() {
        GTLib.LOGGER.info("Creating GTAPI's JEI Plugin");
    }

    public ResourceLocation getPluginUid() {
        return new ResourceLocation("gtlib", "jei");
    }

    public void onRuntimeAvailable(@NotNull IJeiRuntime jeiRuntime) {
        if (GTAPI.isModLoaded("roughlyenoughitems")) {
            return;
        }
        runtime = jeiRuntime;
        ArrayList list = new ArrayList();
        GTLibXEIPlugin.getItemsToHide().forEach(c -> c.accept(list));
        if (!list.isEmpty()) {
            runtime.getIngredientManager().removeIngredientsAtRuntime(VanillaTypes.ITEM, list.stream().map(i -> i.m_5456_().m_7968_()).toList());
        }
        ArrayList fluidList = new ArrayList();
        GTLibXEIPlugin.getFluidsToHide().forEach(c -> c.accept(fluidList));
        if (!fluidList.isEmpty()) {
            runtime.getIngredientManager().removeIngredientsAtRuntime((IIngredientType)ForgeTypes.FLUID_STACK, fluidList.stream().map(f -> new FluidStack(f, 1)).toList());
            runtime.getIngredientManager().removeIngredientsAtRuntime(VanillaTypes.ITEM, fluidList.stream().map(i -> i.m_6859_().m_7968_()).toList());
        }
    }

    public void registerItemSubtypes(ISubtypeRegistration registration) {
        if (GTAPI.isModLoaded("roughlyenoughitems")) {
            return;
        }
        ArrayList list = new ArrayList();
        GTLibXEIPlugin.getItemsToHide().forEach(c -> c.accept(list));
        GTAPI.all(Item.class).forEach(i -> {
            IEnergyItem energyItem;
            if (list.contains(i)) {
                return;
            }
            if (i instanceof IEnergyItem && (energyItem = (IEnergyItem)i).canCreate((TesseractItemContext)new ItemStackWrapper(i.m_7968_()))) {
                registration.registerSubtypeInterpreter(i, (s, c) -> {
                    if (c == UidContext.Recipe) {
                        return "";
                    }
                    long energy = s.getCapability(TesseractCaps.ENERGY_HANDLER_CAPABILITY_ITEM).map(IEnergyHandler::getEnergy).orElse(0L);
                    long capacity = s.getCapability(TesseractCaps.ENERGY_HANDLER_CAPABILITY_ITEM).map(IEnergyHandler::getCapacity).orElse(0L);
                    return "e:" + energy + "/" + capacity;
                });
            }
        });
    }

    public void registerCategories(IRecipeCategoryRegistration registry) {
        if (GTAPI.isModLoaded("roughlyenoughitems")) {
            return;
        }
        RecipeMapCategory.setGuiHelper(registry.getJeiHelpers().getGuiHelper());
        MultiMachineInfoCategory.setGuiHelper(registry.getJeiHelpers().getGuiHelper());
        if (helpers == null) {
            helpers = registry.getJeiHelpers();
        }
        ObjectOpenHashSet registeredMachineCats = new ObjectOpenHashSet();
        GTLibXEIPlugin.getREGISTRY().forEach((arg_0, arg_1) -> GTLibJEIPlugin.lambda$registerCategories$9((Set)registeredMachineCats, registry, arg_0, arg_1));
        registry.addRecipeCategories(new IRecipeCategory[]{new MultiMachineInfoCategory()});
        registry.addRecipeCategories(new IRecipeCategory[]{new VeinCategory()});
        registry.addRecipeCategories(new IRecipeCategory[]{new SmallOreCategory()});
    }

    public void registerRecipes(@NotNull IRecipeRegistration registration) {
        if (GTAPI.isModLoaded("roughlyenoughitems")) {
            return;
        }
        if (helpers == null) {
            helpers = registration.getJeiHelpers();
        }
        GTLibXEIPlugin.getREGISTRY().forEach((id, tuple) -> {
            if (tuple.map.getSubCategories().isEmpty()) {
                registration.addRecipes(RECIPE_TYPES.get(id.toString()), this.getRecipes(tuple.map));
            } else {
                List<IRecipe> recipes = this.getRecipes(tuple.map);
                ArrayList<IRecipe> mainRecipes = new ArrayList<IRecipe>();
                HashMap<String, List> recipeMap = new HashMap<String, List>();
                for (IRecipe iRecipe : recipes) {
                    boolean found = false;
                    for (Map.Entry<String, SubCategory> entry : tuple.map.getSubCategories().entrySet()) {
                        if (!entry.getValue().predicate().test(iRecipe)) continue;
                        found = true;
                        recipeMap.computeIfAbsent(entry.getKey(), s -> new ArrayList()).add(iRecipe);
                        break;
                    }
                    if (found) continue;
                    mainRecipes.add(iRecipe);
                }
                registration.addRecipes(RECIPE_TYPES.get(id.toString()), mainRecipes);
                for (Map.Entry entry : recipeMap.entrySet()) {
                    registration.addRecipes(RECIPE_TYPES.get("antimatter_shared:" + (String)entry.getKey()), (List)entry.getValue());
                }
            }
        });
        registration.addRecipes(VeinCategory.VEINS, VeinData.INSTANCE.getVeins().values().stream().toList());
        registration.addRecipes(SmallOreCategory.SMALL_ORES, SmallOreData.INSTANCE.getVeins().values().stream().toList());
        MultiMachineInfoCategory.registerRecipes(registration);
    }

    private List<IRecipe> getRecipes(IRecipeMap recipeMap) {
        RecipeManager manager = this.getRecipeManager();
        if (manager == null) {
            return Collections.emptyList();
        }
        ArrayList<IRecipe> recipes = new ArrayList<IRecipe>(manager.m_44013_(recipeMap.getRecipeType()).stream().filter(r -> r.getMapId().equals(recipeMap.getId()) && !r.isHidden()).toList());
        if (recipeMap.getProxy() != null && recipeMap instanceof RecipeMap) {
            RecipeMap map = (RecipeMap)recipeMap;
            List proxyRecipes = manager.m_44013_(recipeMap.getProxy().loc());
            proxyRecipes.forEach(recipe -> {
                IRecipe recipe1 = recipeMap.getProxy().handler().apply((Recipe<?>)recipe, (RecipeBuilder)map.RB());
                if (recipe1 != null && !recipe1.isHidden()) {
                    recipes.add(recipe1);
                }
            });
        }
        return recipes;
    }

    private RecipeManager getRecipeManager() {
        if (FMLEnvironment.dist.isDedicatedServer()) {
            return ServerLifecycleHooks.getCurrentServer().m_129894_();
        }
        if (this.getWorld() == null) {
            return null;
        }
        return this.getWorld().m_7465_();
    }

    @OnlyIn(value=Dist.CLIENT)
    ClientLevel getWorld() {
        return Minecraft.m_91087_().f_91073_;
    }

    public static void showCategories(ResourceLocation ... categories) {
        if (runtime != null) {
            runtime.getRecipesGui().showCategories((List)ImmutableList.copyOf((Object[])categories));
        }
    }

    public void registerVanillaCategoryExtensions(IVanillaCategoryExtensionRegistration registration) {
        if (GTAPI.isModLoaded("roughlyenoughitems")) {
            return;
        }
        registration.getCraftingCategory().addCategoryExtension(MaterialRecipe.class, JEIMaterialRecipeExtension::new);
    }

    public void registerRecipeTransferHandlers(IRecipeTransferRegistration registration) {
        GTLibXEIPlugin.getREGISTRY().forEach((id, tuple) -> registration.addRecipeTransferHandler((IRecipeTransferInfo)new MachineTransferHandler(tuple.map.getLoc())));
    }

    public static <T> void addModDescriptor(List<Component> tooltip, T t) {
        if (t == null || helpers == null) {
            return;
        }
        String text = helpers.getModIdHelper().getFormattedModNameForModId(GTLibJEIPlugin.getRuntime().getIngredientManager().getIngredientHelper(t).getDisplayModId(t));
        tooltip.add((Component)Utils.literal(text));
    }

    public void registerRecipeCatalysts(@NotNull IRecipeCatalystRegistration registration) {
        if (GTAPI.isModLoaded("roughlyenoughitems")) {
            return;
        }
        GTLibXEIPlugin.getREGISTRY().forEach((id, tuple) -> {
            if (tuple.workstations.isEmpty()) {
                return;
            }
            tuple.workstations.forEach(s -> {
                Item item = RegistryUtils.getItemFromID(s);
                if (item == Items.f_41852_) {
                    return;
                }
                registration.addRecipeCatalyst(new ItemStack((ItemLike)item), new ResourceLocation[]{tuple.map.getLoc()});
                if (!tuple.map.getSubCategories().isEmpty()) {
                    tuple.map.getSubCategories().keySet().forEach(arg_0 -> GTLibJEIPlugin.lambda$registerRecipeCatalysts$15(registration, (ItemLike)item, arg_0));
                }
            });
        });
        GTLibXEIPlugin.getWORKSTATIONS().forEach((r, l) -> {
            ArrayList list = new ArrayList();
            l.forEach(l2 -> l2.accept(list));
            list.forEach(i -> registration.addRecipeCatalyst(new ItemStack((ItemLike)i), new RecipeType[]{RecipeType.create((String)r.m_135827_(), (String)r.m_135815_(), Recipe.class)}));
        });
    }

    public static void addDimensionSlots(IRecipeLayoutBuilder builder, List<ResourceKey<Level>> dimensions) {
        int i = 0;
        ArrayList<Block> markers = new ArrayList<Block>();
        for (ResourceLocation dimension : dimensions.stream().map(ResourceKey::m_135782_).toList()) {
            ItemStack world;
            int y = i / 9;
            int x = i % 9;
            Block dimensionMarker = GTAPI.get(BlockDimensionMarker.class, dimension.m_135815_() + "_marker", "gtlib");
            if (dimensionMarker != null) {
                if (markers.contains(dimensionMarker)) continue;
                markers.add(dimensionMarker);
                world = new ItemStack((ItemLike)dimensionMarker);
            } else {
                world = new ItemStack((ItemLike)Items.f_42127_).m_41714_((Component)Utils.literal(dimension.toString()));
            }
            builder.addSlot(RecipeIngredientRole.INPUT, 1 + x * 18, 102 + y * 18).addIngredients((IIngredientType)VanillaTypes.ITEM_STACK, List.of(world));
            ++i;
        }
    }

    public static void uses(final FluidStack val, final boolean USE) {
        GTLibJEIPlugin.getRuntime().getRecipesGui().show((IFocus)new IFocus<FluidStack>(){

            public ITypedIngredient<FluidStack> getTypedValue() {
                return new ITypedIngredient<FluidStack>(){

                    public IIngredientType<FluidStack> getType() {
                        return ForgeTypes.FLUID_STACK;
                    }

                    public FluidStack getIngredient() {
                        return val;
                    }

                    public <V> Optional<V> getIngredient(IIngredientType<V> ingredientType) {
                        if (ingredientType == ForgeTypes.FLUID_STACK) {
                            return Optional.of(val);
                        }
                        return Optional.empty();
                    }
                };
            }

            public RecipeIngredientRole getRole() {
                return USE ? RecipeIngredientRole.INPUT : RecipeIngredientRole.OUTPUT;
            }

            public <T> Optional<IFocus<T>> checkedCast(IIngredientType<T> ingredientType) {
                return Optional.empty();
            }

            public IFocus.Mode getMode() {
                return USE ? IFocus.Mode.INPUT : IFocus.Mode.OUTPUT;
            }
        });
    }

    @Generated
    public static IJeiRuntime getRuntime() {
        return runtime;
    }

    private static /* synthetic */ void lambda$registerRecipeCatalysts$15(IRecipeCatalystRegistration registration, ItemLike item, String s1) {
        registration.addRecipeCatalyst(new ItemStack(item), new ResourceLocation[]{new ResourceLocation("antimatter_shared", s1)});
    }

    private static /* synthetic */ void lambda$registerCategories$9(Set registeredMachineCats, IRecipeCategoryRegistration registry, ResourceLocation id, GTLibXEIPlugin.RegistryValue tuple) {
        if (!registeredMachineCats.contains(tuple.map.getLoc())) {
            RecipeType type = new RecipeType(tuple.map.getLoc(), IRecipe.class);
            RECIPE_TYPES.put(type.getUid().toString(), (RecipeType<IRecipe>)type);
            registry.addRecipeCategories(new IRecipeCategory[]{new RecipeMapCategory(tuple.map, (RecipeType<IRecipe>)type, tuple.gui, tuple.tier, tuple.workstations.isEmpty() ? null : tuple.workstations.get(0))});
            registeredMachineCats.add(tuple.map.getLoc());
            if (!tuple.map.getSubCategories().isEmpty()) {
                tuple.map.getSubCategories().forEach((s, subCategory) -> {
                    ResourceLocation subCategoryId = new ResourceLocation("antimatter_shared", s);
                    if (!registeredMachineCats.contains(subCategoryId)) {
                        RecipeType subType = new RecipeType(subCategoryId, IRecipe.class);
                        RECIPE_TYPES.put(subType.getUid().toString(), (RecipeType<IRecipe>)subType);
                        registeredMachineCats.add(subCategoryId);
                        registry.addRecipeCategories(new IRecipeCategory[]{new RecipeMapCategory(tuple.map, (RecipeType<IRecipe>)subType, tuple.gui, tuple.tier, subCategoryId, (SubCategory)subCategory)});
                    }
                });
            }
        }
    }
}

