/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gtlib.integration.jade;

import mcp.mobius.waila.api.BlockAccessor;
import mcp.mobius.waila.api.IComponentProvider;
import mcp.mobius.waila.api.IServerDataProvider;
import mcp.mobius.waila.api.ITooltip;
import mcp.mobius.waila.api.config.IPluginConfig;
import mcp.mobius.waila.api.ui.IElementHelper;
import mcp.mobius.waila.api.ui.IProgressStyle;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.gtreimagined.gtlib.blockentity.BlockEntityMachine;
import org.gtreimagined.gtlib.blockentity.multi.BlockEntityBasicMultiMachine;
import org.gtreimagined.gtlib.capability.machine.MachineRecipeHandler;
import org.gtreimagined.gtlib.integration.jade.JadePlugin;
import org.gtreimagined.gtlib.machine.MachineState;
import org.gtreimagined.gtlib.util.Utils;

public class MachineProvider
implements IComponentProvider,
IServerDataProvider<BlockEntity> {
    public static MachineProvider INSTANCE = new MachineProvider();

    public void appendTooltip(ITooltip tooltip, BlockAccessor accessor, IPluginConfig config) {
        BlockEntity blockEntity = accessor.getBlockEntity();
        if (blockEntity instanceof BlockEntityMachine) {
            MachineRecipeHandler recipeHandler;
            BlockEntityMachine machine = (BlockEntityMachine)blockEntity;
            if (config.get(JadePlugin.PROGRESS) && (recipeHandler = (MachineRecipeHandler)machine.recipeHandler.orElse(null)) != null && (!accessor.isServerConnected() || accessor.getServerData().m_128441_("jadeProgress"))) {
                boolean active;
                int max;
                int cur;
                IElementHelper helper = tooltip.getElementHelper();
                if (accessor.isServerConnected()) {
                    cur = accessor.getServerData().m_128451_("jadeProgress");
                    max = accessor.getServerData().m_128451_("jadeMaxProgress");
                    active = accessor.getServerData().m_128471_("jadeActive");
                } else {
                    cur = recipeHandler.getCurrentProgress();
                    max = recipeHandler.getMaxProgress();
                    boolean bl = active = machine.getMachineState() == MachineState.ACTIVE;
                }
                if (max > 0 && active) {
                    String curText = String.valueOf(ChatFormatting.WHITE) + String.valueOf(max >= 20 ? Math.round((double)cur / 20.0) : (long)cur) + String.valueOf(ChatFormatting.GRAY);
                    String maxText = (max >= 20 ? Math.round((double)max / 20.0) : (long)max) + " " + (max >= 20 ? "s" : "t");
                    MutableComponent text = new TranslatableComponent("jade.fe", new Object[]{curText, maxText}).m_130940_(ChatFormatting.WHITE);
                    IProgressStyle progressStyle = helper.progressStyle().color(-11748585, -11748585);
                    tooltip.add(helper.progress((float)cur / (float)max, (Component)text, progressStyle, helper.borderStyle()).tag(JadePlugin.PROGRESS));
                }
            }
            if (machine instanceof BlockEntityBasicMultiMachine) {
                BlockEntityBasicMultiMachine multiMachine = (BlockEntityBasicMultiMachine)machine;
                if (config.get(JadePlugin.STRUCTURE) && (!accessor.isServerConnected() || accessor.getServerData().m_128441_("jadeStructureValid"))) {
                    boolean validStructure = accessor.isServerConnected() ? accessor.getServerData().m_128471_("jadeStructureValid") : multiMachine.isStructureValid();
                    if (validStructure) {
                        tooltip.add(tooltip.getElementHelper().text((Component)Utils.translatable("gtlib.tooltip.valid_structure", new Object[0]).m_130940_(ChatFormatting.GREEN)).tag(JadePlugin.STRUCTURE));
                    } else {
                        tooltip.add(tooltip.getElementHelper().text((Component)Utils.translatable("gtlib.tooltip.invalid_structure", new Object[0]).m_130940_(ChatFormatting.RED)).tag(JadePlugin.STRUCTURE));
                    }
                }
            }
        }
    }

    public void appendServerData(CompoundTag compoundTag, ServerPlayer serverPlayer, Level level, BlockEntity blockEntity, boolean b) {
        if (blockEntity instanceof BlockEntityMachine) {
            BlockEntityMachine machine = (BlockEntityMachine)blockEntity;
            machine.recipeHandler.ifPresent(r -> {
                compoundTag.m_128405_("jadeProgress", r.getCurrentProgress());
                compoundTag.m_128405_("jadeMaxProgress", r.getMaxProgress());
                compoundTag.m_128379_("jadeActive", machine.getMachineState() == MachineState.ACTIVE);
            });
            if (machine instanceof BlockEntityBasicMultiMachine) {
                BlockEntityBasicMultiMachine multiMachine = (BlockEntityBasicMultiMachine)machine;
                compoundTag.m_128379_("jadeStructureValid", multiMachine.isStructureValid());
            }
        }
    }
}

