/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gtlib.datagen.providers;

import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.FrameType;
import net.minecraft.data.DataProvider;
import net.minecraft.data.HashCache;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ItemLike;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.gtreimagined.gtlib.datagen.GTLibDynamics;
import org.gtreimagined.gtlib.datagen.IGTLibProvider;
import org.gtreimagined.gtlib.util.Utils;
import org.jetbrains.annotations.NotNull;

public class GTAdvancementProvider
implements DataProvider,
IGTLibProvider {
    private static final Logger LOGGER = LogManager.getLogger();
    private final List<Consumer<Consumer<Advancement>>> advancements;
    private final String providerDomain;
    private final String providerName;

    @SafeVarargs
    public GTAdvancementProvider(String providerDomain, String providerName, Consumer<Consumer<Advancement>> ... advancements) {
        this.providerDomain = providerDomain;
        this.providerName = providerName;
        if (advancements.length == 0) {
            throw new IllegalArgumentException("GTLibAdvancementProvider requires at least one Advancement class.");
        }
        this.advancements = Arrays.asList(advancements);
    }

    @Override
    public void run() {
    }

    @Override
    public void onCompletion() {
        ObjectOpenHashSet locs = new ObjectOpenHashSet();
        Consumer<Advancement> consumer = arg_0 -> GTAdvancementProvider.lambda$onCompletion$0((Set)locs, arg_0);
        this.advancements.forEach(a -> a.accept(consumer));
    }

    public void m_6865_(@NotNull HashCache cache) {
    }

    private Path getPath(Path path, Advancement advancement) {
        return path.resolve(String.join((CharSequence)"", "data/", this.providerDomain, "/advancements/", advancement.m_138327_().m_135815_(), ".json"));
    }

    @NotNull
    public String m_6055_() {
        return this.providerName;
    }

    public static Advancement.Builder buildRootAdvancement(ItemLike provider, ResourceLocation backgroundPath, String title, String desc, FrameType type, boolean toast, boolean announce, boolean hide) {
        return Advancement.Builder.m_138353_().m_138371_(provider, (Component)Utils.translatable(title, new Object[0]), (Component)Utils.translatable(desc, new Object[0]), backgroundPath, type, toast, announce, hide).m_138354_(AdvancementRewards.Builder.m_10005_((int)10));
    }

    public static Advancement.Builder buildAdvancement(Advancement parent, ItemLike provider, String title, String desc, FrameType type, boolean toast, boolean announce, boolean hide) {
        return Advancement.Builder.m_138353_().m_138398_(parent).m_138371_(provider, (Component)Utils.translatable(title, new Object[0]), (Component)Utils.translatable(desc, new Object[0]), null, type, toast, announce, hide).m_138354_(AdvancementRewards.Builder.m_10005_((int)10));
    }

    public static String getLoc(String domain, String id) {
        return String.join((CharSequence)":", domain, id);
    }

    private static /* synthetic */ void lambda$onCompletion$0(Set locs, Advancement a) {
        if (!locs.add(a.m_138327_())) {
            throw new IllegalStateException("Duplicate advancement " + String.valueOf(a.m_138327_()));
        }
        GTLibDynamics.RUNTIME_DATA_PACK.addData(GTLibDynamics.fix(a.m_138327_(), "advancements", "json"), GTLibDynamics.serialize(a.m_138313_()));
    }
}

