/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gtlib.datagen;

import com.google.common.base.Preconditions;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import lombok.Generated;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.Serializer;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;
import net.minecraftforge.common.crafting.CraftingHelper;
import org.apache.commons.lang3.ArrayUtils;
import org.gtreimagined.gtlib.GTLib;
import org.gtreimagined.gtlib.mixin.LootPoolAccessor;
import org.gtreimagined.gtlib.util.ItemStackHashStrategy;
import org.gtreimagined.gtlib.util.RegistryUtils;
import org.jetbrains.annotations.NotNull;

public class GTLoot {
    private static final Map<ResourceLocation, List<LootEntryItem>> lootEntryItems = new Object2ObjectOpenHashMap();
    private static final Map<ResourceLocation, NumberProvider> rollValues = new Object2ObjectOpenHashMap();
    private static final LootItemCondition[] NO_CONDITIONS = new LootItemCondition[0];
    private static final ItemStackHashStrategy HASH_STRATEGY = ItemStackHashStrategy.comparingAllButCount();

    public static void onLootTableLoad(LootPool mainPool, ResourceLocation name) {
        if (mainPool == null) {
            return;
        }
        if (lootEntryItems.containsKey(name)) {
            List<LootEntryItem> entryItems = lootEntryItems.get(name);
            for (LootEntryItem entry : entryItems) {
                try {
                    Object[] entries = ((LootPoolAccessor)mainPool).getEntries();
                    entries = (LootPoolEntryContainer[])ArrayUtils.add((Object[])entries, (Object)((Object)entry));
                    ((LootPoolAccessor)mainPool).setEntries((LootPoolEntryContainer[])entries);
                }
                catch (RuntimeException e) {
                    GTLib.LOGGER.error("Couldn't add {} to lootTable {}: {}", (Object)entry, (Object)name, (Object)e.getMessage());
                }
            }
        }
        if (rollValues.containsKey(name)) {
            NumberProvider rangeAdd = rollValues.get(name);
            NumberProvider numberProvider = ((LootPoolAccessor)mainPool).getRolls();
        }
    }

    public static void addItem(@NotNull ResourceLocation lootTable, @NotNull ItemStack stack, int minAmount, int maxAmount, int weight) {
        RandomWeightLootFunction lootFunction = new RandomWeightLootFunction(stack, minAmount, maxAmount);
        String modid = Objects.requireNonNull(RegistryUtils.getIdFromItem(stack.m_41720_())).m_135827_();
        String entryName = GTLoot.createEntryName(stack, modid, weight, lootFunction);
        LootEntryItem itemEntry = new LootEntryItem(stack, weight, lootFunction, entryName);
        lootEntryItems.computeIfAbsent(lootTable, $ -> new ArrayList()).add(itemEntry);
    }

    public static void addRolls(ResourceLocation tableLocation, int minAdd, int maxAdd) {
        rollValues.put(tableLocation, (NumberProvider)UniformGenerator.m_165780_((float)minAdd, (float)maxAdd));
    }

    @NotNull
    private static String createEntryName(@NotNull ItemStack stack, @NotNull String modid, int weight, @NotNull RandomWeightLootFunction function) {
        int hashCode = Objects.hash(HASH_STRATEGY.hashCode(stack), modid, weight, function.getMinAmount(), function.getMaxAmount());
        return String.format("#%s:loot_%s", modid, hashCode);
    }

    private static class LootEntryItem
    extends LootItem {
        private final ItemStack stack;
        private final String entryName;

        public LootEntryItem(@NotNull ItemStack stack, int weight, LootItemFunction lootFunction, @NotNull String entryName) {
            super(stack.m_41720_(), weight, 1, NO_CONDITIONS, new LootItemFunction[]{lootFunction});
            this.stack = stack;
            this.entryName = entryName;
        }

        public void m_6948_(Consumer<ItemStack> stackConsumer, LootContext lootContext) {
            stackConsumer.accept(this.stack.m_41777_());
        }

        @NotNull
        public String toString() {
            return "LootEntryItem{name=" + this.entryName + ", stack=" + this.stack.toString() + "}";
        }
    }

    public static class RandomWeightLootFunction
    extends LootItemConditionalFunction
    implements LootItemFunction {
        public static final LootItemFunctionType TYPE = (LootItemFunctionType)Registry.m_122965_((Registry)Registry.f_122876_, (ResourceLocation)new ResourceLocation("gtlib", "random_weight"), (Object)new LootItemFunctionType((net.minecraft.world.level.storage.loot.Serializer)new Serializer()));
        private final ItemStack stack;
        private final int minAmount;
        private final int maxAmount;

        public RandomWeightLootFunction(@NotNull ItemStack stack, int minAmount, int maxAmount) {
            super(NO_CONDITIONS);
            Preconditions.checkArgument((minAmount <= maxAmount ? 1 : 0) != 0, (Object)"minAmount must be <= maxAmount");
            this.stack = stack;
            this.minAmount = minAmount;
            this.maxAmount = maxAmount;
        }

        public static void init() {
        }

        public LootItemFunctionType m_7162_() {
            return TYPE;
        }

        protected ItemStack m_7372_(ItemStack itemStack, LootContext context) {
            CompoundTag tagCompound;
            if (this.stack.m_41773_() != 0) {
                itemStack.m_41721_(this.stack.m_41773_());
            }
            if ((tagCompound = this.stack.m_41783_()) != null) {
                itemStack.m_41751_(tagCompound.m_6426_());
            }
            if (this.minAmount == this.maxAmount) {
                itemStack.m_41764_(this.minAmount);
                return itemStack;
            }
            int count = Math.min(this.minAmount + context.m_78933_().nextInt(this.maxAmount - this.minAmount + 1), this.stack.m_41741_());
            itemStack.m_41764_(count);
            return itemStack;
        }

        @Generated
        public int getMinAmount() {
            return this.minAmount;
        }

        @Generated
        public int getMaxAmount() {
            return this.maxAmount;
        }

        public static class Serializer
        extends LootItemConditionalFunction.Serializer<RandomWeightLootFunction> {
            public void serialize(JsonObject json, RandomWeightLootFunction setItemCountFunction, JsonSerializationContext serializationContext) {
                super.m_6170_(json, (LootItemConditionalFunction)setItemCountFunction, serializationContext);
                json.add("min", serializationContext.serialize((Object)setItemCountFunction.minAmount));
                json.add("max", serializationContext.serialize((Object)setItemCountFunction.maxAmount));
                JsonObject stack = new JsonObject();
                stack.addProperty("item", RegistryUtils.getIdFromItem(setItemCountFunction.stack.m_41720_()).toString());
                stack.addProperty("count", (Number)setItemCountFunction.stack.m_41613_());
                if (setItemCountFunction.stack.m_41782_()) {
                    stack.addProperty("nbt", setItemCountFunction.stack.m_41783_().toString());
                }
                json.add("stack", (JsonElement)stack);
            }

            public RandomWeightLootFunction deserialize(JsonObject object, JsonDeserializationContext deserializationContext, LootItemCondition[] conditions) {
                ItemStack stack = CraftingHelper.getItemStack((JsonObject)object.getAsJsonObject("stack"), (boolean)true);
                int min = GsonHelper.m_13927_((JsonObject)object, (String)"min");
                int max = GsonHelper.m_13927_((JsonObject)object, (String)"max");
                return new RandomWeightLootFunction(stack, min, max);
            }
        }
    }
}

