/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gtlib.datagen;

import com.google.common.collect.Sets;
import com.google.gson.Gson;
import dev.latvian.mods.kubejs.script.ScriptType;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.devtech.arrp.api.RuntimeResourcePack;
import net.devtech.arrp.json.loot.JCondition;
import net.devtech.arrp.json.models.JTextures;
import net.devtech.arrp.util.UnsafeByteArrayOutputStream;
import net.minecraft.advancements.Advancement;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackResources;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.storage.loot.Deserializers;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.ModLoader;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.fml.loading.FMLPaths;
import org.gtreimagined.gtlib.GTAPI;
import org.gtreimagined.gtlib.GTLib;
import org.gtreimagined.gtlib.GTLibConfig;
import org.gtreimagined.gtlib.datagen.DynamicDataPack;
import org.gtreimagined.gtlib.datagen.ICraftingLoader;
import org.gtreimagined.gtlib.datagen.IGTLibProvider;
import org.gtreimagined.gtlib.datagen.json.JGTLibModel;
import org.gtreimagined.gtlib.datagen.providers.GTBlockLootProvider;
import org.gtreimagined.gtlib.datagen.providers.GTLanguageProvider;
import org.gtreimagined.gtlib.datagen.providers.GTRecipeProvider;
import org.gtreimagined.gtlib.datagen.providers.GTTagProvider;
import org.gtreimagined.gtlib.event.GTCraftingEvent;
import org.gtreimagined.gtlib.event.GTLoaderEvent;
import org.gtreimagined.gtlib.event.GTProvidersEvent;
import org.gtreimagined.gtlib.event.GTWorldGenEvent;
import org.gtreimagined.gtlib.integration.kubejs.GTWorldEvent;
import org.gtreimagined.gtlib.integration.kubejs.KubeJSRegistrar;
import org.gtreimagined.gtlib.integration.kubejs.RecipeLoaderEventKubeJS;
import org.gtreimagined.gtlib.recipe.IRecipe;
import org.gtreimagined.gtlib.recipe.loader.IRecipeRegistrate;
import org.gtreimagined.gtlib.recipe.map.IRecipeMap;
import org.gtreimagined.gtlib.recipe.map.RecipeBuilder;
import org.gtreimagined.gtlib.recipe.map.RecipeMap;
import org.gtreimagined.gtlib.registration.IGTRegistrar;
import org.gtreimagined.gtlib.worldgen.smallore.SmallOre;
import org.gtreimagined.gtlib.worldgen.stonelayer.StoneLayer;
import org.gtreimagined.gtlib.worldgen.stonelayer.StoneLayerOre;
import org.gtreimagined.gtlib.worldgen.vanillaore.VanillaVein;

public class GTLibDynamics {
    public static final RuntimeResourcePack DYNAMIC_RESOURCE_PACK = RuntimeResourcePack.create((ResourceLocation)new ResourceLocation("gtlib", "dynamic"));
    public static final RuntimeResourcePack RUNTIME_DATA_PACK = RuntimeResourcePack.create((ResourceLocation)new ResourceLocation("gtlib", "data"), (int)8);
    public static final Gson GSON = Deserializers.m_78800_().setPrettyPrinting().disableHtmlEscaping().registerTypeAdapter(Advancement.Builder.class, (src, typeOfSrc, context) -> src.m_138400_()).registerTypeAdapter(FinishedRecipe.class, (src, typeOfSrc, context) -> src.m_125966_()).registerTypeAdapter(JGTLibModel.class, (Object)new JGTLibModel.JAntimatterModelSerializer()).registerTypeAdapter(JTextures.class, (Object)new JTextures.Serializer()).registerTypeAdapter(JCondition.class, (Object)new JCondition.Serializer()).create();
    private static final boolean exportPack = true;
    private static boolean initialized = false;
    public static final Set<ResourceLocation> RECIPE_IDS = Sets.newHashSet();
    public static final Consumer<FinishedRecipe> FINISHED_RECIPE_CONSUMER = f -> {
        if (RECIPE_IDS.add(f.m_6445_())) {
            DynamicDataPack.addRecipe(f);
        } else {
            GTLib.LOGGER.catching((Throwable)new RuntimeException("Recipe duplicated: " + String.valueOf(f.m_6445_())));
        }
    };
    private static final Object2ObjectOpenHashMap<String, List<Supplier<IGTLibProvider>>> PROVIDERS = new Object2ObjectOpenHashMap();

    public static void addResourcePacks(Consumer<PackResources> function) {
        function.accept((PackResources)DYNAMIC_RESOURCE_PACK);
    }

    public static void setInitialized() {
        initialized = true;
    }

    public static void addDataPacks(Consumer<PackResources> function) {
        if (initialized) {
            GTLibDynamics.onResourceReload(FMLEnvironment.dist.isDedicatedServer());
        }
        function.accept((PackResources)RUNTIME_DATA_PACK);
        function.accept(new DynamicDataPack("gtlib:recipes", GTAPI.all(IGTRegistrar.class).stream().map(IGTRegistrar::getDomain).collect(Collectors.toSet())));
    }

    public static void clientProvider(String domain, Supplier<IGTLibProvider> providerFunc) {
        ((List)PROVIDERS.computeIfAbsent((Object)domain, k -> new ObjectArrayList())).add(providerFunc);
    }

    public static void runDataProvidersDynamically() {
        GTBlockLootProvider.init();
        GTProvidersEvent ev = new GTProvidersEvent(GTLib.INSTANCE);
        ModLoader.get().postEvent((Event)ev);
        Collection<IGTLibProvider> providers = ev.getProviders();
        long time = System.currentTimeMillis();
        Stream async = (Stream)providers.stream().filter(IGTLibProvider::async).parallel();
        Stream<IGTLibProvider> sync = providers.stream().filter(t -> !t.async());
        Stream.concat(async, sync).forEach(IGTLibProvider::run);
        providers.forEach(IGTLibProvider::onCompletion);
        GTTagProvider.afterCompletion();
        GTBlockLootProvider.afterCompletion();
        GTLib.LOGGER.info("Time to run data providers: " + (System.currentTimeMillis() - time) + " ms.");
        if (GTLibConfig.EXPORT_DEFAULT_DATA_AND_ASSETS.get()) {
            RUNTIME_DATA_PACK.dump(FMLPaths.CONFIGDIR.get().getParent().resolve("dumped"));
        }
    }

    public static void runAssetProvidersDynamically() {
        List providers = PROVIDERS.object2ObjectEntrySet().stream().flatMap(v -> ((List)v.getValue()).stream().map(Supplier::get)).toList();
        long time = System.currentTimeMillis();
        Stream async = (Stream)providers.stream().filter(IGTLibProvider::async).parallel();
        Stream<IGTLibProvider> sync = providers.stream().filter(t -> !t.async());
        Stream.concat(async, sync).forEach(IGTLibProvider::run);
        providers.forEach(IGTLibProvider::onCompletion);
        GTLanguageProvider.postCompletion();
        GTLib.LOGGER.info("Time to run asset providers: " + (System.currentTimeMillis() - time) + " ms.");
        if (GTLibConfig.EXPORT_DEFAULT_DATA_AND_ASSETS.get()) {
            DYNAMIC_RESOURCE_PACK.dump(FMLPaths.CONFIGDIR.get().getParent().resolve("dumped"));
        }
    }

    public static void collectRecipes(GTRecipeProvider provider, Consumer<FinishedRecipe> rec) {
        GTCraftingEvent event = new GTCraftingEvent(GTLib.INSTANCE);
        ModLoader.get().postEvent((Event)event);
        for (ICraftingLoader loader : event.getLoaders()) {
            loader.loadRecipes(rec, provider);
        }
    }

    public static void onRecipeManagerBuild(Consumer<FinishedRecipe> objectIn) {
        GTLib.LOGGER.info("GTLib recipe manager running..");
        GTLibDynamics.collectRecipes(new GTRecipeProvider("gtlib", "provider"), objectIn);
        GTLib.LOGGER.info("GTLib recipe manager done..");
    }

    public static void onRecipeCompile(boolean server, RecipeManager manager) {
        List recipes;
        GTLib.LOGGER.info("Compiling GT recipes");
        long time = System.nanoTime();
        for (RecipeMap recipeMap : GTAPI.all(RecipeMap.class)) {
            if (recipeMap.getProxy() == null) continue;
            recipes = manager.m_44013_(recipeMap.getProxy().loc());
            recipes.forEach(recipe -> m.compileRecipe(m.getProxy().handler().apply((Recipe<?>)recipe, (RecipeBuilder)m.RB())));
        }
        for (RecipeType recipeType : RecipeMap.getRecipeTypes()) {
            recipes = manager.m_44013_(recipeType);
            Map<String, List<IRecipe>> map = recipes.stream().collect(Collectors.groupingBy(IRecipe::getMapId));
            for (Map.Entry<String, List<IRecipe>> entry : map.entrySet()) {
                IRecipeMap rmap;
                String name;
                String[] split = entry.getKey().split(":");
                if (split.length == 2) {
                    name = split[1];
                } else {
                    if (split.length != 1) continue;
                    name = split[0];
                }
                if ((rmap = GTAPI.get(IRecipeMap.class, name)) == null) continue;
                entry.getValue().forEach(rmap::compileRecipe);
            }
        }
        time = System.nanoTime() - time;
        int size = GTAPI.all(IRecipeMap.class).stream().mapToInt(t -> t.getRecipes(false).size()).sum();
        GTLib.LOGGER.info("Time to compile GT recipes: (ms) " + time / 1000000L);
        GTLib.LOGGER.info("No. of GT recipes: " + size);
        GTLib.LOGGER.info("Average loading time / recipe: (\u00b5s) " + (size > 0 ? time / (long)size : time) / 1000L);
    }

    public static void onResourceReload(boolean serverEvent) {
        Object ev;
        Set<Object> filter;
        GTRecipeProvider provider = new GTRecipeProvider("gtlib", "provider");
        DynamicDataPack.clearServer();
        RECIPE_IDS.clear();
        GTLibDynamics.collectRecipes(provider, FINISHED_RECIPE_CONSUMER);
        GTAPI.all(RecipeMap.class, RecipeMap::reset);
        if (GTAPI.isModLoaded("kubejs")) {
            if (serverEvent) {
                KubeJSRegistrar.checkKubeJSServerScriptManager();
            }
            RecipeLoaderEventKubeJS ev2 = RecipeLoaderEventKubeJS.createAndPost(serverEvent);
            filter = ev2.forLoaders;
        } else {
            filter = Collections.emptySet();
        }
        Object2ObjectOpenHashMap loaders = new Object2ObjectOpenHashMap(30);
        MinecraftForge.EVENT_BUS.post((Event)new GTLoaderEvent(GTLib.INSTANCE, (arg_0, arg_1, arg_2) -> GTLibDynamics.lambda$onResourceReload$9(filter, (Map)loaders, arg_0, arg_1, arg_2)));
        ObjectArrayList veins = new ObjectArrayList();
        ObjectArrayList stoneLayers = new ObjectArrayList();
        ObjectArrayList smallOres = new ObjectArrayList();
        ObjectArrayList vanillaVeins = new ObjectArrayList();
        ObjectArrayList bedrockVeins = new ObjectArrayList();
        Int2ObjectOpenHashMap collisionMap = new Int2ObjectOpenHashMap();
        boolean runRegular = true;
        if (GTAPI.isModLoaded("kubejs") && serverEvent) {
            ev = new GTWorldEvent();
            ev.post(ScriptType.SERVER, "gtlib.worldgen");
            veins.addAll(ev.VEINS);
            stoneLayers.addAll(ev.STONE_LAYERS);
            collisionMap.putAll(ev.COLLISION_MAP);
            boolean bl = runRegular = !ev.disableBuiltin;
        }
        if (runRegular) {
            ev = new GTWorldGenEvent(GTLib.INSTANCE);
            MinecraftForge.EVENT_BUS.post((Event)ev);
            veins.addAll(((GTWorldGenEvent)((Object)ev)).VEINS);
            smallOres.addAll(((GTWorldGenEvent)((Object)ev)).SMALL_ORES);
            stoneLayers.addAll(((GTWorldGenEvent)((Object)ev)).STONE_LAYERS);
            vanillaVeins.addAll(((GTWorldGenEvent)((Object)ev)).VANILLA_ORES);
            bedrockVeins.addAll(((GTWorldGenEvent)((Object)ev)).BEDROCK_VEINS);
            ((GTWorldGenEvent)((Object)ev)).COLLISION_MAP.forEach((i, l) -> ((List)collisionMap.computeIfAbsent(i, i2 -> new ArrayList())).addAll(l));
        }
        for (Record vein : veins) {
            DynamicDataPack.addWorldgenObject(vein);
        }
        for (StoneLayer stoneLayer : stoneLayers) {
            DynamicDataPack.addWorldgenObject(stoneLayer);
        }
        StoneLayer.setCollisionMap((Int2ObjectOpenHashMap<List<StoneLayerOre>>)collisionMap);
        for (SmallOre smallOre : smallOres) {
            DynamicDataPack.addWorldgenObject(smallOre);
        }
        for (VanillaVein vanillaVein : vanillaVeins) {
            DynamicDataPack.addWorldgenObject(vanillaVein);
        }
        for (Record vein : bedrockVeins) {
            DynamicDataPack.addWorldgenObject(vein);
        }
        loaders.forEach((r, l) -> {
            RecipeBuilder.setCurrentModId(r.m_135827_());
            l.init();
            RecipeBuilder.setCurrentModId("antimatter_shared");
        });
        GTLib.LOGGER.info("Amount of GTLib Recipe Loaders registered: " + loaders.size());
    }

    public static ResourceLocation getTagLoc(String identifier, ResourceLocation tagId) {
        return new ResourceLocation(tagId.m_135827_(), String.join((CharSequence)"", identifier, "/", tagId.m_135815_()));
    }

    public static byte[] serialize(Object object) {
        UnsafeByteArrayOutputStream ubaos = new UnsafeByteArrayOutputStream();
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)ubaos);
        GSON.toJson(object, (Appendable)writer);
        try {
            writer.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return ubaos.getBytes();
    }

    public static ResourceLocation fix(ResourceLocation identifier, String prefix, String append) {
        return new ResourceLocation(identifier.m_135827_(), prefix + "/" + identifier.m_135815_() + "." + append);
    }

    private static /* synthetic */ void lambda$onResourceReload$9(Set filter, Map loaders, String a, String b, IRecipeRegistrate.IRecipeLoader c) {
        if (filter.contains(new ResourceLocation(a, b))) {
            return;
        }
        if (loaders.put(new ResourceLocation(a, b), c) != null) {
            GTLib.LOGGER.warn("Duplicate recipe loader: " + String.valueOf(new ResourceLocation(a, b)));
        }
    }
}

