/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gtlib.capability.machine;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collections;
import java.util.List;
import lombok.Generated;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.gtreimagined.gtlib.Ref;
import org.gtreimagined.gtlib.blockentity.BlockEntityMachine;
import org.gtreimagined.gtlib.blockentity.BlockEntityTickable;
import org.gtreimagined.gtlib.capability.Dispatch;
import org.gtreimagined.gtlib.capability.IMachineHandler;
import org.gtreimagined.gtlib.capability.item.TrackedItemHandler;
import org.gtreimagined.gtlib.capability.machine.MachineEnergyHandler;
import org.gtreimagined.gtlib.capability.machine.MachineFluidHandler;
import org.gtreimagined.gtlib.gui.SlotType;
import org.gtreimagined.gtlib.machine.MachineState;
import org.gtreimagined.gtlib.machine.event.IMachineEvent;
import org.gtreimagined.gtlib.machine.event.MachineEvent;
import org.gtreimagined.gtlib.machine.types.Machine;
import org.gtreimagined.gtlib.recipe.IRecipe;
import org.gtreimagined.gtlib.recipe.IRecipeValidator;
import org.gtreimagined.gtlib.recipe.ingredient.FluidIngredient;
import org.gtreimagined.gtlib.recipe.map.IRecipeMap;
import org.gtreimagined.gtlib.util.FluidUtils;
import org.gtreimagined.gtlib.util.Utils;
import org.jetbrains.annotations.Nullable;

public class MachineRecipeHandler<T extends BlockEntityMachine<T>>
implements IMachineHandler,
Dispatch.Sided<MachineRecipeHandler<?>> {
    protected final T tile;
    protected final boolean generator;
    protected IRecipe lastRecipe = null;
    @Nullable
    protected IRecipe activeRecipe;
    protected boolean consumedResources;
    protected int currentProgress;
    protected int maxProgress;
    protected boolean processingBlocked = false;
    protected int overclock;
    static final int WAIT_TIME = 400;
    static final int WAIT_TIME_POWER_LOSS = 100;
    protected static final int WAIT_TIME_OUTPUT_FULL = 20;
    protected int tickTimer = 0;
    private boolean tickingRecipe = false;
    protected List<ItemStack> itemInputs = Collections.emptyList();
    protected List<FluidStack> fluidInputs = Collections.emptyList();

    public MachineRecipeHandler(T tile) {
        this.tile = tile;
        this.generator = ((BlockEntityMachine)tile).getMachineType().has("generator");
    }

    public void getInfo(List<String> builder) {
        if (this.activeRecipe != null) {
            if (((BlockEntityMachine)this.tile).getMachineState() != MachineState.ACTIVE) {
                builder.add("Active recipe but not running");
            }
            builder.add("Progress: " + this.currentProgress + "/" + this.maxProgress);
        } else {
            builder.add("No recipe active");
        }
    }

    public boolean hasRecipe() {
        return this.activeRecipe != null;
    }

    public IRecipeMap getRecipeMap() {
        return ((BlockEntityMachine)this.tile).getMachineType().getRecipeMap(((BlockEntityMachine)this.tile).getMachineTier());
    }

    public float getClientProgress() {
        return (float)this.currentProgress / (float)this.maxProgress;
    }

    @Override
    public void init() {
        this.checkRecipe();
    }

    public void resetProgress() {
        this.currentProgress = 0;
    }

    public void onServerUpdate() {
        if (this.tickingRecipe) {
            return;
        }
        if (this.tickTimer > 0) {
            if (((BlockEntityMachine)this.tile).getMachineState() == MachineState.IDLE) {
                this.tickTimer = 0;
            } else {
                --this.tickTimer;
                if (this.tickTimer > 0) {
                    return;
                }
            }
        }
        if (((BlockEntityMachine)this.tile).getMachineState() == MachineState.POWER_LOSS && this.activeRecipe != null) {
            ((BlockEntityMachine)this.tile).setMachineState(MachineState.NO_POWER);
            this.tickTimer = 0;
        }
        if (((BlockEntityMachine)this.tile).getMachineState() == MachineState.OUTPUT_FULL && this.canOutput()) {
            ((BlockEntityMachine)this.tile).setMachineState(this.recipeFinish());
            return;
        }
        if (this.activeRecipe == null) {
            if (((BlockEntityMachine)this.tile).getMachineState() == MachineState.NO_POWER) {
                ((BlockEntityMachine)this.tile).setMachineState(MachineState.IDLE);
            }
            return;
        }
        if (this.activeRecipe != null && ((BlockEntityMachine)this.tile).getMachineState() == MachineState.IDLE) {
            ((BlockEntityMachine)this.tile).setMachineState(MachineState.NO_POWER);
        }
        this.tickingRecipe = true;
        switch (((BlockEntityMachine)this.tile).getMachineState()) {
            case ACTIVE: {
                MachineState state = this.tickRecipe();
                if (state == MachineState.ACTIVE) break;
                ((BlockEntityMachine)this.tile).setMachineState(state);
                break;
            }
            case NO_POWER: {
                MachineState state = this.tickRecipe();
                if (state != MachineState.ACTIVE && state != MachineState.OUTPUT_FULL) {
                    ((BlockEntityMachine)this.tile).setMachineState(((BlockEntityMachine)this.tile).getDefaultMachineState());
                    break;
                }
                ((BlockEntityMachine)this.tile).setMachineState(state);
                break;
            }
        }
        this.tickingRecipe = false;
    }

    protected void logString(String message) {
    }

    public IRecipe findRecipe() {
        IRecipeMap map;
        if (this.lastRecipe != null) {
            this.activeRecipe = this.lastRecipe;
            if (this.canRecipeContinue()) {
                this.activeRecipe = null;
                return this.lastRecipe;
            }
            this.activeRecipe = null;
        }
        return (map = this.getRecipeMap()) != null ? map.find(((BlockEntityMachine)this.tile).itemHandler, ((BlockEntityMachine)this.tile).fluidHandler, ((BlockEntityMachine)this.tile).getMachineTier(), this::validateRecipe) : null;
    }

    protected IRecipe cachedRecipe() {
        if (this.lastRecipe != null) {
            if (!this.lastRecipe.isValid()) {
                this.lastRecipe = null;
                return null;
            }
            IRecipe old = this.activeRecipe;
            this.activeRecipe = this.lastRecipe;
            if (this.canRecipeContinue()) {
                this.activeRecipe = old;
                return this.lastRecipe;
            }
            this.activeRecipe = old;
        }
        return null;
    }

    public int getOverclock() {
        if (this.activeRecipe == null) {
            return 0;
        }
        int oc = 0;
        if (this.activeRecipe.getPower() > 0L && ((BlockEntityMachine)this.tile).getPowerLevel().getVoltage() > this.activeRecipe.getPower()) {
            long voltage = this.activeRecipe.getPower();
            int tier = Utils.getVoltageTier(voltage);
            long tempoverclock = ((BlockEntityMachine)this.tile).getPowerLevel().getVoltage() / Ref.V[tier];
            while (tempoverclock > 1L) {
                tempoverclock >>= 2;
                ++oc;
            }
        }
        return oc;
    }

    public long getPower() {
        if (this.activeRecipe == null) {
            return 0L;
        }
        if (this.overclock == 0 || ((BlockEntityMachine)this.tile).has("fe")) {
            return this.activeRecipe.getPower();
        }
        return this.activeRecipe.getPower() * (1L << this.overclock) * (((BlockEntityMachine)this.tile).getMachineType().isNoOverclockCost() ? 1L : 1L << this.overclock);
    }

    protected void calculateDurations() {
        this.maxProgress = this.activeRecipe.getDuration();
        if (!this.generator && !((BlockEntityMachine)this.tile).has("fe")) {
            this.overclock = this.getOverclock();
            this.maxProgress = Math.max(1, this.maxProgress >> this.overclock);
        }
    }

    protected void activateRecipe(boolean reset) {
        this.consumedResources = false;
        this.tickTimer = 0;
        if (reset) {
            this.currentProgress = 0;
        }
        this.lastRecipe = this.activeRecipe;
    }

    protected void addOutputs() {
        if (this.activeRecipe.hasOutputItems()) {
            ((BlockEntityMachine)this.tile).itemHandler.ifPresent(h -> {
                ItemStack[] out = this.activeRecipe.getOutputItems(true);
                if (h.canOutputsFit(out)) {
                    h.addOutputs(out);
                }
                ((BlockEntityMachine)this.tile).onMachineEvent(MachineEvent.ITEMS_OUTPUTTED, new Object[0]);
            });
        }
        if (this.activeRecipe.hasOutputFluids()) {
            ((BlockEntityMachine)this.tile).fluidHandler.ifPresent(h -> {
                h.addOutputs(this.activeRecipe.getOutputFluids());
                ((BlockEntityMachine)this.tile).onMachineEvent(MachineEvent.FLUIDS_OUTPUTTED, new Object[0]);
            });
        }
    }

    protected MachineState recipeFinish() {
        this.tickTimer = 0;
        this.addOutputs();
        this.itemInputs = new ObjectArrayList();
        this.fluidInputs = new ObjectArrayList();
        if (this.generator) {
            this.currentProgress = 0;
            return MachineState.ACTIVE;
        }
        if (!this.canRecipeContinue()) {
            this.resetRecipe();
            this.checkRecipe();
            return this.activeRecipe != null ? MachineState.ACTIVE : ((BlockEntityMachine)this.tile).getDefaultMachineState();
        }
        this.calculateDurations();
        this.activateRecipe(true);
        return MachineState.ACTIVE;
    }

    protected MachineState tickRecipe() {
        if (this.activeRecipe == null) {
            System.out.println("Check Recipe when active recipe is null");
            return ((BlockEntityMachine)this.tile).getMachineState();
        }
        if (this.currentProgress >= this.maxProgress) {
            if (!this.canOutput()) {
                this.tickTimer += 20;
                return MachineState.OUTPUT_FULL;
            }
            MachineState state = this.recipeFinish();
            if (state != MachineState.ACTIVE) {
                return state;
            }
        }
        ((BlockEntityMachine)this.tile).onRecipePreTick();
        if (!this.consumeResourceForRecipe(false)) {
            if (this.currentProgress == 0 && ((BlockEntityMachine)this.tile).getMachineState() == ((BlockEntityMachine)this.tile).getDefaultMachineState()) {
                return ((BlockEntityMachine)this.tile).getDefaultMachineState();
            }
            this.recipeFailure();
            if (!this.generator) {
                this.tickTimer += 100;
                if (((BlockEntityMachine)this.tile).getMachineState() == MachineState.ACTIVE && !((BlockEntityMachine)this.tile).isMuffled()) {
                    this.tile.m_58904_().m_5594_(null, this.tile.m_58899_(), Ref.INTERRUPT, SoundSource.BLOCKS, 1.0f, 1.0f);
                }
                return MachineState.POWER_LOSS;
            }
            this.tickTimer += 10;
            return MachineState.IDLE;
        }
        if (this.currentProgress != 0 || this.consumedResources || !this.shouldConsumeResources() || !this.consumeInputs()) {
            // empty if block
        }
        ++this.currentProgress;
        if (Machine.isAprilFools()) {
            if (this.tile.m_58904_().f_46441_.nextInt(10000) == 0) {
                this.tile.m_58904_().m_5594_(null, this.tile.m_58899_(), Ref.JOHN_CENA, SoundSource.BLOCKS, 1.0f, 1.0f);
            }
            if (this.tile.m_58904_().f_46441_.nextInt(10000) == 0) {
                this.tile.m_58904_().m_5594_(null, this.tile.m_58899_(), SoundEvents.f_11913_, SoundSource.BLOCKS, 4.0f, (1.0f + (this.tile.m_58904_().f_46441_.nextFloat() - this.tile.m_58904_().f_46441_.nextFloat()) * 0.2f) * 0.7f);
                this.tile.m_58904_().m_5594_(null, this.tile.m_58899_(), Ref.MACHINE_EXPLODE, SoundSource.BLOCKS, 1.0f, 1.0f);
            }
        }
        ((BlockEntityMachine)this.tile).onRecipePostTick();
        return MachineState.ACTIVE;
    }

    protected boolean shouldConsumeResources() {
        return !this.generator;
    }

    protected void recipeFailure() {
        this.currentProgress = 0;
    }

    public boolean consumeResourceForRecipe(boolean simulate) {
        if (this.processingBlocked) {
            return false;
        }
        if (this.activeRecipe.getPower() > 0L) {
            if (((BlockEntityMachine)this.tile).energyHandler.isPresent()) {
                if (!this.generator) {
                    return ((BlockEntityMachine)this.tile).energyHandler.map(e -> e.extractEu(this.getPower(), simulate) >= this.getPower()).orElse(false);
                }
                return this.consumeGeneratorResources(simulate);
            }
            if (((BlockEntityMachine)this.tile).feHandler.isPresent()) {
                if (!this.generator) {
                    long power = this.getPower();
                    return ((BlockEntityMachine)this.tile).feHandler.map(e -> (long)e.extractEnergy((int)power, simulate) >= power).orElse(false);
                }
                return this.consumeFEGeneratorResources(simulate);
            }
            return false;
        }
        return true;
    }

    protected boolean validateRecipe(IRecipe r) {
        long voltage = (long)((BlockEntityMachine)this.tile).getMachineType().getAmps() * ((BlockEntityMachine)this.tile).getMaxInputVoltage();
        boolean ok = this.generator || !((BlockEntityMachine)this.tile).has("eu") || voltage >= r.getPower() / (long)r.getAmps();
        List consumed = ((BlockEntityMachine)this.tile).itemHandler.map(t -> t.consumeInputs(r, true)).orElse(Collections.emptyList());
        for (IRecipeValidator validator : r.getValidators()) {
            if (validator.validate(r, (BlockEntityMachine<?>)this.tile)) continue;
            return false;
        }
        return ok && (!consumed.isEmpty() || !r.hasInputItems() || this.consumedResources);
    }

    protected boolean hasLoadedInput() {
        return !this.itemInputs.isEmpty() || !this.fluidInputs.isEmpty();
    }

    public void checkRecipe() {
        if (this.activeRecipe != null) {
            return;
        }
        if (!((BlockEntityTickable)((Object)this.tile)).hadFirstTick() && this.hasLoadedInput()) {
            if (!((BlockEntityMachine)this.tile).getMachineState().allowRecipeCheck()) {
                return;
            }
            this.activeRecipe = this.getRecipeMap().find(this.itemInputs.toArray(new ItemStack[0]), this.fluidInputs.toArray(new FluidStack[0]), ((BlockEntityMachine)this.tile).getMachineTier(), this::validateRecipe);
            if (this.activeRecipe == null) {
                return;
            }
            this.calculateDurations();
            this.lastRecipe = this.activeRecipe;
            return;
        }
        if (((BlockEntityMachine)this.tile).getMachineState().allowRecipeCheck() && ((this.activeRecipe = this.cachedRecipe()) != null || (this.activeRecipe = this.findRecipe()) != null)) {
            if (!this.validateRecipe(this.activeRecipe)) {
                ((BlockEntityMachine)this.tile).setMachineState(MachineState.INVALID_TIER);
                this.activeRecipe = null;
                return;
            }
            this.calculateDurations();
            if (!this.consumeResourceForRecipe(true) || !this.canRecipeContinue() || this.generator && (!this.activeRecipe.hasInputFluids() || this.activeRecipe.getInputFluids().size() != 1)) {
                this.activeRecipe = null;
                ((BlockEntityMachine)this.tile).setMachineState(((BlockEntityMachine)this.tile).getDefaultMachineState());
                this.tickTimer += 10;
                return;
            }
            this.activateRecipe(true);
            ((BlockEntityMachine)this.tile).setMachineState(MachineState.ACTIVE);
        }
    }

    public boolean accepts(ItemStack stack) {
        IRecipeMap map = this.getRecipeMap();
        return map == null || map.acceptsItem(stack);
    }

    public boolean accepts(FluidStack stack) {
        IRecipeMap map = this.getRecipeMap();
        return map == null || map.acceptsFluid(stack);
    }

    public boolean consumeInputs() {
        boolean flag = true;
        if (!((BlockEntityTickable)((Object)this.tile)).hadFirstTick()) {
            return true;
        }
        if (this.activeRecipe.hasInputItems()) {
            flag &= ((BlockEntityMachine)this.tile).itemHandler.map(h -> {
                this.itemInputs = h.consumeInputs(this.activeRecipe, false);
                return !this.itemInputs.isEmpty();
            }).orElse(true).booleanValue();
        }
        if (this.activeRecipe.hasInputFluids()) {
            flag &= ((BlockEntityMachine)this.tile).fluidHandler.map(h -> {
                this.fluidInputs = h.consumeAndReturnInputs(this.activeRecipe.getInputFluids(), false);
                return !this.fluidInputs.isEmpty();
            }).orElse(true).booleanValue();
        }
        if (flag) {
            this.consumedResources = true;
        }
        return flag;
    }

    public boolean canOutput() {
        if (((BlockEntityMachine)this.tile).itemHandler.isPresent() && this.activeRecipe.hasOutputItems() && !((BlockEntityMachine)this.tile).itemHandler.map(t -> t.canOutputsFit(this.activeRecipe.getOutputItems(false))).orElse(false).booleanValue()) {
            return false;
        }
        return !((BlockEntityMachine)this.tile).fluidHandler.isPresent() || !this.activeRecipe.hasOutputFluids() || ((BlockEntityMachine)this.tile).fluidHandler.map(t -> t.canOutputsFit(this.activeRecipe.getOutputFluids())).orElse(false) != false;
    }

    protected boolean canRecipeContinue() {
        return !(!this.canOutput() || this.activeRecipe.hasInputItems() && ((BlockEntityMachine)this.tile).itemHandler.map(i -> i.consumeInputs(this.activeRecipe, true).size() > 0).orElse(false) == false || this.activeRecipe.hasInputFluids() && ((BlockEntityMachine)this.tile).fluidHandler.map(t -> t.consumeAndReturnInputs(this.activeRecipe.getInputFluids(), true).size() > 0).orElse(false) == false);
    }

    protected boolean consumeFEGeneratorResources(boolean simulate) {
        if (!this.activeRecipe.hasInputFluids()) {
            throw new RuntimeException("Missing fuel in active generator recipe!");
        }
        int toConsume = this.calculateGeneratorConsumption(this.activeRecipe);
        if (toConsume == 0 || ((BlockEntityMachine)this.tile).fluidHandler.map(h -> {
            FluidIngredient in = this.activeRecipe.getInputFluids().get(0);
            int amount = in.drainedAmount(toConsume, (MachineFluidHandler<?>)h, true, true);
            if (amount == toConsume) {
                if (!simulate) {
                    in.drain(amount, (MachineFluidHandler<?>)h, true, false);
                }
                return true;
            }
            return false;
        }).orElse(false).booleanValue()) {
            if (!simulate) {
                ((BlockEntityMachine)this.tile).feHandler.ifPresent(r -> r.setEnergy((int)((long)r.getEnergyStored() + this.activeRecipe.getPower())));
            }
            return true;
        }
        return false;
    }

    protected boolean consumeGeneratorResources(boolean simulate) {
        int tFluidAmountToUse;
        if (!this.activeRecipe.hasInputFluids()) {
            throw new RuntimeException("Missing fuel in active generator recipe!");
        }
        int toConsume = this.consumedFluidPerOperation(this.activeRecipe);
        long toInsert = this.calculateGeneratorProduction(this.activeRecipe);
        MachineEnergyHandler handler = ((BlockEntityMachine)this.tile).energyHandler.orElse(null);
        if (handler == null) {
            return false;
        }
        FluidStack mFluid = ((BlockEntityMachine)this.tile).fluidHandler.map(f -> f.getInputTanks().getTank(0).getFluid()).orElse(FluidStack.EMPTY);
        if (mFluid.isEmpty()) {
            return false;
        }
        int fluidAmount = mFluid.getAmount();
        if (toInsert > 0L && toConsume > 0 && fluidAmount >= toConsume && (tFluidAmountToUse = (int)Math.min((long)(fluidAmount / toConsume), (handler.getCapacity() - handler.getEnergy()) / toInsert)) > 0 && handler.insertInternal((long)tFluidAmountToUse * toInsert, true) == (long)tFluidAmountToUse * toInsert) {
            if (this.tile.m_58904_().m_46467_() % 10L == 0L && !simulate) {
                handler.insertInternal((long)tFluidAmountToUse * toInsert, false);
                ((BlockEntityMachine)this.tile).fluidHandler.ifPresent(f -> f.drainInput(Utils.ca(tFluidAmountToUse * toConsume, mFluid), IFluidHandler.FluidAction.EXECUTE));
            }
            return true;
        }
        return false;
    }

    protected long calculateGeneratorProduction(IRecipe r) {
        return r.getPower() * (long)this.getEfficiency() * (long)this.consumedFluidPerOperation(r) / 100L;
    }

    public int consumedFluidPerOperation(IRecipe r) {
        return r.getInputFluids().get(0).getAmount();
    }

    protected int getEfficiency() {
        return ((BlockEntityMachine)this.tile).getMachineType().getMachineEfficiency(((BlockEntityMachine)this.tile).getMachineTier());
    }

    protected int calculateGeneratorConsumption(IRecipe r) {
        int amount = r.getInputFluids().get(0).getAmount();
        if (this.currentProgress > 0) {
            return 0;
        }
        return amount;
    }

    public void resetRecipe() {
        this.activeRecipe = null;
        this.consumedResources = false;
        this.currentProgress = 0;
        this.overclock = 0;
        this.maxProgress = 0;
        this.itemInputs = Collections.emptyList();
        this.fluidInputs = Collections.emptyList();
    }

    public void onMultiBlockStateChange(boolean isValid, boolean hardcore) {
        if (isValid) {
            if (((BlockEntityTickable)((Object)this.tile)).hadFirstTick()) {
                if (this.hasRecipe()) {
                    ((BlockEntityMachine)this.tile).setMachineState(MachineState.NO_POWER);
                } else {
                    this.checkRecipe();
                }
            }
        } else {
            if (this.activeRecipe != null) {
                ((BlockEntityMachine)this.tile).onMachineStop();
            }
            if (hardcore) {
                this.resetRecipe();
            }
            ((BlockEntityMachine)this.tile).resetMachine();
        }
    }

    public void onRemove() {
        this.resetRecipe();
    }

    @Override
    public void onMachineEvent(IMachineEvent event, Object ... data) {
        if (this.tickingRecipe) {
            return;
        }
        if (event instanceof SlotType) {
            if (((BlockEntityMachine)this.tile).getMachineState() == MachineState.ACTIVE) {
                return;
            }
            if (((BlockEntityMachine)this.tile).getMachineState() == MachineState.POWER_LOSS) {
                return;
            }
            if (this.activeRecipe != null && !this.consumeResourceForRecipe(true)) {
                return;
            }
            if (event == SlotType.ENERGY && ((BlockEntityMachine)this.tile).itemHandler.map(t -> ((TrackedItemHandler)t.inventories.get(SlotType.ENERGY)).getStackInSlot((Integer)data[0]).m_41619_()).orElse(true).booleanValue()) {
                return;
            }
            if ((event == SlotType.IT_OUT || event == SlotType.FL_OUT) && ((BlockEntityMachine)this.tile).getMachineState() == MachineState.OUTPUT_FULL && this.tickTimer == 0 && this.canOutput()) {
                this.tickingRecipe = true;
                ((BlockEntityMachine)this.tile).setMachineState(this.recipeFinish());
                this.tickingRecipe = false;
                return;
            }
            if (((BlockEntityMachine)this.tile).getMachineState().allowRecipeCheck()) {
                if (this.activeRecipe != null) {
                    ((BlockEntityMachine)this.tile).setMachineState(MachineState.NO_POWER);
                } else if (((BlockEntityMachine)this.tile).getMachineState() != MachineState.POWER_LOSS && this.tickTimer == 0) {
                    this.checkRecipe();
                } else if (event == SlotType.IT_IN || event == SlotType.FL_IN) {
                    this.checkRecipe();
                }
            }
        } else if (event instanceof MachineEvent) {
            switch ((MachineEvent)event) {
                case ENERGY_INPUTTED: 
                case HEAT_INPUTTED: {
                    if (event == MachineEvent.HEAT_INPUTTED && !((BlockEntityMachine)this.tile).has("heat")) break;
                    if (((BlockEntityMachine)this.tile).getMachineState() == ((BlockEntityMachine)this.tile).getDefaultMachineState() && this.activeRecipe != null) {
                        ((BlockEntityMachine)this.tile).setMachineState(MachineState.NO_POWER);
                    }
                    if (!((BlockEntityMachine)this.tile).getMachineState().allowRecipeCheck() || ((BlockEntityMachine)this.tile).getMachineState() == MachineState.POWER_LOSS || this.tickTimer != 0) break;
                    this.checkRecipe();
                    break;
                }
                case ENERGY_DRAINED: 
                case HEAT_DRAINED: {
                    if (event == MachineEvent.HEAT_DRAINED && !((BlockEntityMachine)this.tile).has("heat") || !this.generator || ((BlockEntityMachine)this.tile).getMachineState() != ((BlockEntityMachine)this.tile).getDefaultMachineState()) break;
                    if (this.activeRecipe != null) {
                        ((BlockEntityMachine)this.tile).setMachineState(MachineState.NO_POWER);
                        break;
                    }
                    this.checkRecipe();
                }
            }
        }
    }

    public CompoundTag serialize() {
        CompoundTag nbt = new CompoundTag();
        ListTag item = new ListTag();
        if (this.itemInputs.size() > 0) {
            this.itemInputs.forEach(t -> item.add((Object)t.m_41739_(new CompoundTag())));
        }
        ListTag fluid = new ListTag();
        if (this.fluidInputs.size() > 0) {
            this.fluidInputs.forEach(t -> fluid.add((Object)t.writeToNBT(new CompoundTag())));
        }
        nbt.m_128365_("I", (Tag)item);
        nbt.m_128405_("T", this.tickTimer);
        nbt.m_128365_("F", (Tag)fluid);
        nbt.m_128405_("P", this.currentProgress);
        nbt.m_128379_("C", this.consumedResources);
        nbt.m_128379_("PB", this.processingBlocked);
        if (this.activeRecipe != null) {
            nbt.m_128359_("AR", this.activeRecipe.m_6423_().toString());
        }
        if (this.lastRecipe != null) {
            nbt.m_128359_("LR", this.lastRecipe.m_6423_().toString());
        }
        return nbt;
    }

    public void deserialize(CompoundTag nbt) {
        this.itemInputs = new ObjectArrayList();
        this.fluidInputs = new ObjectArrayList();
        nbt.m_128437_("I", 10).forEach(t -> this.itemInputs.add(ItemStack.m_41712_((CompoundTag)((CompoundTag)t))));
        nbt.m_128437_("F", 10).forEach(t -> this.fluidInputs.add(FluidUtils.fromTag((CompoundTag)t)));
        this.processingBlocked = nbt.m_128471_("PB");
        this.currentProgress = nbt.m_128451_("P");
        this.tickTimer = nbt.m_128451_("T");
        this.consumedResources = nbt.m_128471_("C");
        if (this.getRecipeMap() != null) {
            this.activeRecipe = nbt.m_128441_("AR") ? this.getRecipeMap().findByID(new ResourceLocation(nbt.m_128461_("AR"))) : null;
            IRecipe iRecipe = this.lastRecipe = nbt.m_128441_("LR") ? this.getRecipeMap().findByID(new ResourceLocation(nbt.m_128461_("LR"))) : null;
        }
        if (this.activeRecipe != null) {
            this.calculateDurations();
        }
    }

    @Override
    public LazyOptional<MachineRecipeHandler<?>> forSide(Direction side) {
        return LazyOptional.of(() -> this);
    }

    @Override
    public LazyOptional<MachineRecipeHandler<?>> forNullSide() {
        return LazyOptional.of(() -> this);
    }

    @Generated
    public IRecipe getLastRecipe() {
        return this.lastRecipe;
    }

    @Nullable
    @Generated
    public IRecipe getActiveRecipe() {
        return this.activeRecipe;
    }

    @Generated
    public int getCurrentProgress() {
        return this.currentProgress;
    }

    @Generated
    public int getMaxProgress() {
        return this.maxProgress;
    }

    @Generated
    public boolean isProcessingBlocked() {
        return this.processingBlocked;
    }

    @Generated
    public void setProcessingBlocked(boolean processingBlocked) {
        this.processingBlocked = processingBlocked;
    }
}

