/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gtlib.capability.machine;

import lombok.Generated;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.util.LazyOptional;
import org.gtreimagined.gtlib.GTLib;
import org.gtreimagined.gtlib.Ref;
import org.gtreimagined.gtlib.blockentity.BlockEntityMachine;
import org.gtreimagined.gtlib.capability.CoverHandler;
import org.gtreimagined.gtlib.capability.Dispatch;
import org.gtreimagined.gtlib.capability.ICoverHandler;
import org.gtreimagined.gtlib.capability.IGuiHandler;
import org.gtreimagined.gtlib.capability.IMachineHandler;
import org.gtreimagined.gtlib.cover.CoverFactory;
import org.gtreimagined.gtlib.cover.ICover;
import org.gtreimagined.gtlib.machine.event.IMachineEvent;
import org.gtreimagined.gtlib.tool.GTToolType;
import org.gtreimagined.gtlib.util.Utils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MachineCoverHandler<T extends BlockEntityMachine<T>>
extends CoverHandler<T>
implements IMachineHandler,
Dispatch.Sided<ICoverHandler<?>> {
    ICover outputCover = ICover.empty;
    ICover secondaryOutputCover = ICover.empty;

    public MachineCoverHandler(T tile) {
        super(tile, ((BlockEntityMachine)tile).getValidCovers());
        Direction rotated;
        if (((BlockEntityMachine)tile).getMachineType().getOutputDir() != null && ((BlockEntityMachine)tile).getMachineType().getOutputCover() != ICover.emptyFactory) {
            rotated = ((BlockEntityMachine)tile).getMachineType().getOutputDir().getRotatedFacing(this.getTileFacing());
            this.outputCover = ((BlockEntityMachine)tile).getMachineType().getOutputCover().get().get(this, null, rotated, ((BlockEntityMachine)tile).getMachineType().getOutputCover());
        }
        if (((BlockEntityMachine)tile).getMachineType().getSecondaryOutputDir() != null && ((BlockEntityMachine)tile).getMachineType().getSecondaryOutputCover() != ICover.emptyFactory) {
            rotated = ((BlockEntityMachine)tile).getMachineType().getSecondaryOutputDir().getRotatedFacing(this.getTileFacing());
            this.secondaryOutputCover = ((BlockEntityMachine)tile).getMachineType().getSecondaryOutputCover().get().get(this, null, rotated, ((BlockEntityMachine)tile).getMachineType().getSecondaryOutputCover());
        }
    }

    public Direction getOutputFacing() {
        return this.outputCover.side();
    }

    public Direction getSecondaryOutputFacing() {
        return this.secondaryOutputCover.side();
    }

    @Override
    public ICover[] getAllRendered() {
        ICover[] ret = new ICover[6];
        for (Direction dir : Ref.DIRS) {
            ret[dir.m_122411_()] = this.get(dir);
            if (!ret[dir.m_122411_()].isEmpty()) continue;
            if (this.outputCover.side() == dir && !this.outputCover.isEmpty()) {
                ret[dir.m_122411_()] = this.outputCover;
                continue;
            }
            if (this.secondaryOutputCover.side() != dir || this.secondaryOutputCover.isEmpty()) continue;
            ret[dir.m_122411_()] = this.secondaryOutputCover;
        }
        return ret;
    }

    @Override
    public void readFromStack(ItemStack stack) {
        if (stack.m_41783_() != null && stack.m_41783_().m_128441_("covers")) {
            CompoundTag nbt = stack.m_41783_().m_128469_("covers");
            byte sides = nbt.m_128445_("vs");
            for (Direction dir : Direction.values()) {
                this.covers.put((Object)dir, (Object)ICover.empty);
            }
            for (int i = 0; i < Ref.DIRS.length; ++i) {
                if ((sides & 1 << i) <= 0) continue;
                Direction rotated = Utils.rotate(this.getTileFacing(), Ref.DIRS[i]);
                ICover cover = CoverFactory.readCoverRotated(this, Direction.m_122376_((int)i), rotated, nbt);
                if (cover.getFactory() == ((BlockEntityMachine)this.getTile()).getMachineType().getOutputCover()) {
                    this.outputCover = cover;
                    cover = ICover.empty;
                }
                if (cover.getFactory() == ((BlockEntityMachine)this.getTile()).getMachineType().getSecondaryOutputCover()) {
                    this.secondaryOutputCover = cover;
                    cover = ICover.empty;
                }
                this.buildLookup(((ICover)this.covers.get((Object)rotated)).getFactory(), cover.getFactory(), rotated);
                this.covers.put((Object)rotated, (Object)cover);
            }
            ((BlockEntityMachine)this.getTile()).sidedSync(true);
        }
    }

    @Override
    public void writeToStack(ItemStack machine) {
        CompoundTag tag = new CompoundTag();
        byte[] sides = new byte[1];
        this.covers.forEach((s, cover) -> {
            if (!cover.isEmpty()) {
                Direction inverseRotated = Utils.rotateInverse(this.getTileFacing(), s);
                sides[0] = (byte)(sides[0] | 1 << inverseRotated.m_122411_());
                CoverFactory.writeCover(tag, cover, inverseRotated, true);
            }
        });
        if (!tag.m_128456_()) {
            tag.m_128344_("vs", sides[0]);
            machine.m_41784_().m_128365_("covers", (Tag)tag);
        }
    }

    public boolean setOutputFacing(Player entity, Direction side) {
        boolean empty;
        Direction dir = this.getOutputFacing();
        CoverFactory factory = ((BlockEntityMachine)this.getTile()).getMachineType().getOutputCover();
        boolean bl = empty = factory == ICover.emptyFactory;
        if (dir == null && empty) {
            return false;
        }
        if (side == dir) {
            return false;
        }
        if (this.getTileFacing() == side && !((BlockEntityMachine)this.getTile()).getMachineType().allowsOutputCoversOnFacing()) {
            return false;
        }
        if (!this.secondaryOutputCover.isEmpty() && this.getSecondaryOutputFacing() == side) {
            return this.switchOutputs(entity, side);
        }
        ICover copy = factory.get().get(this, this.outputCover.getTier(), side, factory);
        copy.deserialize(this.outputCover.serialize());
        this.outputCover = copy;
        entity.m_183503_().m_5594_(null, ((BlockEntityMachine)this.getTile()).m_58899_(), Ref.WRENCH, SoundSource.BLOCKS, 1.0f, 1.0f);
        this.sync();
        if (((BlockEntityMachine)this.getTile()).m_58904_() != null) {
            if (!((BlockEntityMachine)this.getTile()).m_58904_().f_46443_) {
                ((BlockEntityMachine)this.getTile()).invalidateCaps(side);
            } else if (this.coverTexturer != null) {
                this.getTexturer(side).invalidate();
            }
        }
        return true;
    }

    public boolean setSecondaryOutputFacing(Player entity, Direction side) {
        boolean empty;
        Direction dir = this.getSecondaryOutputFacing();
        CoverFactory factory = ((BlockEntityMachine)this.getTile()).getMachineType().getSecondaryOutputCover();
        boolean bl = empty = factory == ICover.emptyFactory;
        if (dir == null && empty) {
            return false;
        }
        if (side == dir) {
            return false;
        }
        if (this.getTileFacing() == side && !((BlockEntityMachine)this.getTile()).getMachineType().allowsOutputCoversOnFacing()) {
            return false;
        }
        if (!this.outputCover.isEmpty() && this.getOutputFacing() == side) {
            return this.switchOutputs(entity, side);
        }
        ICover copy = factory.get().get(this, this.secondaryOutputCover.getTier(), side, factory);
        copy.deserialize(this.secondaryOutputCover.serialize());
        this.secondaryOutputCover = copy;
        entity.m_183503_().m_5594_(null, ((BlockEntityMachine)this.getTile()).m_58899_(), Ref.WRENCH, SoundSource.BLOCKS, 1.0f, 1.0f);
        this.sync();
        if (((BlockEntityMachine)this.getTile()).m_58904_() != null) {
            if (!((BlockEntityMachine)this.getTile()).m_58904_().f_46443_) {
                ((BlockEntityMachine)this.getTile()).invalidateCaps(side);
            } else if (this.coverTexturer != null) {
                this.getTexturer(side).invalidate();
            }
        }
        return true;
    }

    public boolean switchOutputs(Player entity, Direction side) {
        CoverFactory outputFactory = ((BlockEntityMachine)this.getTile()).getMachineType().getOutputCover();
        CoverFactory secondaryFactory = ((BlockEntityMachine)this.getTile()).getMachineType().getSecondaryOutputCover();
        Direction newOutputDir = this.getSecondaryOutputFacing();
        Direction newSecondaryOutputDir = this.getOutputFacing();
        ICover copy = secondaryFactory.get().get(this, this.outputCover.getTier(), newOutputDir, outputFactory);
        copy.deserialize(this.outputCover.serialize());
        this.outputCover = copy;
        ICover secondaryCopy = secondaryFactory.get().get(this, this.secondaryOutputCover.getTier(), newSecondaryOutputDir, secondaryFactory);
        secondaryCopy.deserialize(this.secondaryOutputCover.serialize());
        this.secondaryOutputCover = secondaryCopy;
        entity.m_183503_().m_5594_(null, ((BlockEntityMachine)this.getTile()).m_58899_(), Ref.WRENCH, SoundSource.BLOCKS, 1.0f, 1.0f);
        this.sync();
        if (((BlockEntityMachine)this.getTile()).m_58904_() != null) {
            if (!((BlockEntityMachine)this.getTile()).m_58904_().f_46443_) {
                ((BlockEntityMachine)this.getTile()).invalidateCaps(side);
            } else if (this.coverTexturer != null) {
                this.getTexturer(side).invalidate();
            }
        }
        return true;
    }

    @Override
    public boolean set(Direction side, ICover old, ICover stack, boolean sync) {
        if (this.getTileFacing() == side && !((BlockEntityMachine)this.getTile()).getMachineType().allowsFrontCovers() && !stack.isEmpty()) {
            return false;
        }
        boolean ok = super.set(side, old, stack, sync);
        if (ok && ((BlockEntityMachine)this.getTile()).m_58904_() != null) {
            if (!((BlockEntityMachine)this.getTile()).m_58904_().f_46443_) {
                ((BlockEntityMachine)this.getTile()).invalidateCaps(side);
            } else if (this.coverTexturer != null) {
                this.getTexturer(side).invalidate();
            }
        }
        return ok;
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        this.outputCover.onUpdate();
        this.secondaryOutputCover.onUpdate();
    }

    @Override
    public void onFirstTick() {
        super.onFirstTick();
        this.outputCover.onFirstTick();
        this.secondaryOutputCover.onFirstTick();
    }

    @Override
    public void onBlockUpdate(Direction side) {
        super.onBlockUpdate(side);
        if (side == this.outputCover.side()) {
            this.outputCover.onBlockUpdate();
        }
        if (side == this.secondaryOutputCover.side()) {
            this.secondaryOutputCover.onBlockUpdate();
        }
    }

    @Override
    public void onBlockUpdateAllSides() {
        super.onBlockUpdateAllSides();
        this.outputCover.onBlockUpdateAllSides();
        this.secondaryOutputCover.onBlockUpdateAllSides();
    }

    @Override
    public void onRemove() {
        super.onRemove();
        this.outputCover.onRemove();
        this.secondaryOutputCover.onRemove();
    }

    @Override
    public boolean onTransfer(Object obj, Direction side, boolean inputSide, boolean simulate) {
        boolean b = this.get(side).onTransfer(obj, inputSide, simulate);
        return b || this.outputCover.side() == side && this.outputCover.onTransfer(obj, inputSide, simulate) || this.secondaryOutputCover.side() == side && this.secondaryOutputCover.onTransfer(obj, inputSide, simulate);
    }

    @Override
    public InteractionResult onInteract(@NotNull Player player, @NotNull InteractionHand hand, @NotNull Direction side, @Nullable GTToolType type) {
        InteractionResult interactionResult = super.onInteract(player, hand, side, type);
        if (interactionResult == InteractionResult.PASS) {
            if (side == this.outputCover.side()) {
                interactionResult = this.outputCover.onInteract(player, hand, side, type);
            } else if (side == this.secondaryOutputCover.side()) {
                interactionResult = this.secondaryOutputCover.onInteract(player, hand, side, type);
            }
        }
        return interactionResult;
    }

    @Override
    public void onMachineEvent(IMachineEvent event, Object ... data) {
        this.covers.forEach((s, c) -> c.onMachineEvent((IGuiHandler)this.getTile(), event, new int[0]));
        this.outputCover.onMachineEvent((IGuiHandler)this.getTile(), event, new int[0]);
        this.secondaryOutputCover.onMachineEvent((IGuiHandler)this.getTile(), event, new int[0]);
    }

    @Override
    public boolean isValid(@NotNull Direction side, @NotNull ICover replacement) {
        if (!this.validCovers.contains(replacement.getLoc())) {
            return false;
        }
        return this.get(side).isEmpty() && !replacement.isEmpty() || super.isValid(side, replacement);
    }

    @Override
    public <U> boolean blocksCapability(Class<U> capability, Direction side) {
        return super.blocksCapability(capability, side) || side == this.outputCover.side() && this.outputCover.blocksCapability(capability, side) || side == this.secondaryOutputCover.side() && this.secondaryOutputCover.blocksCapability(capability, side);
    }

    @Override
    public <U> boolean blocksInput(Class<U> capability, Direction side) {
        return super.blocksInput(capability, side) || side == this.outputCover.side() && this.outputCover.blocksInput(capability, side) || side == this.secondaryOutputCover.side() && this.secondaryOutputCover.blocksInput(capability, side);
    }

    @Override
    public <U> boolean blocksOutput(Class<U> capability, Direction side) {
        return super.blocksOutput(capability, side) || side == this.outputCover.side() && this.outputCover.blocksOutput(capability, side) || side == this.secondaryOutputCover.side() && this.secondaryOutputCover.blocksOutput(capability, side);
    }

    @Override
    public CompoundTag serialize(CompoundTag nbt) {
        CompoundTag output;
        CompoundTag tag = super.serialize(nbt);
        if (!this.outputCover.isEmpty()) {
            output = new CompoundTag();
            CoverFactory.writeCover(output, this.outputCover, this.outputCover.side(), false);
            tag.m_128365_("outputCover", (Tag)output);
        }
        if (!this.secondaryOutputCover.isEmpty()) {
            output = new CompoundTag();
            CoverFactory.writeCover(output, this.secondaryOutputCover, this.secondaryOutputCover.side(), false);
            tag.m_128365_("secondaryOutputCover", (Tag)output);
        }
        return tag;
    }

    @Override
    public void deserialize(CompoundTag nbt) {
        byte sides = nbt.m_128445_("vs");
        boolean foundOut = false;
        boolean foundSecondaryOut = false;
        for (int i = 0; i < Ref.DIRS.length; ++i) {
            ICover outputCover;
            if ((sides & 1 << i) > 0) {
                ICover cover = CoverFactory.readCover(this, Direction.m_122376_((int)i), nbt, false);
                if (cover == null) {
                    GTLib.LOGGER.warn(String.valueOf(nbt) + "at d: " + String.valueOf(Direction.m_122376_((int)i)) + "at pos: " + String.valueOf(((BlockEntityMachine)this.getTile()).m_58899_()));
                    cover = ICover.empty;
                }
                if (cover.getFactory() == ((BlockEntityMachine)this.getTile()).getMachineType().getOutputCover()) {
                    this.outputCover = cover;
                    cover = ICover.empty;
                    foundOut = true;
                }
                if (cover.getFactory() == ((BlockEntityMachine)this.getTile()).getMachineType().getSecondaryOutputCover()) {
                    this.secondaryOutputCover = cover;
                    cover = ICover.empty;
                    foundSecondaryOut = true;
                }
                this.buildLookup(((ICover)this.covers.get((Object)Ref.DIRS[i])).getFactory(), cover.getFactory(), Ref.DIRS[i]);
                this.covers.put((Object)Ref.DIRS[i], (Object)cover);
            } else {
                this.buildLookup(((ICover)this.covers.get((Object)Ref.DIRS[i])).getFactory(), ICover.emptyFactory, Ref.DIRS[i]);
                this.covers.put((Object)Ref.DIRS[i], (Object)ICover.empty);
            }
            if (nbt.m_128441_("outputCover") && !foundOut && (outputCover = CoverFactory.readCover(this, Direction.m_122376_((int)i), nbt.m_128469_("outputCover"), false)) != null && !outputCover.isEmpty()) {
                this.outputCover = outputCover;
                foundOut = true;
            }
            if (!nbt.m_128441_("secondaryOutputCover") || foundSecondaryOut || (outputCover = CoverFactory.readCover(this, Direction.m_122376_((int)i), nbt.m_128469_("secondaryOutputCover"), false)) == null || outputCover.isEmpty()) continue;
            this.secondaryOutputCover = outputCover;
            foundSecondaryOut = true;
        }
        Level w = ((BlockEntityMachine)this.getTile()).m_58904_();
        if (w != null && w.f_46443_) {
            Utils.markTileForRenderUpdate(this.getTile());
        }
    }

    public Direction getTileFacing() {
        return ((BlockEntityMachine)this.getTile()).getFacing();
    }

    @Override
    public LazyOptional<ICoverHandler<?>> forSide(Direction side) {
        return LazyOptional.of(() -> this);
    }

    @Override
    public LazyOptional<? extends ICoverHandler<?>> forNullSide() {
        return LazyOptional.of(() -> this);
    }

    @Generated
    public ICover getOutputCover() {
        return this.outputCover;
    }

    @Generated
    public ICover getSecondaryOutputCover() {
        return this.secondaryOutputCover;
    }
}

