/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.addon.vanilla;

import mcp.mobius.waila.api.BlockAccessor;
import mcp.mobius.waila.api.IComponentProvider;
import mcp.mobius.waila.api.IServerDataProvider;
import mcp.mobius.waila.api.ITooltip;
import mcp.mobius.waila.api.config.IPluginConfig;
import mcp.mobius.waila.api.ui.IElementHelper;
import mcp.mobius.waila.impl.ui.ProgressArrowElement;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.AbstractFurnaceBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import snownee.jade.VanillaPlugin;

public class FurnaceProvider
implements IComponentProvider,
IServerDataProvider<BlockEntity> {
    public static final FurnaceProvider INSTANCE = new FurnaceProvider();

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void appendTooltip(ITooltip tooltip, BlockAccessor accessor, IPluginConfig config) {
        if (!config.get(VanillaPlugin.FURNACE)) {
            return;
        }
        int progress = accessor.getServerData().m_128451_("progress");
        if (progress == 0) {
            return;
        }
        ListTag furnaceItems = accessor.getServerData().m_128437_("furnace", 10);
        NonNullList inventory = NonNullList.m_122780_((int)3, (Object)ItemStack.f_41583_);
        for (int i = 0; i < furnaceItems.size(); ++i) {
            inventory.set(i, (Object)ItemStack.m_41712_((CompoundTag)furnaceItems.m_128728_(i)));
        }
        IElementHelper helper = tooltip.getElementHelper();
        int total = accessor.getServerData().m_128451_("total");
        tooltip.add(helper.item((ItemStack)inventory.get(0)));
        tooltip.append(helper.item((ItemStack)inventory.get(1)));
        tooltip.append(new ProgressArrowElement((float)progress / (float)total));
        tooltip.append(helper.item((ItemStack)inventory.get(2)));
    }

    @Override
    public void appendServerData(CompoundTag data, ServerPlayer player, Level world, BlockEntity blockEntity, boolean showDetails) {
        AbstractFurnaceBlockEntity furnace = (AbstractFurnaceBlockEntity)blockEntity;
        ListTag items = new ListTag();
        for (int i = 0; i < 3; ++i) {
            items.add((Object)furnace.m_8020_(i).serializeNBT());
        }
        data.m_128365_("furnace", (Tag)items);
        CompoundTag furnaceTag = furnace.m_187482_();
        data.m_128405_("progress", furnaceTag.m_128451_("CookTime"));
        data.m_128405_("total", furnaceTag.m_128451_("CookTimeTotal"));
    }
}

