/*
 * Decompiled with CFR 0.152.
 */
package frankv.jmi.jmoverlay.ftbchunks;

import dev.ftb.mods.ftbchunks.net.RequestChunkChangePacket;
import dev.ftb.mods.ftblibrary.math.XZ;
import dev.ftb.mods.ftblibrary.ui.GuiHelper;
import frankv.jmi.JMI;
import frankv.jmi.jmoverlay.ftbchunks.ClaimingMode;
import frankv.jmi.util.OverlayHelper;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import journeymap.client.api.display.Displayable;
import journeymap.client.api.display.PolygonOverlay;
import journeymap.client.api.event.FullscreenMapEvent;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.level.ChunkPos;

public class ClaimingModeHandler {
    private boolean mouseTracking = false;
    private Map<XZ, PolygonOverlay> dragPolygons = new HashMap<XZ, PolygonOverlay>();
    private HashSet<XZ> chunks = new HashSet();

    public void onPreClick(FullscreenMapEvent.ClickEvent event) {
        if (!JMI.ftbchunks || !ClaimingMode.INSTANCE.isActivated()) {
            return;
        }
        XZ xz = XZ.chunkFromBlock((int)event.getLocation().m_123341_(), (int)event.getLocation().m_123343_());
        if (!ClaimingMode.INSTANCE.getArea().contains(new ChunkPos(xz.x, xz.z))) {
            return;
        }
        this.mouseTracking = true;
        this.addToWaitingList(xz);
        event.cancel();
    }

    public void onPreDrag(FullscreenMapEvent.MouseDraggedEvent event) {
        if (!JMI.ftbchunks || !ClaimingMode.INSTANCE.isActivated()) {
            return;
        }
        XZ xz = XZ.chunkFromBlock((int)event.getLocation().m_123341_(), (int)event.getLocation().m_123343_());
        if (this.mouseTracking || ClaimingMode.INSTANCE.getArea().contains(new ChunkPos(xz.x, xz.z))) {
            event.cancel();
        }
    }

    public void onMouseMove(FullscreenMapEvent.MouseMoveEvent event) {
        if (!JMI.ftbchunks || !this.mouseTracking) {
            return;
        }
        XZ xz = XZ.chunkFromBlock((int)event.getLocation().m_123341_(), (int)event.getLocation().m_123343_());
        if (ClaimingMode.INSTANCE.getArea().contains(new ChunkPos(xz.x, xz.z)) || this.chunks.contains(xz)) {
            this.addToWaitingList(xz);
        }
    }

    public void onMouseReleased(int mouseButton) {
        if (!JMI.ftbchunks || !this.mouseTracking || mouseButton > 1) {
            return;
        }
        this.applyChanges(mouseButton);
    }

    private void addToWaitingList(XZ xz) {
        PolygonOverlay polygon = ClaimingMode.INSTANCE.dragPolygon(xz);
        OverlayHelper.showOverlay((Displayable)polygon);
        this.dragPolygons.put(xz, polygon);
        this.chunks.add(xz);
    }

    private void applyChanges(int mouseButton) {
        this.mouseTracking = false;
        if (this.chunks.isEmpty()) {
            return;
        }
        new RequestChunkChangePacket(Screen.m_96638_() ? mouseButton + 2 : mouseButton, this.chunks).sendToServer();
        OverlayHelper.removeOverlays(this.dragPolygons.values());
        this.chunks.clear();
        this.dragPolygons.clear();
        GuiHelper.playSound((SoundEvent)SoundEvents.f_12490_, (float)1.0f);
    }

    public Map<XZ, PolygonOverlay> getDragPolygons() {
        return this.dragPolygons;
    }
}

