/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.rhino;

import dev.latvian.mods.rhino.Context;
import dev.latvian.mods.rhino.ES6Generator;
import dev.latvian.mods.rhino.IdEnumeration;
import dev.latvian.mods.rhino.IdFunctionObject;
import dev.latvian.mods.rhino.IdScriptableObject;
import dev.latvian.mods.rhino.JavaScriptException;
import dev.latvian.mods.rhino.NativeObject;
import dev.latvian.mods.rhino.ScriptRuntime;
import dev.latvian.mods.rhino.Scriptable;
import dev.latvian.mods.rhino.ScriptableObject;
import dev.latvian.mods.rhino.SharedContextData;
import dev.latvian.mods.rhino.Undefined;
import dev.latvian.mods.rhino.Wrapper;
import java.util.Iterator;

public final class NativeIterator
extends IdScriptableObject {
    public static final String ITERATOR_PROPERTY_NAME = "__iterator__";
    private static final Object ITERATOR_TAG = "Iterator";
    private static final String STOP_ITERATION = "StopIteration";
    private static final int Id_constructor = 1;
    private static final int Id_next = 2;
    private static final int Id___iterator__ = 3;
    private static final int MAX_PROTOTYPE_ID = 3;
    private IdEnumeration objectIterator;

    static void init(Context cx, ScriptableObject scope, boolean sealed) {
        NativeIterator iterator = new NativeIterator();
        iterator.exportAsJSClass(3, scope, sealed);
        ES6Generator.init(scope, sealed);
        StopIteration obj = new StopIteration();
        obj.setPrototype(NativeIterator.getObjectPrototype(scope));
        obj.setParentScope(scope);
        if (sealed) {
            obj.sealObject();
        }
        NativeIterator.defineProperty(scope, STOP_ITERATION, obj, 2);
        scope.associateValue(ITERATOR_TAG, obj);
    }

    public static Object getStopIterationObject(Scriptable scope) {
        Scriptable top = NativeIterator.getTopLevelScope(scope);
        return NativeIterator.getTopScopeValue(top, ITERATOR_TAG);
    }

    private static Object jsConstructor(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        boolean keyOnly;
        if (args.length == 0 || args[0] == null || args[0] == Undefined.instance) {
            Object argument = args.length == 0 ? Undefined.instance : args[0];
            throw ScriptRuntime.typeError1("msg.no.properties", ScriptRuntime.toString(argument));
        }
        Scriptable obj = ScriptRuntime.toObject(cx, scope, args[0]);
        boolean bl = keyOnly = args.length > 1 && ScriptRuntime.toBoolean(args[1]);
        if (thisObj != null) {
            Iterator<?> iterator = NativeIterator.getJavaIterator(obj);
            if (iterator != null) {
                scope = NativeIterator.getTopLevelScope(scope);
                SharedContextData contextData = SharedContextData.get(cx, scope);
                return contextData.getWrapFactory().wrap(contextData, scope, new WrappedJavaIterator(iterator, scope), WrappedJavaIterator.class);
            }
            Scriptable jsIterator = ScriptRuntime.toIterator(cx, scope, obj, keyOnly);
            if (jsIterator != null) {
                return jsIterator;
            }
        }
        IdEnumeration objectIterator = ScriptRuntime.enumInit(obj, cx, scope, keyOnly ? 3 : 5);
        objectIterator.enumNumbers = true;
        NativeIterator result = new NativeIterator(objectIterator);
        result.setPrototype(NativeIterator.getClassPrototype(scope, result.getClassName()));
        result.setParentScope(scope);
        return result;
    }

    private static Iterator<?> getJavaIterator(Object obj) {
        if (obj instanceof Wrapper) {
            Object unwrapped = ((Wrapper)obj).unwrap();
            Iterator iterator = null;
            if (unwrapped instanceof Iterator) {
                iterator = (Iterator)unwrapped;
            }
            if (unwrapped instanceof Iterable) {
                iterator = ((Iterable)unwrapped).iterator();
            }
            return iterator;
        }
        return null;
    }

    private NativeIterator() {
    }

    private NativeIterator(IdEnumeration objectIterator) {
        this.objectIterator = objectIterator;
    }

    @Override
    public String getClassName() {
        return "Iterator";
    }

    @Override
    protected void initPrototypeId(int id) {
        int arity;
        this.initPrototypeMethod(ITERATOR_TAG, id, switch (id) {
            case 1 -> {
                arity = 2;
                yield "constructor";
            }
            case 2 -> {
                arity = 0;
                yield "next";
            }
            case 3 -> {
                arity = 1;
                yield ITERATOR_PROPERTY_NAME;
            }
            default -> throw new IllegalArgumentException(String.valueOf(id));
        }, arity);
    }

    @Override
    public Object execIdCall(IdFunctionObject f, Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        if (!f.hasTag(ITERATOR_TAG)) {
            return super.execIdCall(f, cx, scope, thisObj, args);
        }
        int id = f.methodId();
        if (id == 1) {
            return NativeIterator.jsConstructor(cx, scope, thisObj, args);
        }
        if (!(thisObj instanceof NativeIterator)) {
            throw NativeIterator.incompatibleCallError(f);
        }
        NativeIterator iterator = (NativeIterator)thisObj;
        return switch (id) {
            case 2 -> iterator.objectIterator.nextExec(cx, scope);
            case 3 -> thisObj;
            default -> throw new IllegalArgumentException(String.valueOf(id));
        };
    }

    @Override
    protected int findPrototypeId(String s) {
        return switch (s) {
            case "next" -> 2;
            case ITERATOR_PROPERTY_NAME -> 3;
            case "constructor" -> 1;
            default -> 0;
        };
    }

    public static class StopIteration
    extends NativeObject {
        private Object value = Undefined.instance;

        public StopIteration() {
        }

        public StopIteration(Object val) {
            this.value = val;
        }

        public Object getValue() {
            return this.value;
        }

        @Override
        public String getClassName() {
            return NativeIterator.STOP_ITERATION;
        }

        @Override
        public boolean hasInstance(Scriptable instance) {
            return instance instanceof StopIteration;
        }
    }

    public static class WrappedJavaIterator {
        private final Iterator<?> iterator;
        private final Scriptable scope;

        WrappedJavaIterator(Iterator<?> iterator, Scriptable scope) {
            this.iterator = iterator;
            this.scope = scope;
        }

        public Object next() {
            if (!this.iterator.hasNext()) {
                throw new JavaScriptException(NativeIterator.getStopIterationObject(this.scope), null, 0);
            }
            return this.iterator.next();
        }

        public Object __iterator__(boolean b) {
            return this;
        }
    }
}

