/*
 * Decompiled with CFR 0.152.
 */
package dev.trinsdar.bicclipboard.clipboard;

import dev.trinsdar.bicclipboard.BiCClipboardUtils;
import dev.trinsdar.bicclipboard.clipboard.CheckboxState;
import dev.trinsdar.bicclipboard.clipboard.ClipboardBlockEntity;
import dev.trinsdar.bicclipboard.clipboard.ClipboardContent;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class ClipboardBlock
extends Block
implements EntityBlock,
SimpleWaterloggedBlock {
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    private static final VoxelShape NORTH_SHAPE = BiCClipboardUtils.combine(Shapes.m_83048_((double)0.1875, (double)0.125, (double)0.9375, (double)0.8125, (double)0.8125, (double)1.0), Shapes.m_83048_((double)0.4375, (double)0.8125, (double)0.9375, (double)0.5625, (double)0.875, (double)1.0));
    private static final VoxelShape EAST_SHAPE = BiCClipboardUtils.rotate(NORTH_SHAPE, Rotation.CLOCKWISE_90);
    private static final VoxelShape SOUTH_SHAPE = BiCClipboardUtils.rotate(NORTH_SHAPE, Rotation.CLOCKWISE_180);
    private static final VoxelShape WEST_SHAPE = BiCClipboardUtils.rotate(NORTH_SHAPE, Rotation.COUNTERCLOCKWISE_90);

    public ClipboardBlock() {
        super(BlockBehaviour.Properties.m_60939_((Material)Material.f_76320_).m_60966_().m_60918_(SoundType.f_56736_));
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(false)));
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122424_());
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{FACING});
        builder.m_61104_(new Property[]{BlockStateProperties.f_61362_});
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rotation.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return state.m_60717_(mirror.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)BlockStateProperties.f_61362_) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public PushReaction m_5537_(BlockState state) {
        return PushReaction.BLOCK;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos blockPos, BlockState blockState) {
        return new ClipboardBlockEntity(blockPos, blockState);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return switch ((Direction)state.m_61143_((Property)FACING)) {
            default -> NORTH_SHAPE;
            case Direction.EAST -> EAST_SHAPE;
            case Direction.SOUTH -> SOUTH_SHAPE;
            case Direction.WEST -> WEST_SHAPE;
        };
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity entity, ItemStack stack) {
        super.m_6402_(level, pos, state, entity, stack);
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof ClipboardBlockEntity) {
            ClipboardBlockEntity clipboard = (ClipboardBlockEntity)blockEntity;
            CompoundTag clipboardTag = stack.m_41737_("clipboardContent");
            ClipboardContent clipboardContent = clipboardTag != null ? ClipboardContent.deserialize(clipboardTag) : ClipboardContent.DEFAULT;
            clipboard.setContent(clipboardContent);
        }
    }

    public List<ItemStack> m_7381_(BlockState state, LootContext.Builder params) {
        List drops1 = super.m_7381_(state, params);
        BlockEntity entity = (BlockEntity)params.m_78982_(LootContextParams.f_81462_);
        if (entity instanceof ClipboardBlockEntity) {
            ClipboardBlockEntity clipboard = (ClipboardBlockEntity)entity;
            if (!drops1.isEmpty()) {
                ItemStack stack = (ItemStack)drops1.get(0);
                CompoundTag clipboardTag = clipboard.getContent().serialize();
                stack.m_41784_().m_128365_("clipboardContent", (Tag)clipboardTag);
            }
        }
        return drops1;
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        Vec3 vec = hit.m_82450_();
        double x = hit.m_82434_().m_122434_() == Direction.Axis.Z ? vec.m_7096_() - (double)hit.m_82425_().m_123341_() : vec.m_7094_() - (double)hit.m_82425_().m_123343_();
        double y = vec.m_7098_() - (double)hit.m_82425_().m_123342_();
        if (hand == InteractionHand.MAIN_HAND) {
            int checkY;
            boolean opposite;
            if (player.m_6047_()) {
                ClipboardBlock.m_49892_((BlockState)state, (LevelAccessor)level, (BlockPos)pos, (BlockEntity)level.m_7702_(pos));
                level.m_7731_(pos, Blocks.f_50016_.m_49966_(), 3);
                return InteractionResult.m_19078_((boolean)level.m_5776_());
            }
            boolean bl = opposite = hit.m_82434_().m_122416_() > 1;
            if (hit.m_82434_() == state.m_61143_((Property)FACING) && (x < 0.73 && x > 0.697 && opposite || x < 0.3 && x > 0.265 && !opposite) && (checkY = this.getCheckY(y)) > -1) {
                if (level.m_5776_()) {
                    return InteractionResult.CONSUME;
                }
                BlockEntity blockEntity = level.m_7702_(pos);
                if (blockEntity instanceof ClipboardBlockEntity) {
                    ClipboardBlockEntity clipboard = (ClipboardBlockEntity)blockEntity;
                    List<ClipboardContent.Page> pages = this.getPages(clipboard, checkY);
                    clipboard.setContent(clipboard.getContent().setPages(pages));
                    level.m_5594_(null, pos, SoundEvents.f_12490_, SoundSource.BLOCKS, 1.0f, 1.0f);
                    return InteractionResult.SUCCESS;
                }
            }
        }
        return super.m_6227_(state, level, pos, player, hand, hit);
    }

    private int getCheckY(double y) {
        int checkY = -1;
        if (y < 0.22 && y > 0.18) {
            checkY = 8;
        }
        if (y < 0.28 && y > 0.24) {
            checkY = 7;
        }
        if (y < 0.34 && y > 0.3) {
            checkY = 6;
        }
        if (y < 0.4 && y > 0.36) {
            checkY = 5;
        }
        if (y < 0.46 && y > 0.42) {
            checkY = 4;
        }
        if (y < 0.52 && y > 0.48) {
            checkY = 3;
        }
        if (y < 0.58 && y > 0.54) {
            checkY = 2;
        }
        if (y < 0.64 && y > 0.6) {
            checkY = 1;
        }
        if (y < 0.7 && y > 0.66) {
            checkY = 0;
        }
        return checkY;
    }

    private List<ClipboardContent.Page> getPages(ClipboardBlockEntity clipboard, int checkY) {
        ClipboardContent.Page page = clipboard.getContent().pages().get(clipboard.getContent().active());
        CheckboxState checkboxState = page.checkboxes().get(checkY);
        checkboxState = checkboxState.cycle();
        ArrayList<CheckboxState> checkboxStates = new ArrayList<CheckboxState>(page.checkboxes());
        checkboxStates.set(checkY, checkboxState);
        page = page.setCheckboxes(checkboxStates);
        ArrayList<ClipboardContent.Page> pages = new ArrayList<ClipboardContent.Page>(clipboard.getContent().pages());
        pages.set(clipboard.getContent().active(), page);
        return pages;
    }
}

