/*
 * Decompiled with CFR 0.152.
 */
package dev.trinsdar.bicclipboard;

import java.util.ArrayList;
import java.util.List;
import java.util.function.UnaryOperator;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class BiCClipboardUtils {
    public static final ResourceLocation BACKGROUND_BLOCK = new ResourceLocation("bic_clipboard", "textures/gui/clipboard_block.png");
    public static final ResourceLocation BACKGROUND_GUI = new ResourceLocation("bic_clipboard", "textures/gui/clipboard.png");
    public static final ResourceLocation CHECK_TEXTURE = new ResourceLocation("bic_clipboard", "textures/gui/check.png");
    public static final ResourceLocation X_TEXTURE = new ResourceLocation("bic_clipboard", "textures/gui/x.png");
    private static final Vec3 FROM_ORIGIN = new Vec3(-0.5, -0.5, -0.5);

    public static AABB rotate(AABB box, Rotation rotation) {
        return switch (rotation) {
            default -> throw new IncompatibleClassChangeError();
            case Rotation.NONE -> box;
            case Rotation.CLOCKWISE_90 -> new AABB(-box.f_82290_, box.f_82289_, box.f_82288_, -box.f_82293_, box.f_82292_, box.f_82291_);
            case Rotation.CLOCKWISE_180 -> new AABB(-box.f_82288_, box.f_82289_, -box.f_82290_, -box.f_82291_, box.f_82292_, -box.f_82293_);
            case Rotation.COUNTERCLOCKWISE_90 -> new AABB(box.f_82290_, box.f_82289_, -box.f_82288_, box.f_82293_, box.f_82292_, -box.f_82291_);
        };
    }

    public static VoxelShape rotate(VoxelShape shape, Rotation rotation) {
        return BiCClipboardUtils.rotate(shape, box -> BiCClipboardUtils.rotate(box, rotation));
    }

    public static VoxelShape rotate(VoxelShape shape, UnaryOperator<AABB> rotateFunction) {
        ArrayList<VoxelShape> rotatedPieces = new ArrayList<VoxelShape>();
        for (AABB sourceBoundingBox : shape.m_83299_()) {
            rotatedPieces.add(Shapes.m_83064_((AABB)((AABB)rotateFunction.apply(sourceBoundingBox.m_82386_(BiCClipboardUtils.FROM_ORIGIN.f_82479_, BiCClipboardUtils.FROM_ORIGIN.f_82480_, BiCClipboardUtils.FROM_ORIGIN.f_82481_))).m_82386_(-BiCClipboardUtils.FROM_ORIGIN.f_82479_, -BiCClipboardUtils.FROM_ORIGIN.f_82481_, -BiCClipboardUtils.FROM_ORIGIN.f_82481_)));
        }
        return BiCClipboardUtils.combine(rotatedPieces.toArray(new VoxelShape[0]));
    }

    public static VoxelShape combine(VoxelShape ... shapes) {
        return BiCClipboardUtils.batchCombine(Shapes.m_83040_(), BooleanOp.f_82695_, true, shapes);
    }

    public static VoxelShape batchCombine(VoxelShape initial, BooleanOp function, boolean simplify, VoxelShape ... shapes) {
        VoxelShape combinedShape = initial;
        for (VoxelShape shape : shapes) {
            combinedShape = Shapes.m_83148_((VoxelShape)combinedShape, (VoxelShape)shape, (BooleanOp)function);
        }
        return simplify ? combinedShape.m_83296_() : combinedShape;
    }

    public static <T> List<T> extend(List<T> list, int size, T fill) {
        for (int i = list.size(); i < size; ++i) {
            list.add(fill);
        }
        return list;
    }
}

