/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbteams.net;

import dev.architectury.networking.NetworkManager;
import dev.architectury.networking.simple.BaseS2CMessage;
import dev.architectury.networking.simple.MessageType;
import dev.ftb.mods.ftbteams.client.MyTeamScreen;
import dev.ftb.mods.ftbteams.data.ClientTeamManager;
import dev.ftb.mods.ftbteams.data.Team;
import dev.ftb.mods.ftbteams.net.FTBTeamsNet;
import java.util.UUID;
import net.minecraft.network.FriendlyByteBuf;

public class SyncTeamsMessage
extends BaseS2CMessage {
    private final ClientTeamManager manager;
    private final UUID selfTeamID;
    private final boolean fullSync;

    SyncTeamsMessage(FriendlyByteBuf buffer) {
        this.manager = new ClientTeamManager(buffer);
        this.selfTeamID = buffer.m_130259_();
        this.fullSync = buffer.readBoolean();
    }

    public SyncTeamsMessage(ClientTeamManager manager, Team selfTeam, boolean fullSync) {
        this.manager = manager;
        this.selfTeamID = selfTeam.getId();
        this.fullSync = fullSync;
    }

    public MessageType getType() {
        return FTBTeamsNet.SYNC_TEAMS;
    }

    public void write(FriendlyByteBuf buffer) {
        this.manager.write(buffer, this.selfTeamID);
        buffer.m_130077_(this.selfTeamID);
        buffer.writeBoolean(this.fullSync);
    }

    public void handle(NetworkManager.PacketContext context) {
        ClientTeamManager.syncFromServer(this.manager, this.selfTeamID, this.fullSync);
        MyTeamScreen.refreshIfOpen();
    }
}

