/*
 * Decompiled with CFR 0.152.
 */
package appeng.items.tools;

import appeng.api.implementations.menuobjects.IMenuItem;
import appeng.api.networking.GridHelper;
import appeng.api.networking.IInWorldGridNodeHost;
import appeng.api.parts.IPart;
import appeng.api.parts.IPartHost;
import appeng.api.parts.SelectedPart;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.GenericStack;
import appeng.api.util.DimensionalBlockPos;
import appeng.api.util.INetworkToolAware;
import appeng.hooks.AEToolItem;
import appeng.items.AEBaseItem;
import appeng.items.contents.NetworkToolMenuHost;
import appeng.items.storage.StorageCellTooltipComponent;
import appeng.menu.MenuOpener;
import appeng.menu.locator.MenuLocators;
import appeng.menu.me.networktool.NetworkStatusMenu;
import appeng.menu.me.networktool.NetworkToolMenu;
import appeng.util.Platform;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.Nullable;

public class NetworkToolItem
extends AEBaseItem
implements IMenuItem,
AEToolItem {
    public NetworkToolItem(Item.Properties properties) {
        super(properties);
    }

    @Override
    public NetworkToolMenuHost getMenuHost(Player player, int inventorySlot, ItemStack stack, BlockPos pos) {
        Level level = player.f_19853_;
        if (pos == null) {
            return new NetworkToolMenuHost(player, inventorySlot, stack, null);
        }
        IInWorldGridNodeHost host = GridHelper.getNodeHost((LevelAccessor)level, pos);
        return new NetworkToolMenuHost(player, inventorySlot, stack, host);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player p, InteractionHand hand) {
        if (!level.m_5776_()) {
            MenuOpener.open(NetworkToolMenu.TYPE, p, MenuLocators.forHand(p, hand));
        }
        return new InteractionResultHolder(InteractionResult.m_19078_((boolean)level.m_5776_()), (Object)p.m_21120_(hand));
    }

    public InteractionResult onItemUseFirst(ItemStack stack, UseOnContext context) {
        INetworkToolAware toolAgent;
        if (context.m_7078_()) {
            return InteractionResult.PASS;
        }
        Level level = context.m_43725_();
        BlockEntity te = level.m_7702_(context.m_8083_());
        if (te instanceof IPartHost) {
            INetworkToolAware toolAgent2;
            IPart iPart;
            IPartHost partHost = (IPartHost)te;
            SelectedPart part = partHost.selectPartWorld(context.m_43720_());
            if ((part.part != null || part.facade != null) && (iPart = part.part) instanceof INetworkToolAware && !(toolAgent2 = (INetworkToolAware)((Object)iPart)).showNetworkInfo(context)) {
                return InteractionResult.PASS;
            }
        } else if (te instanceof INetworkToolAware && !(toolAgent = (INetworkToolAware)te).showNetworkInfo(context)) {
            return InteractionResult.PASS;
        }
        if (!level.m_5776_() && !this.showNetworkToolGui(context)) {
            return InteractionResult.FAIL;
        }
        return InteractionResult.m_19078_((boolean)level.m_5776_());
    }

    private boolean showNetworkToolGui(UseOnContext useContext) {
        if (useContext.m_43723_() == null) {
            return false;
        }
        BlockPos pos = useContext.m_8083_();
        Player p = useContext.m_43723_();
        Level level = useContext.m_43725_();
        InteractionHand hand = useContext.m_43724_();
        if (!Platform.hasPermissions(new DimensionalBlockPos(level, pos), p)) {
            return false;
        }
        IInWorldGridNodeHost nodeHost = GridHelper.getNodeHost((LevelAccessor)level, pos);
        if (nodeHost != null) {
            MenuOpener.open(NetworkStatusMenu.NETWORK_TOOL_TYPE, p, MenuLocators.forItemUseContext(useContext));
        } else {
            MenuOpener.open(NetworkToolMenu.TYPE, p, MenuLocators.forHand(p, hand));
        }
        return true;
    }

    @Nullable
    public static NetworkToolMenuHost findNetworkToolInv(Player player) {
        Inventory pi = player.m_150109_();
        for (int x = 0; x < pi.m_6643_(); ++x) {
            Item item;
            ItemStack pii = pi.m_8020_(x);
            if (pii.m_41619_() || !((item = pii.m_41720_()) instanceof NetworkToolItem)) continue;
            NetworkToolItem networkToolItem = (NetworkToolItem)item;
            return networkToolItem.getMenuHost(pi.f_35978_, x, pii, null);
        }
        return null;
    }

    public Optional<TooltipComponent> m_142422_(ItemStack stack) {
        NetworkToolMenuHost toolHost = new NetworkToolMenuHost(null, null, stack, null);
        if (toolHost.getInventory().isEmpty()) {
            return Optional.empty();
        }
        LinkedHashMap<AEItemKey, Integer> upgradeCards = new LinkedHashMap<AEItemKey, Integer>();
        for (ItemStack card : toolHost.getInventory()) {
            upgradeCards.merge(AEItemKey.of(card), card.m_41613_(), Integer::sum);
        }
        ArrayList<GenericStack> stacks = new ArrayList<GenericStack>(upgradeCards.size());
        for (Map.Entry entry : upgradeCards.entrySet()) {
            stacks.add(new GenericStack((AEKey)entry.getKey(), ((Integer)entry.getValue()).intValue()));
        }
        stacks.sort(Comparator.comparingLong(GenericStack::amount).reversed());
        return Optional.of(new StorageCellTooltipComponent(List.of(), stacks, false));
    }

    public boolean m_142207_(ItemStack stack, Slot slot, ClickAction action, Player player) {
        if (action != ClickAction.SECONDARY || !slot.m_150651_(player)) {
            return false;
        }
        ItemStack other = slot.m_7993_();
        if (other.m_41619_()) {
            return true;
        }
        this.insertIntoTool(stack, other, player);
        return true;
    }

    public boolean m_142305_(ItemStack stack, ItemStack other, Slot slot, ClickAction action, Player player, SlotAccess access) {
        if (action != ClickAction.SECONDARY || !slot.m_150651_(player)) {
            return false;
        }
        if (other.m_41619_()) {
            return false;
        }
        this.insertIntoTool(stack, other, player);
        return true;
    }

    private void insertIntoTool(ItemStack tool, ItemStack upgrade, Player player) {
        NetworkToolMenuHost toolHost = new NetworkToolMenuHost(player, null, tool, null);
        int amount = upgrade.m_41613_();
        ItemStack overflow = toolHost.getInventory().addItems(upgrade);
        upgrade.m_41774_(amount - overflow.m_41613_());
        toolHost.saveChanges();
    }
}

