/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.render.model;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.blaze3d.vertex.VertexFormatElement;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector4f;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.Direction;
import net.minecraftforge.client.model.pipeline.QuadGatheringTransformer;

final class MatrixVertexTransformer
extends QuadGatheringTransformer {
    private final Matrix4f transform;

    public MatrixVertexTransformer(Matrix4f transform) {
        this.transform = transform;
    }

    protected void processQuad() {
        VertexFormat format = this.parent.getVertexFormat();
        ImmutableList elements = format.m_86023_();
        int count = elements.size();
        for (int v = 0; v < 4; ++v) {
            for (int e = 0; e < count; ++e) {
                VertexFormatElement element = (VertexFormatElement)elements.get(e);
                if (element.m_86048_() == VertexFormatElement.Usage.POSITION) {
                    this.parent.put(e, this.transform(this.quadData[e][v], element.getElementCount()));
                    continue;
                }
                if (element.m_86048_() == VertexFormatElement.Usage.NORMAL) {
                    this.parent.put(e, this.transformNormal(this.quadData[e][v]));
                    continue;
                }
                this.parent.put(e, this.quadData[e][v]);
            }
        }
    }

    public void setQuadTint(int tint) {
        this.parent.setQuadTint(tint);
    }

    public void setQuadOrientation(Direction orientation) {
        this.parent.setQuadOrientation(orientation);
    }

    public void setApplyDiffuseLighting(boolean diffuse) {
        this.parent.setApplyDiffuseLighting(diffuse);
    }

    public void setTexture(TextureAtlasSprite texture) {
        this.parent.setTexture(texture);
    }

    private float[] transform(float[] fs, int elemCount) {
        switch (fs.length) {
            case 3: {
                Vector4f vec = new Vector4f(fs[0], fs[1], fs[2], 1.0f);
                vec.setX(vec.m_123601_() - 0.5f);
                vec.setY(vec.m_123615_() - 0.5f);
                vec.setZ(vec.m_123616_() - 0.5f);
                vec.m_123607_(this.transform);
                vec.setX(vec.m_123601_() + 0.5f);
                vec.setY(vec.m_123615_() + 0.5f);
                vec.setZ(vec.m_123616_() + 0.5f);
                return new float[]{vec.m_123601_(), vec.m_123615_(), vec.m_123616_()};
            }
            case 4: {
                Vector4f vecc = new Vector4f(fs[0], fs[1], fs[2], fs[3]);
                if (elemCount == 3) {
                    vecc.setW(1.0f);
                }
                vecc.setX(vecc.m_123601_() - 0.5f);
                vecc.setY(vecc.m_123615_() - 0.5f);
                vecc.setZ(vecc.m_123616_() - 0.5f);
                vecc.m_123607_(this.transform);
                vecc.setX(vecc.m_123601_() + 0.5f);
                vecc.setY(vecc.m_123615_() + 0.5f);
                vecc.setZ(vecc.m_123616_() + 0.5f);
                return new float[]{vecc.m_123601_(), vecc.m_123615_(), vecc.m_123616_(), vecc.m_123617_()};
            }
        }
        return fs;
    }

    private float[] transformNormal(float[] fs) {
        switch (fs.length) {
            case 3: {
                Vector4f normal = new Vector4f(fs[0], fs[1], fs[2], 0.0f);
                normal.m_123607_(this.transform);
                normal.m_123618_();
                return new float[]{normal.m_123601_(), normal.m_123615_(), normal.m_123616_()};
            }
            case 4: {
                Vector4f normal = new Vector4f(fs[0], fs[1], fs[2], fs[3]);
                normal.m_123607_(this.transform);
                normal.m_123618_();
                return new float[]{normal.m_123601_(), normal.m_123615_(), normal.m_123616_(), normal.m_123617_()};
            }
        }
        return fs;
    }
}

