/*
 * Decompiled with CFR 0.152.
 */
package carbonconfiglib.gui.config;

import carbonconfiglib.gui.api.DataType;
import carbonconfiglib.gui.api.IArrayNode;
import carbonconfiglib.gui.api.ICompoundNode;
import carbonconfiglib.gui.api.ISuggestionRenderer;
import carbonconfiglib.gui.api.IValueNode;
import carbonconfiglib.gui.config.ConfigElement;
import carbonconfiglib.gui.screen.EditStringScreen;
import carbonconfiglib.gui.widgets.CarbonButton;
import carbonconfiglib.gui.widgets.CarbonEditBox;
import carbonconfiglib.utils.ParseResult;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;

public class RegistryElement
extends ConfigElement {
    EditBox edit;
    ParseResult<Boolean> result;
    ISuggestionRenderer renderer;

    public RegistryElement(IValueNode value, ISuggestionRenderer renderer) {
        super(value);
        this.renderer = renderer;
    }

    public RegistryElement(IArrayNode array, IValueNode value, ISuggestionRenderer renderer) {
        super(array, value);
        this.renderer = renderer;
    }

    public RegistryElement(ICompoundNode compound, IValueNode value, ISuggestionRenderer renderer) {
        super(compound, value);
        this.renderer = renderer;
    }

    public static DataType createForType(Class<?> clz, String defaultValue) {
        ISuggestionRenderer renderer = ISuggestionRenderer.Registry.getRendererForType(clz);
        return new DataType(false, defaultValue, K -> new RegistryElement((IValueNode)K, renderer), (K, V) -> new RegistryElement((IArrayNode)K, (IValueNode)V, renderer), (K, V) -> new RegistryElement((ICompoundNode)K, (IValueNode)V, renderer));
    }

    @Override
    public void init() {
        super.init();
        if (this.isArray()) {
            this.edit = this.addChild(new CarbonEditBox(this.font, 0, 0, 130, 18), ConfigElement.GuiAlign.CENTER, 0);
            this.edit.m_94144_(this.value.get());
            this.edit.m_94151_(T -> {
                this.edit.m_94202_(0xE0E0E0);
                this.result = null;
                if (!T.isEmpty() && !(this.result = this.value.isValid((String)T)).getValue().booleanValue()) {
                    this.edit.m_94202_(0xFF0000);
                    return;
                }
                this.value.set((String)T);
            });
        } else {
            this.addChild(new CarbonButton(0, 0, 72, 18, (Component)new TranslatableComponent("gui.carbonconfig.edit"), this::onPress));
        }
    }

    private void onPress(Button button) {
        this.mc.m_91152_((Screen)new EditStringScreen(this.mc.f_91080_, this.name, this.value, this.owner.getCustomTexture()));
    }

    @Override
    protected int getMaxX(int prevMaxX) {
        return prevMaxX - (this.renderer == null ? 0 : 25);
    }

    @Override
    public void tick() {
        super.tick();
        if (this.edit != null) {
            this.edit.m_94120_();
        }
    }

    @Override
    public void m_6311_(PoseStack poseStack, int x, int top, int left, int width, int height, int mouseX, int mouseY, boolean selected, float partialTicks) {
        super.m_6311_(poseStack, x, top, left, width, height, mouseX, mouseY, selected, partialTicks);
        if (this.renderer != null) {
            int xOff = this.isArray() ? (this.moveDown.f_93624_ || this.moveUp.f_93624_ ? -7 : 1) : width - 150;
            int yOff = this.isArray() ? height / 2 - 8 : height / 2 - 9;
            Component result = this.renderer.renderSuggestion(poseStack, this.value.get(), left + xOff, top + yOff);
            if (result != null && mouseX >= left + xOff && mouseX <= left + xOff + 20 && mouseY >= top + yOff && mouseY <= top + yOff + 20) {
                this.owner.addTooltips(result);
            }
        }
        if (this.edit != null && this.edit.m_5953_((double)mouseX, (double)mouseY) && this.result != null && !this.result.getValue().booleanValue()) {
            this.owner.addTooltips((Component)new TextComponent(this.result.getError().getMessage()).m_130940_(ChatFormatting.RED));
        }
    }

    @Override
    public void updateValues() {
        if (this.edit != null) {
            this.edit.m_94144_(this.value.get());
        }
    }
}

