/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.world.river;

import net.minecraft.util.Mth;

public final class RiverHelpers {
    public static float distancePointToLineSq(float vx, float vy, float wx, float wy, float px, float py) {
        float l2 = RiverHelpers.norm2(vx - wx, vy - wy);
        if (l2 == 0.0f) {
            return l2;
        }
        float t = Mth.m_14036_((float)(((px - vx) * (wx - vx) + (py - vy) * (wy - vy)) / l2), (float)0.0f, (float)1.0f);
        float x0 = vx + t * (wx - vx);
        float y0 = vy + t * (wy - vy);
        return RiverHelpers.norm2(x0 - px, y0 - py);
    }

    public static float norm2(float x, float y) {
        return x * x + y * y;
    }

    public static float normInf(float x, float y) {
        return Math.max(Math.abs(x), Math.abs(y));
    }

    public static long pack(float x, float y) {
        return RiverHelpers.pack(RiverHelpers.floor(x), RiverHelpers.floor(y));
    }

    public static long pack(int x, int y) {
        return (long)x & 0xFFFFFFFFL | (long)y << 32;
    }

    public static int unpackX(long key) {
        return (int)key;
    }

    public static int unpackZ(long key) {
        return (int)(key >> 32);
    }

    public static int floor(float f) {
        return f >= 0.0f ? (int)f : (int)f - 1;
    }
}

