/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.world.noise;

import net.dries007.tfc.world.noise.ChunkNoiseSamplingSettings;
import net.minecraft.util.Mth;

public final class TrilinearInterpolator {
    private final ChunkNoiseSamplingSettings settings;
    private final Source source;
    private double[][] slice0;
    private double[][] slice1;
    private double noise000;
    private double noise001;
    private double noise100;
    private double noise101;
    private double noise010;
    private double noise011;
    private double noise110;
    private double noise111;
    private double valueX0Z;
    private double valueX1Z;
    private double valueXYZ;

    public TrilinearInterpolator(ChunkNoiseSamplingSettings settings, Source source) {
        this.settings = settings;
        this.source = source;
        this.slice0 = this.allocateSlice(settings.cellCountY(), settings.cellCountXZ());
        this.slice1 = this.allocateSlice(settings.cellCountY(), settings.cellCountXZ());
    }

    public void initializeForFirstCellX() {
        this.fillSlice(this.slice0, this.settings.firstCellX());
    }

    public void advanceCellX(int cellX) {
        this.fillSlice(this.slice1, this.settings.firstCellX() + cellX + 1);
    }

    public void selectCellYZ(int cellY, int cellZ) {
        this.noise000 = this.slice0[cellZ][cellY];
        this.noise001 = this.slice0[cellZ + 1][cellY];
        this.noise100 = this.slice1[cellZ][cellY];
        this.noise101 = this.slice1[cellZ + 1][cellY];
        this.noise010 = this.slice0[cellZ][cellY + 1];
        this.noise011 = this.slice0[cellZ + 1][cellY + 1];
        this.noise110 = this.slice1[cellZ][cellY + 1];
        this.noise111 = this.slice1[cellZ + 1][cellY + 1];
    }

    public void updateForXZ(double x, double z) {
        double valueX00 = Mth.m_14139_((double)x, (double)this.noise000, (double)this.noise100);
        double valueX10 = Mth.m_14139_((double)x, (double)this.noise010, (double)this.noise110);
        double valueX01 = Mth.m_14139_((double)x, (double)this.noise001, (double)this.noise101);
        double valueX11 = Mth.m_14139_((double)x, (double)this.noise011, (double)this.noise111);
        this.valueX0Z = Mth.m_14139_((double)z, (double)valueX00, (double)valueX01);
        this.valueX1Z = Mth.m_14139_((double)z, (double)valueX10, (double)valueX11);
    }

    public void updateForY(double y) {
        this.valueXYZ = Mth.m_14139_((double)y, (double)this.valueX0Z, (double)this.valueX1Z);
    }

    public double sample() {
        return this.valueXYZ;
    }

    public void swapSlices() {
        double[][] temp = this.slice0;
        this.slice0 = this.slice1;
        this.slice1 = temp;
    }

    private void fillSlice(double[][] slice, int cellX) {
        int cellWidth = this.settings.cellWidth();
        int cellHeight = this.settings.cellHeight();
        for (int dz = 0; dz < this.settings.cellCountXZ() + 1; ++dz) {
            int cellZ = this.settings.firstCellZ() + dz;
            for (int dy = 0; dy < this.settings.cellCountY() + 1; ++dy) {
                int cellY = dy + this.settings.firstCellY();
                slice[dz][dy] = this.source.sample(cellX * cellWidth, cellY * cellHeight, cellZ * cellWidth);
            }
        }
    }

    private double[][] allocateSlice(int cellCountY, int cellCountXZ) {
        int sizeXZ = cellCountXZ + 1;
        int sizeY = cellCountY + 1;
        double[][] slice = new double[sizeXZ][sizeY];
        for (int k = 0; k < sizeXZ; ++k) {
            slice[k] = new double[sizeY];
        }
        return slice;
    }

    @FunctionalInterface
    public static interface Source {
        public double sample(int var1, int var2, int var3);
    }
}

