/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.world.layer;

import net.dries007.tfc.world.layer.TFCLayers;
import net.dries007.tfc.world.layer.framework.Area;
import net.dries007.tfc.world.layer.framework.AreaContext;
import net.dries007.tfc.world.layer.framework.TransformLayer;
import net.dries007.tfc.world.river.MidpointFractal;
import net.dries007.tfc.world.river.Watershed;

public class MergeRiverLayer
implements TransformLayer {
    private final Watershed.Context watersheds;

    public MergeRiverLayer(Watershed.Context watersheds) {
        this.watersheds = watersheds;
    }

    @Override
    public int apply(AreaContext context, Area area, int x, int z) {
        int value = area.get(x, z);
        if (TFCLayers.hasRiver(value)) {
            float scale = 0.0078125f;
            float x0 = (float)x * 0.0078125f;
            float z0 = (float)z * 0.0078125f;
            for (MidpointFractal fractal : this.watersheds.getFractalsByPartition(x, z)) {
                if (!fractal.maybeIntersect(x0, z0, 0.013f) || !fractal.intersect(x0, z0, 0.013f)) continue;
                return TFCLayers.riverFor(value);
            }
        }
        return value;
    }
}

