/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.world.feature.vein;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.stream.Collectors;
import net.dries007.tfc.util.collections.IWeighted;
import net.dries007.tfc.world.Codecs;
import net.dries007.tfc.world.feature.vein.Indicator;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.PositionalRandomFactory;
import net.minecraft.world.level.levelgen.RandomSource;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.minecraft.world.level.levelgen.WorldGenerationContext;
import net.minecraft.world.level.levelgen.XoroshiroRandomSource;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import org.jetbrains.annotations.Nullable;

public class VeinConfig
implements FeatureConfiguration {
    public static final MapCodec<VeinConfig> MAP_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codecs.BLOCK_TO_WEIGHTED_BLOCKSTATE.fieldOf("blocks").forGetter(c -> c.states), (App)Indicator.CODEC.optionalFieldOf("indicator").forGetter(c -> Optional.ofNullable(c.indicator)), (App)Codecs.POSITIVE_INT.optionalFieldOf("rarity", (Object)60).forGetter(VeinConfig::getRarity), (App)Codecs.POSITIVE_INT.optionalFieldOf("size", (Object)8).forGetter(VeinConfig::getSize), (App)Codecs.UNIT_FLOAT.optionalFieldOf("density", (Object)Float.valueOf(0.2f)).forGetter(VeinConfig::getDensity), (App)VerticalAnchor.f_158914_.fieldOf("min_y").forGetter(c -> c.minY), (App)VerticalAnchor.f_158914_.fieldOf("max_y").forGetter(c -> c.maxY), (App)Codec.STRING.fieldOf("random_name").forGetter(c -> c.randomName), (App)TagKey.m_203886_((ResourceKey)Registry.f_122885_).optionalFieldOf("biomes").forGetter(c -> Optional.ofNullable(c.biomes))).apply((Applicative)instance, VeinConfig::new));
    public static final Codec<VeinConfig> CODEC = MAP_CODEC.codec();
    private final Map<Block, IWeighted<BlockState>> states;
    @Nullable
    private final Indicator indicator;
    private final int rarity;
    private final int size;
    private final float density;
    private final VerticalAnchor minY;
    private final VerticalAnchor maxY;
    private final String randomName;
    @Nullable
    private final TagKey<Biome> biomes;
    private final PositionalRandomFactory fork;

    public VeinConfig(VeinConfig other) {
        this(other.states, Optional.ofNullable(other.indicator), other.rarity, other.size, other.density, other.minY, other.maxY, other.randomName, Optional.ofNullable(other.biomes));
    }

    public VeinConfig(Map<Block, IWeighted<BlockState>> states, Optional<Indicator> indicator, int rarity, int size, float density, VerticalAnchor minY, VerticalAnchor maxY, String randomName, Optional<TagKey<Biome>> biomes) {
        this.states = states;
        this.indicator = indicator.orElse(null);
        this.rarity = rarity;
        this.size = size;
        this.density = density;
        this.minY = minY;
        this.maxY = maxY;
        this.randomName = randomName;
        this.biomes = biomes.orElse(null);
        this.fork = new XoroshiroRandomSource(18729341234L, 9182639418231L).m_183423_().m_183211_(randomName).m_183423_();
    }

    public Set<BlockState> getOreStates() {
        return this.states.values().stream().flatMap(weighted -> weighted.values().stream()).collect(Collectors.toSet());
    }

    @Nullable
    public BlockState getStateToGenerate(BlockState stoneState, Random random) {
        IWeighted<BlockState> weighted = this.states.get(stoneState.m_60734_());
        if (weighted != null) {
            return weighted.get(random);
        }
        return null;
    }

    public boolean canSpawnInBiome(Holder<Biome> biome) {
        return this.biomes == null || biome.m_203656_(this.biomes);
    }

    public RandomSource random(long levelSeed, int chunkX, int chunkZ) {
        return this.fork.m_183161_((int)levelSeed, chunkX, chunkZ);
    }

    @Nullable
    public Indicator getIndicator() {
        return this.indicator;
    }

    public int getSize() {
        return this.size;
    }

    public int getRarity() {
        return this.rarity;
    }

    public float getDensity() {
        return this.density;
    }

    public int getChunkRadius() {
        return 1 + (this.size >> 4);
    }

    public int getMinY(WorldGenerationContext context) {
        return this.minY.m_142322_(context);
    }

    public int getMaxY(WorldGenerationContext context) {
        return this.maxY.m_142322_(context);
    }
}

