/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.world.feature;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Map;
import java.util.Random;
import java.util.function.Function;
import net.dries007.tfc.world.Codecs;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import org.jetbrains.annotations.Nullable;

public record SoilDiscConfig(Map<Block, BlockState> states, int minRadius, int maxRadius, int height) implements FeatureConfiguration
{
    public static final Codec<SoilDiscConfig> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codecs.mapListCodec(Codecs.recordPairCodec(Codecs.BLOCK, "replace", Codecs.BLOCK_STATE, "with")).fieldOf("states").forGetter(c -> c.states), (App)Codecs.POSITIVE_INT.fieldOf("min_radius").forGetter(c -> c.minRadius), (App)Codecs.POSITIVE_INT.fieldOf("max_radius").forGetter(c -> c.maxRadius), (App)Codec.intRange((int)0, (int)256).fieldOf("height").forGetter(c -> c.height)).apply((Applicative)instance, SoilDiscConfig::new)).comapFlatMap(c -> {
        if (c.maxRadius < c.minRadius) {
            return DataResult.error((String)("Maximum radius (provided = " + c.maxRadius + ") must be >= min radius (provided = " + c.minRadius + ")"));
        }
        return DataResult.success((Object)c);
    }, Function.identity());

    public int getRadius(Random random) {
        if (this.maxRadius > this.minRadius) {
            return this.minRadius + random.nextInt(this.maxRadius - this.minRadius);
        }
        return this.minRadius;
    }

    public int getHeight() {
        return this.height;
    }

    @Nullable
    public BlockState getState(BlockState stateIn) {
        return this.states.get(stateIn.m_60734_());
    }
}

