/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.world.feature;

import com.mojang.serialization.Codec;
import java.util.List;
import java.util.Random;
import java.util.function.Supplier;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.world.chunkdata.ChunkData;
import net.dries007.tfc.world.chunkdata.ChunkDataProvider;
import net.dries007.tfc.world.feature.BoulderConfig;
import net.dries007.tfc.world.noise.Metaballs3D;
import net.dries007.tfc.world.settings.RockSettings;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;

public class BouldersFeature
extends Feature<BoulderConfig> {
    public BouldersFeature(Codec<BoulderConfig> codec) {
        super(codec);
    }

    public boolean m_142674_(FeaturePlaceContext<BoulderConfig> context) {
        ChunkDataProvider provider;
        ChunkData data;
        RockSettings rock;
        WorldGenLevel level = context.m_159774_();
        BlockPos pos = context.m_159777_();
        Random random = context.m_159776_();
        BoulderConfig config = (BoulderConfig)context.m_159778_();
        List<BlockState> states = config.getStates((rock = (data = (provider = ChunkDataProvider.get(context.m_159775_())).get(context.m_159774_(), pos)).getRockData().getRock(pos)).raw());
        if (states != null) {
            this.place(level, pos, states, random);
            return true;
        }
        return false;
    }

    private void place(WorldGenLevel level, BlockPos pos, List<BlockState> states, Random random) {
        Supplier<BlockState> state;
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
        int size = 6 + random.nextInt(4);
        Metaballs3D noise = new Metaballs3D(Helpers.fork(random), 6, 8, -0.12f * (float)size, 0.3f * (float)size, 0.3f * (float)size);
        if (states.size() == 1) {
            BlockState onlyState = states.get(0);
            state = () -> onlyState;
        } else {
            state = () -> (BlockState)states.get(random.nextInt(states.size()));
        }
        for (int x = -size; x <= size; ++x) {
            for (int y = -size; y <= size; ++y) {
                for (int z = -size; z <= size; ++z) {
                    if (!noise.inside(x, y, z)) continue;
                    mutablePos.m_122154_((Vec3i)pos, x, y, z);
                    this.m_5974_((LevelWriter)level, (BlockPos)mutablePos, state.get());
                }
            }
        }
    }
}

