/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.world.chunkdata;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import net.dries007.tfc.network.PacketHandler;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.world.chunkdata.ChunkData;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelReader;
import net.minecraftforge.network.PacketDistributor;
import org.jetbrains.annotations.Nullable;

public final class ChunkDataCache {
    public static final ChunkDataCache CLIENT = new ChunkDataCache("client");
    public static final ChunkDataCache SERVER = new ChunkDataCache("server");
    public static final WatchQueue WATCH_QUEUE = new WatchQueue();
    private final Map<ChunkPos, ChunkData> cache;
    private final String name;

    public static ChunkDataCache get(LevelReader world) {
        return Helpers.isClientSide(world) ? CLIENT : SERVER;
    }

    private ChunkDataCache(String name) {
        this.name = name;
        this.cache = new HashMap<ChunkPos, ChunkData>();
    }

    @Nullable
    public ChunkData get(ChunkPos pos) {
        return this.cache.get(pos);
    }

    @Nullable
    public ChunkData remove(ChunkPos pos) {
        return this.cache.remove(pos);
    }

    public void update(ChunkPos pos, ChunkData data) {
        this.cache.put(pos, data);
    }

    public ChunkData computeIfAbsent(ChunkPos pos, Function<ChunkPos, ChunkData> mappingFunction) {
        return this.cache.computeIfAbsent(pos, mappingFunction);
    }

    public String toString() {
        return "ChunkDataCache[" + this.name + "]";
    }

    public static class WatchQueue {
        private final Map<ChunkPos, Set<ServerPlayer>> queue = new HashMap<ChunkPos, Set<ServerPlayer>>(256);

        private WatchQueue() {
        }

        public void enqueueUnloadedChunk(ChunkPos pos, ServerPlayer player) {
            this.queue.computeIfAbsent(pos, key -> new HashSet()).add(player);
        }

        public void dequeueChunk(ChunkPos pos, ServerPlayer player) {
            Set<ServerPlayer> players = this.queue.get(pos);
            if (players != null) {
                players.remove(player);
                if (players.isEmpty()) {
                    this.queue.remove(pos);
                }
            }
        }

        public void dequeueLoadedChunk(ChunkPos pos, ChunkData data) {
            if (this.queue.containsKey(pos)) {
                Set<ServerPlayer> players = this.queue.remove(pos);
                for (ServerPlayer player : players) {
                    PacketHandler.send(PacketDistributor.PLAYER.with(() -> player), data.getUpdatePacket());
                }
            }
        }
    }
}

