/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.world.chunkdata;

import java.util.Objects;
import net.dries007.tfc.network.ChunkWatchPacket;
import net.dries007.tfc.world.chunkdata.ChunkDataCache;
import net.dries007.tfc.world.chunkdata.ChunkDataCapability;
import net.dries007.tfc.world.chunkdata.ForestType;
import net.dries007.tfc.world.chunkdata.LerpFloatLayer;
import net.dries007.tfc.world.chunkdata.PlateTectonicsClassification;
import net.dries007.tfc.world.chunkdata.RockData;
import net.dries007.tfc.world.settings.RockLayerSettings;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChunkData
implements ICapabilitySerializable<CompoundTag> {
    public static final ChunkData EMPTY = new Immutable();
    private static final float UNKNOWN_RAINFALL = 250.0f;
    private static final float UNKNOWN_TEMPERATURE = 10.0f;
    private final LazyOptional<ChunkData> capability;
    private final RockLayerSettings rockLayerSettings;
    private final ChunkPos pos;
    private Status status;
    @Nullable
    private RockData rockData;
    @Nullable
    private LerpFloatLayer rainfallLayer;
    @Nullable
    private LerpFloatLayer temperatureLayer;
    private int @Nullable [] aquiferSurfaceHeight;
    private ForestType forestType;
    private float forestWeirdness;
    private float forestDensity;
    private PlateTectonicsClassification plateTectonicsInfo;

    public static ChunkData get(LevelReader level, BlockPos pos) {
        return ChunkData.get(level, new ChunkPos(pos));
    }

    public static ChunkData get(LevelReader level, ChunkPos pos) {
        ChunkData data = ChunkDataCache.get(level).get(pos);
        if (data == null) {
            return (ChunkData)ChunkData.getCapability(level.m_7232_(pos.f_45578_, pos.f_45579_) ? level.m_46865_(pos.m_45615_()) : null).orElse((Object)EMPTY);
        }
        return data;
    }

    public static LazyOptional<ChunkData> getCapability(@Nullable ChunkAccess maybe) {
        if (maybe instanceof LevelChunk) {
            LevelChunk chunk = (LevelChunk)maybe;
            return chunk.getCapability(ChunkDataCapability.CAPABILITY);
        }
        return LazyOptional.empty();
    }

    public static ChunkData createClient(ChunkPos pos) {
        return new ChunkData(pos, RockLayerSettings.EMPTY);
    }

    public ChunkData(ChunkPos pos, RockLayerSettings rockLayerSettings) {
        this.pos = pos;
        this.rockLayerSettings = rockLayerSettings;
        this.capability = LazyOptional.of(() -> this);
        this.status = Status.EMPTY;
        this.forestType = ForestType.NONE;
        this.plateTectonicsInfo = PlateTectonicsClassification.OCEANIC;
    }

    public ChunkPos getPos() {
        return this.pos;
    }

    public RockData getRockData() {
        return Objects.requireNonNull(this.rockData);
    }

    public void setRockData(RockData rockData) {
        this.rockData = rockData;
    }

    public int[] getAquiferSurfaceHeight() {
        return Objects.requireNonNull(this.aquiferSurfaceHeight, "Missing aquifer surface height at " + this.pos);
    }

    public void setAquiferSurfaceHeight(int[] aquiferSurfaceHeight) {
        this.aquiferSurfaceHeight = aquiferSurfaceHeight;
    }

    public float getRainfall(BlockPos pos) {
        return this.getRainfall(pos.m_123341_(), pos.m_123343_());
    }

    public float getRainfall(int x, int z) {
        return this.rainfallLayer == null ? 250.0f : this.rainfallLayer.getValue((float)(z & 0xF) / 16.0f, 1.0f - (float)(x & 0xF) / 16.0f);
    }

    public void setRainfall(LerpFloatLayer rainfallLayer) {
        this.rainfallLayer = rainfallLayer;
    }

    public float getAverageTemp(BlockPos pos) {
        return this.getAverageTemp(pos.m_123341_(), pos.m_123343_());
    }

    public float getAverageTemp(int x, int z) {
        return this.temperatureLayer == null ? 10.0f : this.temperatureLayer.getValue((float)(z & 0xF) / 16.0f, 1.0f - (float)(x & 0xF) / 16.0f);
    }

    public void setAverageTemp(LerpFloatLayer temperatureLayer) {
        this.temperatureLayer = temperatureLayer;
    }

    public void setFloraData(ForestType forestType, float forestWeirdness, float forestDensity) {
        this.forestType = forestType;
        this.forestWeirdness = forestWeirdness;
        this.forestDensity = forestDensity;
    }

    public ForestType getForestType() {
        return this.forestType;
    }

    public float getForestWeirdness() {
        return this.forestWeirdness;
    }

    public float getForestDensity() {
        return this.forestDensity;
    }

    public float getAdjustedForestDensity() {
        return this.forestDensity * 0.6f + 0.4f * (float)this.forestType.ordinal() / 4.0f;
    }

    public PlateTectonicsClassification getPlateTectonicsInfo() {
        return this.plateTectonicsInfo;
    }

    public void setPlateTectonicsInfo(PlateTectonicsClassification plateTectonicsInfo) {
        this.plateTectonicsInfo = plateTectonicsInfo;
    }

    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public ChunkWatchPacket getUpdatePacket() {
        return new ChunkWatchPacket(this.pos.f_45578_, this.pos.f_45579_, this.rainfallLayer, this.temperatureLayer, this.forestType, this.forestDensity, this.forestWeirdness, this.plateTectonicsInfo);
    }

    public void onUpdatePacket(@Nullable LerpFloatLayer rainfallLayer, @Nullable LerpFloatLayer temperatureLayer, ForestType forestType, float forestDensity, float forestWeirdness, PlateTectonicsClassification plateTectonicsInfo) {
        this.rainfallLayer = rainfallLayer;
        this.temperatureLayer = temperatureLayer;
        this.forestType = forestType;
        this.forestDensity = forestDensity;
        this.forestWeirdness = forestWeirdness;
        this.plateTectonicsInfo = plateTectonicsInfo;
        switch (this.status) {
            case EMPTY: {
                this.status = Status.CLIENT;
                break;
            }
            case FULL: {
                throw new IllegalStateException("ChunkData#onUpdatePacket was called on full data: " + this);
            }
        }
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(Capability<T> cap, @Nullable Direction side) {
        return ChunkDataCapability.CAPABILITY.orEmpty(cap, this.capability);
    }

    public CompoundTag serializeNBT() {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128344_("status", (byte)this.status.ordinal());
        if (this.status == Status.FULL) {
            nbt.m_128344_("plateTectonicsInfo", (byte)this.plateTectonicsInfo.ordinal());
            if (this.rainfallLayer != null) {
                nbt.m_128365_("rainfall", (Tag)this.rainfallLayer.write());
            }
            if (this.temperatureLayer != null) {
                nbt.m_128365_("temperature", (Tag)this.temperatureLayer.write());
            }
            nbt.m_128344_("forestType", (byte)this.forestType.ordinal());
            nbt.m_128350_("forestWeirdness", this.forestWeirdness);
            nbt.m_128350_("forestDensity", this.forestDensity);
            if (this.rockData != null) {
                nbt.m_128365_("rockData", (Tag)this.rockData.write(this.rockLayerSettings));
            }
            if (this.aquiferSurfaceHeight != null) {
                nbt.m_128385_("aquiferSurfaceHeight", this.aquiferSurfaceHeight);
            }
        }
        return nbt;
    }

    public void deserializeNBT(CompoundTag nbt) {
        this.status = Status.valueOf(nbt.m_128445_("status"));
        if (this.status == Status.FULL) {
            this.plateTectonicsInfo = PlateTectonicsClassification.valueOf(nbt.m_128445_("plateTectonicsInfo"));
            this.rainfallLayer = nbt.m_128441_("rainfall") ? new LerpFloatLayer(nbt.m_128469_("rainfall")) : null;
            this.temperatureLayer = nbt.m_128441_("temperature") ? new LerpFloatLayer(nbt.m_128469_("temperature")) : null;
            this.rockData = nbt.m_128425_("rockData", 10) ? new RockData(nbt.m_128469_("rockData"), this.rockLayerSettings) : null;
            this.aquiferSurfaceHeight = nbt.m_128441_("aquiferSurfaceHeight") ? nbt.m_128465_("aquiferSurfaceHeight") : null;
            this.forestType = ForestType.valueOf(nbt.m_128445_("forestType"));
            this.forestWeirdness = nbt.m_128457_("forestWeirdness");
            this.forestDensity = nbt.m_128457_("forestDensity");
        } else {
            this.plateTectonicsInfo = PlateTectonicsClassification.OCEANIC;
            this.rainfallLayer = null;
            this.temperatureLayer = null;
            this.rockData = null;
            this.aquiferSurfaceHeight = null;
            this.forestType = ForestType.NONE;
            this.forestWeirdness = 0.5f;
            this.forestDensity = 0.5f;
        }
    }

    public String toString() {
        return "ChunkData{pos=" + this.pos + ", status=" + this.status + ", hashCode=" + Integer.toHexString(this.hashCode()) + "}";
    }

    public static enum Status {
        EMPTY,
        CLIENT,
        FULL;

        private static final Status[] VALUES;

        public static Status valueOf(int i) {
            return i >= 0 && i < VALUES.length ? VALUES[i] : EMPTY;
        }

        static {
            VALUES = Status.values();
        }
    }

    private static final class Immutable
    extends ChunkData {
        private Immutable() {
            super(new ChunkPos(ChunkPos.f_45577_), RockLayerSettings.EMPTY);
        }

        @Override
        public void setRockData(RockData rockData) {
            throw new UnsupportedOperationException("Tried to modify immutable chunk data");
        }

        @Override
        public void setAquiferSurfaceHeight(int[] aquiferSurfaceHeight) {
            throw new UnsupportedOperationException("Tried to modify immutable chunk data");
        }

        @Override
        public void setRainfall(LerpFloatLayer rainfallLayer) {
            throw new UnsupportedOperationException("Tried to modify immutable chunk data");
        }

        @Override
        public void setAverageTemp(LerpFloatLayer temperatureLayer) {
            throw new UnsupportedOperationException("Tried to modify immutable chunk data");
        }

        @Override
        public void setFloraData(ForestType forestType, float forestWeirdness, float forestDensity) {
            throw new UnsupportedOperationException("Tried to modify immutable chunk data");
        }

        @Override
        public void setPlateTectonicsInfo(PlateTectonicsClassification plateTectonicsInfo) {
            throw new UnsupportedOperationException("Tried to modify immutable chunk data");
        }

        @Override
        public void setStatus(Status status) {
            throw new UnsupportedOperationException("Tried to modify immutable chunk data");
        }

        @Override
        public void onUpdatePacket(@Nullable LerpFloatLayer rainfallLayer, @Nullable LerpFloatLayer temperatureLayer, ForestType forestType, float forestDensity, float forestWeirdness, PlateTectonicsClassification plateTectonicsInfo) {
            throw new UnsupportedOperationException("Tried to modify immutable chunk data");
        }

        @Override
        public void deserializeNBT(CompoundTag nbt) {
            throw new UnsupportedOperationException("Tried to modify immutable chunk data");
        }

        @Override
        public String toString() {
            return "ImmutableChunkData";
        }
    }
}

