/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.world;

import it.unimi.dsi.fastutil.objects.Object2DoubleMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.dries007.tfc.common.fluids.RiverWaterFluid;
import net.dries007.tfc.common.fluids.TFCFluids;
import net.dries007.tfc.world.BiomeNoiseSampler;
import net.dries007.tfc.world.ChunkBaseBlockSource;
import net.dries007.tfc.world.ChunkHeightFiller;
import net.dries007.tfc.world.Sampler;
import net.dries007.tfc.world.TFCAquifer;
import net.dries007.tfc.world.biome.BiomeExtension;
import net.dries007.tfc.world.biome.BiomeResolver;
import net.dries007.tfc.world.biome.RiverSource;
import net.dries007.tfc.world.biome.TFCBiomes;
import net.dries007.tfc.world.noise.ChunkNoiseSamplingSettings;
import net.dries007.tfc.world.noise.NoiseSampler;
import net.dries007.tfc.world.noise.TrilinearInterpolator;
import net.dries007.tfc.world.river.Flow;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.QuartPos;
import net.minecraft.util.Mth;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.CarvingMask;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.chunk.ProtoChunk;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;

public class ChunkNoiseFiller
extends ChunkHeightFiller {
    public static final int[] EXTERIOR_POINTS = (int[])Util.m_137469_((Object)new int[66], array -> {
        int index = 0;
        for (int x = 0; x < 7; ++x) {
            for (int z = 0; z < 7; ++z) {
                if (x >= 1 && z >= 1 && x <= 4 && z <= 4) continue;
                array[index++] = x;
                array[index++] = z;
            }
        }
    });
    public static final int EXTERIOR_POINTS_COUNT = EXTERIOR_POINTS.length >> 1;
    private final LevelAccessor level;
    private final ProtoChunk chunk;
    private final int chunkMinX;
    private final int chunkMinZ;
    private final int quartX;
    private final int quartZ;
    private final Heightmap oceanFloor;
    private final Heightmap worldSurface;
    private final CarvingMask airCarvingMask;
    private final int seaLevel;
    private final RiverSource riverSource;
    private final FluidState riverWater;
    private final Flow[] flows;
    private final ChunkNoiseSamplingSettings settings;
    private final List<TrilinearInterpolator> interpolators;
    private final TrilinearInterpolator noiseCaves;
    private final TrilinearInterpolator noodleToggle;
    private final TrilinearInterpolator noodleThickness;
    private final TrilinearInterpolator noodleRidgeA;
    private final TrilinearInterpolator noodleRidgeB;
    private final TFCAquifer aquifer;
    private final ChunkBaseBlockSource baseBlockSource;
    private final BiomeResolver biomeResolver;
    private final int[] surfaceHeight;
    private final Biome[] localBiomes;
    private final double[] localBiomeWeights;
    private int blockX;
    private int blockZ;
    private int localX;
    private int localZ;
    private double cellDeltaX;
    private double cellDeltaZ;
    private int lastCellZ;

    public ChunkNoiseFiller(LevelAccessor level, ProtoChunk chunk, Object2DoubleMap<BiomeExtension>[] sampledBiomeWeights, RiverSource riverSource, Map<BiomeExtension, BiomeNoiseSampler> biomeNoiseSamplers, BiomeResolver biomeResolver, NoiseSampler sampler, ChunkBaseBlockSource baseBlockSource, ChunkNoiseSamplingSettings settings, int seaLevel) {
        super(biomeNoiseSamplers, sampledBiomeWeights);
        this.level = level;
        this.chunk = chunk;
        this.chunkMinX = chunk.m_7697_().m_45604_();
        this.chunkMinZ = chunk.m_7697_().m_45605_();
        this.quartX = QuartPos.m_175400_((int)this.chunkMinX);
        this.quartZ = QuartPos.m_175400_((int)this.chunkMinZ);
        this.oceanFloor = chunk.m_6005_(Heightmap.Types.OCEAN_FLOOR_WG);
        this.worldSurface = chunk.m_6005_(Heightmap.Types.WORLD_SURFACE_WG);
        this.airCarvingMask = chunk.m_183613_(GenerationStep.Carving.AIR);
        this.seaLevel = seaLevel;
        this.riverSource = riverSource;
        this.riverWater = ((RiverWaterFluid)TFCFluids.RIVER_WATER.get()).m_76145_();
        this.flows = this.buildFlowMap();
        this.settings = settings;
        this.interpolators = new ArrayList<TrilinearInterpolator>();
        this.baseBlockSource = baseBlockSource;
        this.noiseCaves = this.addInterpolator(sampler.noiseCaves);
        this.noodleToggle = this.addInterpolator(sampler.noodleToggle);
        this.noodleThickness = this.addInterpolator(sampler.noodleThickness);
        this.noodleRidgeA = this.addInterpolator(sampler.noodleRidgeA);
        this.noodleRidgeB = this.addInterpolator(sampler.noodleRidgeB);
        this.aquifer = new TFCAquifer(chunk.m_7697_(), settings, baseBlockSource, seaLevel, sampler.positionalRandomFactory, sampler.barrierNoise);
        this.biomeResolver = biomeResolver;
        this.surfaceHeight = new int[256];
        this.localBiomes = new Biome[256];
        this.localBiomeWeights = new double[256];
    }

    public TFCAquifer aquifer() {
        return this.aquifer;
    }

    public void setupAquiferSurfaceHeight(Sampler<BiomeExtension> biomeSampler) {
        int z;
        int x;
        boolean debugAquiferSurfaceHeight = false;
        double[] sampledHeight = new double[121];
        int[] aquiferSurfaceHeights = this.aquifer.getSurfaceHeights();
        for (x = 0; x < 11; ++x) {
            for (z = 0; z < 11; ++z) {
                int actualX = this.chunkMinX - 32 + (x << 3);
                int actualZ = this.chunkMinZ - 32 + (z << 3);
                BiomeExtension biome = biomeSampler.get(actualX, actualZ);
                BiomeNoiseSampler sampler = (BiomeNoiseSampler)this.biomeNoiseSamplers.get(biome);
                sampler.setColumn(actualX, actualZ);
                double aquiferSurfaceHeight = biome.getAquiferSurfaceHeight(sampler.height());
                if (aquiferSurfaceHeight > (double)this.seaLevel) {
                    aquiferSurfaceHeight = 0.3 * (double)this.seaLevel + 0.7 * aquiferSurfaceHeight;
                }
                sampledHeight[x + 11 * z] = aquiferSurfaceHeight;
            }
        }
        for (x = 0; x < 4; ++x) {
            for (z = 0; z < 4; ++z) {
                double minAquiferSurfaceHeight = Double.MAX_VALUE;
                int xIndex = 1 + x << 1;
                int zIndex = 1 + z << 1;
                for (int dx = -2; dx <= 2; ++dx) {
                    for (int dz = -2; dz <= 2; ++dz) {
                        minAquiferSurfaceHeight = Math.min(minAquiferSurfaceHeight, sampledHeight[xIndex + dx + 11 * (zIndex + dz)]);
                    }
                }
                aquiferSurfaceHeights[x + 4 * z] = (int)minAquiferSurfaceHeight;
            }
        }
    }

    public int[] getSurfaceHeight() {
        return this.surfaceHeight;
    }

    public Biome[] getLocalBiomes() {
        return this.localBiomes;
    }

    public double[] getLocalBiomeWeights() {
        return this.localBiomeWeights;
    }

    public void fillFromNoise() {
        this.initializeForFirstCellX();
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
        for (int cellX = 0; cellX < this.settings.cellCountXZ(); ++cellX) {
            this.advanceCellX(cellX);
            for (int cellZ = 0; cellZ < this.settings.cellCountXZ(); ++cellZ) {
                for (int localCellX = 0; localCellX < this.settings.cellWidth(); ++localCellX) {
                    this.blockX = this.chunkMinX + cellX * this.settings.cellWidth() + localCellX;
                    this.localX = this.blockX & 0xF;
                    this.cellDeltaX = (double)localCellX / (double)this.settings.cellWidth();
                    for (int localCellZ = 0; localCellZ < this.settings.cellWidth(); ++localCellZ) {
                        this.blockZ = this.chunkMinZ + cellZ * this.settings.cellWidth() + localCellZ;
                        this.lastCellZ = cellZ;
                        this.localZ = this.blockZ & 0xF;
                        this.cellDeltaZ = (double)localCellZ / (double)this.settings.cellWidth();
                        mutablePos.m_122178_(this.blockX, 0, this.blockZ);
                        this.fillColumn(mutablePos, cellX, cellZ);
                    }
                }
            }
            this.swapSlices();
        }
    }

    public double[] getSlopeMap() {
        int z;
        int x;
        int[] quartSurfaceHeight = new int[49];
        for (int x2 = 0; x2 < 4; ++x2) {
            for (int z2 = 0; z2 < 4; ++z2) {
                quartSurfaceHeight[x2 + 1 + 7 * (z2 + 1)] = this.surfaceHeight[(x2 << 2) + 16 * (z2 << 2)];
            }
        }
        for (int i = 0; i < EXTERIOR_POINTS_COUNT; ++i) {
            x = EXTERIOR_POINTS[i << 1];
            z = EXTERIOR_POINTS[i << 1 | 1];
            int x0 = this.chunkMinX + (x - 1 << 2);
            int z0 = this.chunkMinZ + (z - 1 << 2);
            this.setupColumn(x0, z0);
            quartSurfaceHeight[x + 7 * z] = (int)this.sampleColumnHeightAndBiome((Object2DoubleMap<BiomeExtension>)this.sampledBiomeWeights[x + z * 7], this.blockX, this.blockZ, false);
        }
        double[] slopeMap = new double[36];
        for (x = 0; x < 6; ++x) {
            for (z = 0; z < 6; ++z) {
                double slope;
                double nw = quartSurfaceHeight[x + 0 + 7 * (z + 0)];
                double ne = quartSurfaceHeight[x + 1 + 7 * (z + 0)];
                double sw = quartSurfaceHeight[x + 0 + 7 * (z + 1)];
                double se = quartSurfaceHeight[x + 1 + 7 * (z + 1)];
                double center = (nw + ne + sw + se) / 4.0;
                slopeMap[x + 6 * z] = slope = Math.abs(nw - center) + Math.abs(ne - center) + Math.abs(sw - center) + Math.abs(se - center);
            }
        }
        return slopeMap;
    }

    @Override
    protected void afterSampleColumnHeightAndBiome(Object2DoubleMap<BiomeExtension> biomeWeights, BiomeExtension biomeAt, double actualHeight) {
        this.localBiomes[this.localX + 16 * this.localZ] = (Biome)this.biomeResolver.sample(biomeAt).m_203334_();
        this.localBiomeWeights[this.localX + 16 * this.localZ] = biomeWeights.getOrDefault((Object)biomeAt, 0.5);
        this.surfaceHeight[this.localX + 16 * this.localZ] = (int)actualHeight;
    }

    private void fillColumn(BlockPos.MutableBlockPos cursor, int cellX, int cellZ) {
        boolean debugFillColumn = false;
        this.prepareColumnBiomeWeights(this.localX, this.localZ);
        this.sampleColumnHeightAndBiome((Object2DoubleMap<BiomeExtension>)this.biomeWeights1, this.blockX, this.blockZ, true);
        int heightNoiseValue = this.surfaceHeight[this.localX + 16 * this.localZ];
        Flow flow = this.calculateFlowAt(cellX, cellZ);
        int maxFilledY = 1 + Math.max(heightNoiseValue, this.seaLevel);
        int maxFilledCellY = Math.min(this.settings.cellCountY() - 1, 1 + Math.floorDiv(maxFilledY, this.settings.cellHeight()) - this.settings.firstCellY());
        int maxFilledSectionY = Math.min(this.chunk.m_151559_() - 1, 1 + this.chunk.m_151564_(maxFilledY));
        boolean topBlockPlaced = false;
        boolean topSolidBlockPlaced = false;
        LevelChunkSection section = this.chunk.m_183278_(maxFilledSectionY);
        for (int cellY = maxFilledCellY; cellY >= 0; --cellY) {
            this.selectCellYZ(cellY, this.lastCellZ);
            this.updateForXZ(this.cellDeltaX, this.cellDeltaZ);
            for (int localCellY = this.settings.cellHeight() - 1; localCellY >= 0; --localCellY) {
                int y = (this.settings.firstCellY() + cellY) * this.settings.cellHeight() + localCellY;
                if (y >= maxFilledY) continue;
                int localY = y & 0xF;
                int sectionIndex = this.chunk.m_151564_(y);
                if (this.chunk.m_151564_(section.m_63017_()) != sectionIndex) {
                    section = this.chunk.m_183278_(sectionIndex);
                }
                double cellDeltaY = (double)localCellY / (double)this.settings.cellHeight();
                this.updateForY(cellDeltaY);
                double noise = this.calculateNoiseAtHeight(y, heightNoiseValue);
                BlockState state = this.calculateBlockStateAtNoise(this.blockX, y, this.blockZ, noise);
                FluidState fluid = state.m_60819_();
                cursor.m_142448_(y);
                if (!state.m_60795_()) {
                    if (fluid.m_76152_() == Fluids.f_76193_ && flow != Flow.NONE && y >= Math.min(this.seaLevel - 4, heightNoiseValue)) {
                        section.m_62991_(this.localX, localY, this.localZ, ((FluidState)this.riverWater.m_61124_(RiverWaterFluid.FLOW, (Comparable)((Object)flow))).m_76188_(), false);
                    } else {
                        section.m_62991_(this.localX, localY, this.localZ, state, false);
                    }
                    if (this.aquifer.m_142203_() && !fluid.m_76178_()) {
                        this.chunk.m_8113_((BlockPos)cursor);
                    }
                    if (state.m_60791_() != 0) {
                        this.chunk.m_63277_((BlockPos)cursor);
                    }
                }
                if (state.m_60795_()) {
                    if (!topSolidBlockPlaced) continue;
                    this.airCarvingMask.m_187585_(this.blockX, y, this.blockZ);
                    section.m_62991_(this.localX, localY, this.localZ, Blocks.f_50627_.m_49966_(), false);
                    continue;
                }
                if (!fluid.m_76178_()) {
                    if (!topBlockPlaced) {
                        topBlockPlaced = true;
                        this.worldSurface.m_64249_(this.localX, y, this.localZ, state);
                    }
                    if (!topSolidBlockPlaced) continue;
                    this.airCarvingMask.m_187585_(this.blockX, y, this.blockZ);
                    continue;
                }
                if (!topBlockPlaced) {
                    topBlockPlaced = true;
                    this.worldSurface.m_64249_(this.localX, y, this.localZ, state);
                }
                if (topSolidBlockPlaced) continue;
                topSolidBlockPlaced = true;
                this.oceanFloor.m_64249_(this.localX, y, this.localZ, state);
            }
        }
    }

    private Flow[] buildFlowMap() {
        Flow[] flowMap = new Flow[25];
        for (int x = 0; x < 5; ++x) {
            for (int z = 0; z < 5; ++z) {
                flowMap[x + 5 * z] = this.riverSource.getRiverFlow(this.quartX + x, this.quartZ + z);
            }
        }
        return flowMap;
    }

    private Flow calculateFlowAt(int cellX, int cellZ) {
        if (TFCBiomes.getExtensionOrThrow(this.level, this.localBiomes[this.localX + 16 * this.localZ]).isRiver()) {
            Flow flow00 = this.flows[cellX + 5 * cellZ];
            Flow flow10 = this.flows[cellX + 5 * (cellZ + 1)];
            Flow flow01 = this.flows[cellX + 1 + 5 * cellZ];
            Flow flow11 = this.flows[cellX + 1 + 5 * (cellZ + 1)];
            return Flow.lerp(flow00, flow01, flow10, flow11, (float)this.cellDeltaX, (float)this.cellDeltaZ);
        }
        return Flow.NONE;
    }

    private double calculateNoiseAtHeight(int y, double heightNoiseValue) {
        double noise = 0.0;
        for (Object2DoubleMap.Entry entry : this.columnBiomeNoiseSamplers.object2DoubleEntrySet()) {
            BiomeNoiseSampler sampler = (BiomeNoiseSampler)entry.getKey();
            noise += sampler.noise(y) * entry.getDoubleValue();
        }
        noise = 0.4 - noise;
        if ((double)y > heightNoiseValue) {
            noise -= ((double)y - heightNoiseValue) * (double)0.2f;
        }
        return Mth.m_14008_((double)noise, (double)-1.0, (double)1.0);
    }

    public BlockState calculateBlockStateAtNoise(int x, int y, int z, double terrainNoise) {
        double terrainAndCaveNoise = terrainNoise;
        if (this.noodleToggle.sample() >= 0.0) {
            double thickness = Mth.m_144851_((double)this.noodleThickness.sample(), (double)-1.0, (double)1.0, (double)0.05, (double)0.1);
            double ridgeA = Math.abs(1.5 * this.noodleRidgeA.sample()) - thickness;
            double ridgeB = Math.abs(1.5 * this.noodleRidgeB.sample()) - thickness;
            double ridge = Math.max(ridgeA, ridgeB);
            terrainAndCaveNoise = Math.min(terrainAndCaveNoise, ridge);
        }
        terrainAndCaveNoise = Math.min(terrainAndCaveNoise, this.noiseCaves.sample());
        BlockState aquiferState = this.aquifer.sampleState(x, y, z, terrainAndCaveNoise);
        return Objects.requireNonNullElseGet(aquiferState, () -> this.baseBlockSource.getBaseBlock(x, y, z));
    }

    private void setupColumn(int x, int z) {
        this.blockX = x;
        this.blockZ = z;
        this.localX = x & 0xF;
        this.localZ = z & 0xF;
    }

    private TrilinearInterpolator addInterpolator(TrilinearInterpolator.Source source) {
        TrilinearInterpolator interpolator = new TrilinearInterpolator(this.settings, source);
        this.interpolators.add(interpolator);
        return interpolator;
    }

    private void initializeForFirstCellX() {
        this.interpolators.forEach(TrilinearInterpolator::initializeForFirstCellX);
    }

    private void advanceCellX(int cellX) {
        this.interpolators.forEach(i -> i.advanceCellX(cellX));
    }

    private void selectCellYZ(int cellY, int cellZ) {
        this.interpolators.forEach(i -> i.selectCellYZ(cellY, cellZ));
    }

    private void updateForXZ(double x, double z) {
        this.interpolators.forEach(i -> i.updateForXZ(x, z));
    }

    private void updateForY(double y) {
        this.interpolators.forEach(i -> i.updateForY(y));
    }

    private void swapSlices() {
        this.interpolators.forEach(TrilinearInterpolator::swapSlices);
    }
}

