/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.world;

import it.unimi.dsi.fastutil.objects.Object2DoubleMap;
import it.unimi.dsi.fastutil.objects.Object2DoubleOpenHashMap;
import java.util.Map;
import net.dries007.tfc.world.BiomeNoiseSampler;
import net.dries007.tfc.world.TFCChunkGenerator;
import net.dries007.tfc.world.biome.BiomeExtension;
import net.minecraft.util.Mth;

public class ChunkHeightFiller {
    protected final Map<BiomeExtension, BiomeNoiseSampler> biomeNoiseSamplers;
    protected final Object2DoubleMap<BiomeNoiseSampler> columnBiomeNoiseSamplers;
    protected final Object2DoubleMap<BiomeExtension>[] sampledBiomeWeights;
    protected final Object2DoubleMap<BiomeExtension> biomeWeights1;

    public ChunkHeightFiller(Map<BiomeExtension, BiomeNoiseSampler> biomeNoiseSamplers, Object2DoubleMap<BiomeExtension>[] sampledBiomeWeights) {
        this.biomeNoiseSamplers = biomeNoiseSamplers;
        this.columnBiomeNoiseSamplers = new Object2DoubleOpenHashMap();
        this.sampledBiomeWeights = sampledBiomeWeights;
        this.biomeWeights1 = new Object2DoubleOpenHashMap();
    }

    public double sampleHeight(int blockX, int blockZ) {
        this.prepareColumnBiomeWeights(blockX & 0xF, blockZ & 0xF);
        return this.sampleColumnHeightAndBiome(this.biomeWeights1, blockX, blockZ, false);
    }

    protected void prepareColumnBiomeWeights(int localX, int localZ) {
        int index4X = (localX >> 2) + 1;
        int index4Z = (localZ >> 2) + 1;
        double lerpX = (double)(localX - (localX >> 2 << 2)) * 0.25;
        double lerpZ = (double)(localZ - (localZ >> 2 << 2)) * 0.25;
        this.biomeWeights1.clear();
        TFCChunkGenerator.sampleBiomesCornerContribution(this.biomeWeights1, this.sampledBiomeWeights[index4X + index4Z * 7], (1.0 - lerpX) * (1.0 - lerpZ));
        TFCChunkGenerator.sampleBiomesCornerContribution(this.biomeWeights1, this.sampledBiomeWeights[index4X + 1 + index4Z * 7], lerpX * (1.0 - lerpZ));
        TFCChunkGenerator.sampleBiomesCornerContribution(this.biomeWeights1, this.sampledBiomeWeights[index4X + (index4Z + 1) * 7], (1.0 - lerpX) * lerpZ);
        TFCChunkGenerator.sampleBiomesCornerContribution(this.biomeWeights1, this.sampledBiomeWeights[index4X + 1 + (index4Z + 1) * 7], lerpX * lerpZ);
    }

    protected double sampleColumnHeightAndBiome(Object2DoubleMap<BiomeExtension> biomeWeights, int blockX, int blockZ, boolean updateArrays) {
        double aboveWaterDelta;
        this.columnBiomeNoiseSamplers.clear();
        double totalHeight = 0.0;
        double riverHeight = 0.0;
        double shoreHeight = 0.0;
        double riverWeight = 0.0;
        double shoreWeight = 0.0;
        BiomeExtension biomeAt = null;
        BiomeExtension normalBiomeAt = null;
        BiomeExtension riverBiomeAt = null;
        BiomeExtension shoreBiomeAt = null;
        double maxNormalWeight = 0.0;
        double maxRiverWeight = 0.0;
        double maxShoreWeight = 0.0;
        BiomeExtension oceanicBiomeAt = null;
        double oceanicWeight = 0.0;
        double maxOceanicWeight = 0.0;
        for (Object2DoubleMap.Entry entry : biomeWeights.object2DoubleEntrySet()) {
            double weight = entry.getDoubleValue();
            BiomeExtension variants = (BiomeExtension)entry.getKey();
            BiomeNoiseSampler sampler = this.biomeNoiseSamplers.get(variants);
            if (this.columnBiomeNoiseSamplers.containsKey((Object)sampler)) {
                this.columnBiomeNoiseSamplers.mergeDouble((Object)sampler, weight, Double::sum);
            } else {
                sampler.setColumn(blockX, blockZ);
                this.columnBiomeNoiseSamplers.put((Object)sampler, weight);
            }
            double height = weight * sampler.height();
            totalHeight += height;
            if (variants.isRiver()) {
                riverHeight += height;
                riverWeight += weight;
                if (maxRiverWeight < weight) {
                    riverBiomeAt = (BiomeExtension)entry.getKey();
                    maxRiverWeight = weight;
                }
            } else if (variants.isShore()) {
                shoreHeight += height;
                shoreWeight += weight;
                if (maxShoreWeight < weight) {
                    shoreBiomeAt = (BiomeExtension)entry.getKey();
                    maxShoreWeight = weight;
                }
            } else if (maxNormalWeight < weight) {
                normalBiomeAt = (BiomeExtension)entry.getKey();
                maxNormalWeight = weight;
            }
            if (!variants.isSalty()) continue;
            oceanicWeight += weight;
            if (!(maxOceanicWeight < weight)) continue;
            oceanicBiomeAt = (BiomeExtension)entry.getKey();
            maxOceanicWeight = weight;
        }
        double actualHeight = totalHeight;
        if (riverWeight > 0.6 && riverBiomeAt != null) {
            aboveWaterDelta = Mth.m_14008_((double)(actualHeight - riverHeight / riverWeight), (double)0.0, (double)20.0);
            double adjustedAboveWaterDelta = 0.02 * aboveWaterDelta * (40.0 - aboveWaterDelta) - 0.48;
            double actualHeightWithRiverContribution = riverHeight / riverWeight + adjustedAboveWaterDelta;
            double normalWeight = 1.0 - riverWeight - shoreWeight;
            double oceanicContribution = Mth.m_14008_((double)(oceanicWeight == 0.0 || normalWeight == 0.0 ? 0.0 : oceanicWeight / normalWeight), (double)0.0, (double)1.0);
            if (oceanicContribution < 0.5) {
                actualHeight = Mth.m_14139_((double)(2.0 * oceanicContribution), (double)actualHeightWithRiverContribution, (double)actualHeight);
                biomeAt = riverBiomeAt;
            } else {
                biomeAt = oceanicBiomeAt;
            }
        } else if (riverWeight > 0.0 && normalBiomeAt != null) {
            double adjustedRiverWeight = 0.6 * riverWeight;
            actualHeight = (totalHeight - riverHeight) * ((1.0 - adjustedRiverWeight) / (1.0 - riverWeight)) + riverHeight * (adjustedRiverWeight / riverWeight);
            biomeAt = normalBiomeAt;
        } else if (normalBiomeAt != null) {
            biomeAt = normalBiomeAt;
        }
        if ((shoreWeight > 0.6 || maxShoreWeight > maxNormalWeight) && shoreBiomeAt != null) {
            aboveWaterDelta = actualHeight - shoreHeight / shoreWeight;
            if (aboveWaterDelta > 0.0) {
                if (aboveWaterDelta > 20.0) {
                    aboveWaterDelta = 20.0;
                }
                double adjustedAboveWaterDelta = 0.02 * aboveWaterDelta * (40.0 - aboveWaterDelta) - 0.48;
                actualHeight = shoreHeight / shoreWeight + adjustedAboveWaterDelta;
            }
            biomeAt = shoreBiomeAt;
        }
        assert (biomeAt != null);
        if (updateArrays) {
            this.afterSampleColumnHeightAndBiome(biomeWeights, biomeAt, actualHeight);
        }
        return actualHeight;
    }

    protected void afterSampleColumnHeightAndBiome(Object2DoubleMap<BiomeExtension> biomeWeights, BiomeExtension biomeAt, double actualHeight) {
    }
}

