/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.world;

import net.dries007.tfc.world.noise.Noise2D;

public interface BiomeNoiseSampler {
    public static final double SOLID = 0.0;
    public static final double AIR_THRESHOLD = 0.4;

    public static BiomeNoiseSampler fromHeightNoise(final Noise2D heightNoise) {
        return new BiomeNoiseSampler(){
            private float height;

            @Override
            public void setColumn(int x, int z) {
                this.height = heightNoise.noise(x, z);
            }

            @Override
            public double height() {
                return this.height;
            }

            @Override
            public double noise(int y) {
                return 0.0;
            }
        };
    }

    public static BiomeNoiseSampler fromHeightAndCarvingNoise(final Noise2D heightNoise, final Noise2D carvingCenterNoise, final Noise2D carvingHeightNoise) {
        return new BiomeNoiseSampler(){
            private float height;
            private float carvingHeight;
            private float carvingCenter;

            @Override
            public void setColumn(int x, int z) {
                this.height = heightNoise.noise(x, z);
                this.carvingHeight = carvingHeightNoise.noise(x, z);
                this.carvingCenter = carvingCenterNoise.noise(x, z);
            }

            @Override
            public double height() {
                return this.height;
            }

            @Override
            public double noise(int y) {
                float distance = Math.abs((float)y - this.carvingCenter) / this.carvingHeight;
                return Math.max(1.0f - distance * distance, 0.0f);
            }
        };
    }

    public void setColumn(int var1, int var2);

    public double height();

    public double noise(int var1);
}

