/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.util.collections;

import com.mojang.datafixers.util.Pair;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Random;

public interface IWeighted<E>
extends Iterable<E> {
    public static final IWeighted<?> EMPTY = new IWeighted<Object>(){

        @Override
        public void add(double weight, Object element) {
            throw new UnsupportedOperationException("Cannot add to singleton EMPTY weighted list!");
        }

        @Override
        public Object get(Random random) {
            return null;
        }

        @Override
        public Collection<Object> values() {
            return Collections.emptyList();
        }

        @Override
        public List<Pair<Object, Double>> weightedValues() {
            return Collections.emptyList();
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        public Iterator<Object> iterator() {
            return Collections.emptyIterator();
        }

        public String toString() {
            return "[]";
        }
    };

    public static <E> IWeighted<E> empty() {
        return EMPTY;
    }

    public static <E> IWeighted<E> singleton(final E element) {
        return new IWeighted<E>(){
            private final Collection<E> elementSet;
            {
                this.elementSet = Collections.singleton(element);
            }

            @Override
            public void add(double weight, E element2) {
                throw new UnsupportedOperationException("Cannot add an element to a singleton IWeighted<E>");
            }

            @Override
            public E get(Random random) {
                return element;
            }

            @Override
            public Collection<E> values() {
                return this.elementSet;
            }

            @Override
            public List<Pair<E, Double>> weightedValues() {
                return Collections.singletonList(Pair.of((Object)element, (Object)1.0));
            }

            @Override
            public boolean isEmpty() {
                return false;
            }

            @Override
            public Iterator<E> iterator() {
                return this.elementSet.iterator();
            }

            public String toString() {
                return "[" + element + "]";
            }
        };
    }

    public void add(double var1, E var3);

    public E get(Random var1);

    public Collection<E> values();

    public List<Pair<E, Double>> weightedValues();

    public boolean isEmpty();
}

