/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.util;

import com.google.common.collect.Sets;
import it.unimi.dsi.fastutil.objects.Object2DoubleMap;
import it.unimi.dsi.fastutil.objects.Object2DoubleOpenHashMap;
import java.util.Map;
import java.util.Set;
import net.dries007.tfc.common.recipes.AlloyRecipe;
import net.dries007.tfc.common.recipes.inventory.AlloyInventory;
import net.dries007.tfc.util.AlloyView;
import net.dries007.tfc.util.Metal;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.crafting.RecipeManager;
import org.jetbrains.annotations.Nullable;

public class Alloy
implements AlloyView {
    public static final int MAX_ALLOY = 0x7FFFFFFD;
    public static final double EPSILON = 4.656612875245797E-10;
    private final Object2DoubleMap<Metal> metalMap = new Object2DoubleOpenHashMap();
    private final Object2DoubleMap<Metal> sanitizedMetalMap = new Object2DoubleOpenHashMap();
    private int totalUnits = 0;
    private int maxUnits;
    @Nullable
    private AlloyInventory wrapper;
    @Nullable
    private Metal cachedResult;

    public Alloy() {
        this(0x7FFFFFFD);
    }

    public Alloy(int maxUnits) {
        this.maxUnits = maxUnits;
    }

    public void add(Alloy other) {
        int newTotalAmount = this.totalUnits + other.totalUnits;
        double keepRatio = 1.0;
        if (newTotalAmount > this.maxUnits) {
            keepRatio = (double)(this.maxUnits - this.totalUnits) / (double)other.totalUnits;
        }
        this.totalUnits += other.totalUnits;
        for (Map.Entry entry : other.metalMap.object2DoubleEntrySet()) {
            this.metalMap.mergeDouble((Object)((Metal)entry.getKey()), keepRatio * (Double)entry.getValue(), Double::sum);
        }
        this.updateCaches();
    }

    public int add(Metal metal, int amount, boolean simulate) {
        if (this.totalUnits + amount >= this.maxUnits && (amount = this.maxUnits - this.totalUnits) <= 0) {
            return 0;
        }
        if (!simulate) {
            this.metalMap.mergeDouble((Object)metal, (double)amount, Double::sum);
            this.totalUnits += amount;
            this.updateCaches();
        }
        return amount;
    }

    @Override
    public Metal getResult(RecipeManager recipes) {
        if (this.cachedResult == null) {
            this.cachedResult = this.metalMap.size() == 1 ? (Metal)this.metalMap.keySet().iterator().next() : AlloyRecipe.get(recipes, this.getWrapper()).map(AlloyRecipe::getResult).orElseGet(Metal::unknown);
        }
        if (this.cachedResult == null) {
            return Metal.unknown();
        }
        return this.cachedResult;
    }

    public int removeAlloy(int removeAmount, boolean simulate) {
        if (simulate) {
            return Math.min(this.totalUnits, removeAmount);
        }
        if (removeAmount >= this.totalUnits) {
            int total = this.totalUnits;
            this.clear();
            return total;
        }
        Object2DoubleOpenHashMap resultMap = new Object2DoubleOpenHashMap(this.metalMap.size());
        for (Object2DoubleMap.Entry entry : this.metalMap.object2DoubleEntrySet()) {
            double remove = (double)removeAmount * entry.getDoubleValue() / (double)this.totalUnits;
            if (!(entry.getDoubleValue() > remove)) continue;
            resultMap.put((Object)((Metal)entry.getKey()), entry.getDoubleValue() - remove);
        }
        this.totalUnits -= removeAmount;
        this.metalMap.clear();
        this.metalMap.putAll((Map)resultMap);
        this.updateCaches();
        return removeAmount;
    }

    @Override
    public int getAmount() {
        return this.totalUnits;
    }

    @Override
    public int getMaxUnits() {
        return this.maxUnits;
    }

    @Override
    public Object2DoubleMap<Metal> getMetals() {
        return this.sanitizedMetalMap;
    }

    public CompoundTag serializeNBT() {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128405_("maxUnits", this.maxUnits);
        nbt.m_128405_("totalUnits", this.totalUnits);
        CompoundTag alloys = new CompoundTag();
        for (Object2DoubleMap.Entry entry : this.metalMap.object2DoubleEntrySet()) {
            alloys.m_128347_(((Metal)entry.getKey()).getId().toString(), entry.getDoubleValue());
        }
        nbt.m_128365_("contents", (Tag)alloys);
        return nbt;
    }

    public void deserializeNBT(CompoundTag nbt) {
        this.clear();
        if (nbt.m_128441_("maxUnits")) {
            this.maxUnits = nbt.m_128451_("maxUnits");
        }
        this.totalUnits = nbt.m_128451_("totalUnits");
        CompoundTag contents = nbt.m_128469_("contents");
        for (Metal metal : Metal.MANAGER.getValues()) {
            String key = metal.getId().toString();
            if (!contents.m_128441_(key)) continue;
            this.metalMap.put((Object)metal, contents.m_128459_(key));
        }
        this.updateCaches();
    }

    public boolean matches(AlloyRecipe recipe) {
        if (this.metalMap.containsKey((Object)recipe.getResult())) {
            Alloy other = new Alloy();
            other.add(this);
            other.metalMap.removeDouble((Object)recipe.getResult());
            other.updateCaches();
            return other.matchesExactly(recipe);
        }
        return this.matchesExactly(recipe);
    }

    private void clear() {
        this.metalMap.clear();
        this.sanitizedMetalMap.clear();
        this.totalUnits = 0;
        this.cachedResult = null;
    }

    private void updateCaches() {
        this.cachedResult = null;
        this.sanitizedMetalMap.clear();
        double actualTotalAmount = this.getExactAmount();
        this.metalMap.object2DoubleEntrySet().forEach(entry -> {
            if (entry.getDoubleValue() > actualTotalAmount * 4.656612875245797E-10) {
                this.sanitizedMetalMap.put((Object)((Metal)entry.getKey()), entry.getDoubleValue());
            }
        });
    }

    private double getExactAmount() {
        return this.metalMap.values().doubleStream().sum();
    }

    private AlloyInventory getWrapper() {
        if (this.wrapper == null) {
            this.wrapper = new AlloyInventory(this);
        }
        return this.wrapper;
    }

    private boolean matchesExactly(AlloyRecipe recipe) {
        Object2DoubleMap<Metal> metals = this.getMetals();
        double actualTotalAmount = this.getExactAmount();
        for (Metal metal : Sets.union(recipe.getRanges().keySet(), (Set)metals.keySet())) {
            if (metals.containsKey((Object)metal) && recipe.getRanges().containsKey(metal) && recipe.getRanges().get(metal).isIn(metals.getDouble((Object)metal) / actualTotalAmount, 4.656612875245797E-10)) continue;
            return false;
        }
        return true;
    }
}

